/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.support;

import com.suncode.pwfl.administration.systemMessage.SystemMessage;
import com.suncode.pwfl.administration.systemMessage.SystemMessageService;
import com.suncode.pwfl.administration.user.UserGroup;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.util.exception.ServiceException;
import com.suncode.pwfl.web.dto.administration.systemMessages.SystemMessageDto;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SystemMessageMapper {
    private final SystemMessageService systemMessageService;
    private final UserService userService;
    private final MessageHelperBean messageHelper;

    public SystemMessage toEntity(SystemMessageDto systemMessageDto) {
        String message = StringUtils.trim((String)systemMessageDto.getMessage());
        String sanitizedMessage = this.systemMessageService.sanitizeMessage(message, systemMessageDto.getMessageType());
        List<UserGroup> groups = Optional.ofNullable(systemMessageDto.getGroups()).orElseGet(ArrayList::new).stream().map(this::getUserGroup).toList();
        return SystemMessage.builder().message(sanitizedMessage).messageType(systemMessageDto.getMessageType()).startDate(systemMessageDto.getStartDate() != null ? systemMessageDto.getStartDate() : new Date()).finishDate(systemMessageDto.getFinishDate()).groups(groups).enabled(systemMessageDto.isEnabled()).afterLogin(systemMessageDto.isAfterLogin()).build();
    }

    public SystemMessageDto toDto(SystemMessage systemMessage) {
        List<Long> groups = Optional.ofNullable(systemMessage.getGroups()).orElseGet(ArrayList::new).stream().map(UserGroup::getObjectId).toList();
        return SystemMessageDto.builder().id(systemMessage.getId()).message(systemMessage.getMessage()).messageType(systemMessage.getMessageType()).startDate(systemMessage.getStartDate()).finishDate(systemMessage.getFinishDate()).groups(groups).enabled(systemMessage.isEnabled()).afterLogin(systemMessage.isAfterLogin()).build();
    }

    private UserGroup getUserGroup(Long groupId) {
        return Optional.ofNullable(this.userService.getGroup(groupId, new String[0])).orElseThrow(() -> new ServiceException(this.messageHelper.getMessage("Grupa_o_podanym_id_nie_istnieje", new Object[]{groupId})));
    }

    @ConstructorProperties(value={"systemMessageService", "userService", "messageHelper"})
    @Autowired
    public SystemMessageMapper(SystemMessageService systemMessageService, UserService userService, MessageHelperBean messageHelper) {
        this.systemMessageService = systemMessageService;
        this.userService = userService;
        this.messageHelper = messageHelper;
    }
}

