/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.rest;

import com.suncode.pwfl.license.exceptions.LicenseInvalidException;
import com.suncode.pwfl.license.exceptions.TooManyUsersException;
import com.suncode.pwfl.web.util.JsonMessage;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.connector.ClientAbortException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.NoHandlerFoundException;

@ControllerAdvice
public class RestExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(RestExceptionHandler.class);

    @ExceptionHandler(value={ClientAbortException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ResponseBody
    public void handleClientAbortException(ClientAbortException e, HttpServletResponse response) {
        log.info("Connection has been aborted by an user.");
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ResponseBody
    public JsonMessage handleException(Exception e, HttpServletResponse response) {
        log.error("Unknown error", (Throwable)e);
        return new JsonMessage(false, "unknown error");
    }

    @ExceptionHandler(value={TooManyUsersException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ResponseBody
    public JsonMessage handleException(TooManyUsersException e, HttpServletResponse response) {
        log.warn("Limit zalogowanych u\u017cytkownik\u00f3w wykorzystany.", (Throwable)e);
        return new JsonMessage(false, e.getMessage());
    }

    @ExceptionHandler(value={LicenseInvalidException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ResponseBody
    public JsonMessage handleException(LicenseInvalidException e, HttpServletResponse response) {
        log.warn("", (Throwable)e);
        return new JsonMessage(false, e.getMessage());
    }

    @ExceptionHandler(value={NoHandlerFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ResponseBody
    public JsonMessage handleException(NoHandlerFoundException e) {
        log.warn(e.getMessage());
        return new JsonMessage(false, e.getMessage());
    }
}

