/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.filter;

import com.suncode.pwfl.administration.configuration.DefinedSystemParameter;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.audit.builder.ManualAuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.web.util.SessionUtils;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionFixationSecurityFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(SessionFixationSecurityFilter.class);

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (SystemProperties.getBoolean((DefinedSystemParameter)DefinedSystemParameter.CHECK_SESSION_CREATOR_IP).booleanValue()) {
            if (this.checkRequestIpValid((HttpServletRequest)request, (HttpServletResponse)response)) {
                chain.doFilter(request, response);
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    private boolean checkRequestIpValid(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        HttpSession session = request.getSession(false);
        if (session != null) {
            String ip = request.getRemoteAddr();
            String ipInSession = (String)session.getAttribute("sessionCreatorIP");
            if (ipInSession != null && !ipInSession.equals(ip)) {
                log.info("Wykryto pr\u00f3b\u0119 nieautoryzowanego dost\u0119pu z adresu IP:  " + ip);
                this.buildAudit(ip);
                session.invalidate();
                this.eraseSessionIdCookie(request, response);
                request.getRequestDispatcher("Login.do").forward((ServletRequest)request, (ServletResponse)response);
                return false;
            }
        }
        return true;
    }

    private void buildAudit(String ip) {
        ManualAuditBuilder.getInstance().ipAddress(ip).success(false).type(AuditTypes.AUDIT_SECURITY).username(SessionUtils.getLoggedUserName()).build().log();
    }

    private void eraseSessionIdCookie(HttpServletRequest request, HttpServletResponse response) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals("JSESSIONID")) continue;
                cookie.setValue("");
                response.addCookie(cookie);
                break;
            }
        }
    }

    public void destroy() {
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }
}

