/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.workflow.archive;

import com.suncode.pwfl.archive.AddDirectoryDto;
import com.suncode.pwfl.archive.ArchiveStorageService;
import com.suncode.pwfl.archive.Device;
import com.suncode.pwfl.archive.Directory;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.builder.AuditParamsBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.export.extension.ExportExtension;
import com.suncode.pwfl.export.model.ExportColumn;
import com.suncode.pwfl.export.model.ExportColumnBuilder;
import com.suncode.pwfl.export.model.ExportModel;
import com.suncode.pwfl.export.service.ExportService;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.util.DtoComparator;
import com.suncode.pwfl.util.Paginator;
import com.suncode.pwfl.util.exception.ServiceException;
import com.suncode.pwfl.web.dto.archive.DirectoryDto;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import com.suncode.pwfl.web.security.exception.NotFullRightsException;
import com.suncode.pwfl.web.support.DirectoryMapper;
import com.suncode.pwfl.web.support.ajax.RestResult;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"directories"})
public class DirectoryController {
    private static final Logger log = LoggerFactory.getLogger(DirectoryController.class);
    private final ArchiveStorageService archiveStorageService;
    private final ExportService exportService;
    private final DirectoryMapper directoryMapper;
    private final MessageHelperBean messageHelper;
    private final AuthorizationHelper authorizationHelper;

    @RequestMapping
    @ResponseBody
    public List<DirectoryDto> getDirectories() {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        return this.archiveStorageService.getAllDirectories(new String[]{"device", "rootDir"}).stream().map(directory -> this.directoryMapper.fromEntity((Directory)directory, false)).sorted((Comparator<DirectoryDto>)DtoComparator.of(DirectoryDto.class, (String)"directoryName", (SortDirection)SortDirection.ASC).withIgnoreCase(true)).collect(Collectors.toList());
    }

    @RequestMapping(value={"/counted-result"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<DirectoryDto> getPaginatedDirectories(@RequestParam(required=false) Integer start, @RequestParam(required=false) Integer limit, @RequestParam(required=false, defaultValue="id") String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        return Paginator.forAll(this.getSortedDirectoryDtos(sortBy, sortDirection)).viewPageByOffset(start, limit);
    }

    @RequestMapping(value={"export/{extension}"})
    @ResponseBody
    public void exportDirectories(HttpServletResponse response, @PathVariable String extension, @RequestParam(required=false, defaultValue="id") String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection) throws IOException {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        List<DirectoryDto> directories = this.getSortedDirectoryDtos(sortBy, sortDirection);
        List<ExportColumn> columns = Arrays.asList(this.buildExportColumn(this.messageHelper.getMessage("Nazwa_katalogu"), directories, DirectoryDto::getDirectoryName), this.buildExportColumn(this.messageHelper.getMessage("Katalog_nadrzedny"), directories, directoryDto -> directoryDto.getRootDir() != null ? directoryDto.getRootDir().getDirectoryName() : ""), this.buildExportColumn(this.messageHelper.getMessage("Rozmiar_MB"), directories, directoryDto -> directoryDto.getDirectorySize().toString()), this.buildExportColumn(this.messageHelper.getMessage("Prog_przepelnienia"), directories, directoryDto -> directoryDto.getDirectoryThreshold().toString()), this.buildExportColumn(this.messageHelper.getMessage("Wolne_miejsce_MB"), directories, directoryDto -> directoryDto.getTrueDirectoryFreeSpace().toString()), this.buildExportColumn(this.messageHelper.getMessage("Nazwa_urzadzenia"), directories, directoryDto -> directoryDto.getDevice() != null ? directoryDto.getDevice().getDeviceName() : ""));
        ExportModel model = ExportModel.builder().title(this.messageHelper.getMessage("Katalogi")).columns(columns).build();
        ExportExtension extensionEnum = ExportExtension.valueOf((String)extension.toUpperCase());
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", String.format("attachment; filename=\"export.%s\"", extensionEnum.getExtension()));
        this.exportService.export(model, extensionEnum, (OutputStream)response.getOutputStream());
    }

    private List<DirectoryDto> getSortedDirectoryDtos(String sortBy, SortDirection sortDirection) {
        Map dirsFreeSpace = this.archiveStorageService.getAllDirectoriesFreeSpaceFromDB();
        List<DirectoryDto> mappedDirectories = this.archiveStorageService.getAllDirectories(new String[]{"device", "rootDir"}).stream().map(this.directoryMapper::fromEntity).collect(Collectors.toList());
        mappedDirectories.forEach(directoryDto -> directoryDto.setTrueDirectoryFreeSpace((Long)dirsFreeSpace.get(directoryDto.getId())));
        return mappedDirectories.stream().sorted(DtoComparator.of(DirectoryDto.class, (String)sortBy, (SortDirection)sortDirection).withIgnoreCase(true).withSupport("rootDirectoryName", directoryDto -> directoryDto.getRootDir() != null ? directoryDto.getRootDir().getDirectoryName() : "").withSupport("deviceName", directoryDto -> directoryDto.getDevice() != null ? directoryDto.getDevice().getDeviceName() : "")).collect(Collectors.toList());
    }

    @RequestMapping(method={RequestMethod.POST})
    @ResponseBody
    public RestResult addDirectory(HttpServletRequest request, @RequestBody AddDirectoryDto dto) {
        AuditParamsBuilder auditParamsBuilder = new AuditParamsBuilder().params(this.createAddDirectoryAuditParameters(dto));
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_ADD_DIRECTORY).params(auditParamsBuilder.build());
        this.authorizationHelper.assertFullAdministrationRights(() -> auditBuilder.buildFailure(request));
        try {
            Long id = this.archiveStorageService.addDirectory(this.directoryMapper.fromDto(dto));
            auditParamsBuilder.param("directoryId", (Object)id);
            auditBuilder.params(auditParamsBuilder.build());
            auditBuilder.buildSuccess(request);
            return new RestResult(true);
        }
        catch (Exception e) {
            auditBuilder.buildFailure(request);
            throw new ServiceException(e.getMessage());
        }
    }

    private Map<String, Object> createAddDirectoryAuditParameters(AddDirectoryDto dto) {
        HashMap<String, Object> auditParameters = new HashMap<String, Object>();
        String rootDirectoryName = dto.getRootDirectoryId() != null ? this.archiveStorageService.getDirectory(dto.getRootDirectoryId(), new String[0]).getDirectoryName() : "";
        String deviceName = dto.getDeviceId() != null ? this.archiveStorageService.getDeviceById(dto.getDeviceId(), new String[0]).getDeviceName() : "";
        auditParameters.put("directoryName", dto.getName());
        auditParameters.put("directorySize", dto.getSize());
        auditParameters.put("directoryThreshold", dto.getThreshold());
        auditParameters.put("rootDirectory", rootDirectoryName);
        auditParameters.put("device", deviceName);
        return auditParameters;
    }

    @RequestMapping(value={"{id}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public RestResult deleteDirectory(HttpServletRequest request, @PathVariable Long id) {
        AuditParamsBuilder auditParamsBuilder = new AuditParamsBuilder().param("directoryId", (Object)id);
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_DIRECTORY).params(auditParamsBuilder.build());
        this.authorizationHelper.assertFullAdministrationRights(() -> auditBuilder.buildFailure(request));
        Directory directory = this.archiveStorageService.getDirectory(id, new String[]{"device", "rootDir"});
        if (directory == null) {
            auditBuilder.buildFailure(request);
            throw new ServiceException(this.messageHelper.getMessage("Nie_znaleziono_katalogu", new Object[]{id}));
        }
        auditParamsBuilder.params(this.createDeleteDirectoryAuditParameters(directory));
        auditBuilder.params(auditParamsBuilder.build());
        try {
            this.archiveStorageService.deleteDirectory(directory.getId());
            auditBuilder.buildSuccess(request);
            return new RestResult(true);
        }
        catch (Exception e) {
            auditBuilder.buildFailure(request);
            throw new ServiceException(e.getMessage());
        }
    }

    @RequestMapping(value={"{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public DirectoryDto getDirectory(@PathVariable Long id) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        Directory directory = Optional.ofNullable(this.archiveStorageService.getDirectory(id, new String[]{"device", "rootDir"})).orElseThrow(() -> new ServiceException(this.messageHelper.getMessage("Nie_znaleziono_katalogu", new Object[]{id})));
        return this.directoryMapper.fromEntity(directory, false);
    }

    @RequestMapping(value={"{id}"}, method={RequestMethod.PATCH})
    @ResponseBody
    public RestResult updateDirectory(HttpServletRequest request, @PathVariable Long id, @RequestBody AddDirectoryDto directoryDto) {
        AuditParamsBuilder auditParamsBuilder = new AuditParamsBuilder().param("directoryId", (Object)id);
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_UPDATE_DIRECTORY).params(auditParamsBuilder.build());
        this.authorizationHelper.assertFullAdministrationRights(() -> auditBuilder.buildFailure(request));
        Directory oldDirectory = this.archiveStorageService.getDirectory(id, new String[]{"rootDir", "device"});
        if (oldDirectory == null) {
            auditBuilder.buildFailure(request);
            throw new ServiceException(this.messageHelper.getMessage("Katalog_o_podanym_id_nie_istnieje"));
        }
        auditParamsBuilder.params(this.createUpdateDirectoryAuditParameters(directoryDto, oldDirectory));
        auditBuilder.params(auditParamsBuilder.build());
        try {
            this.archiveStorageService.updateDirectory(id, this.directoryMapper.fromDto(directoryDto));
            auditBuilder.buildSuccess(request);
            return new RestResult(true);
        }
        catch (Exception e) {
            auditBuilder.buildFailure(request);
            throw new ServiceException(e.getMessage());
        }
    }

    private Map<String, Object> createUpdateDirectoryAuditParameters(AddDirectoryDto directoryDto, Directory oldDirectory) {
        HashMap<String, Object> auditParameters = new HashMap<String, Object>();
        auditParameters.put("directoryName", String.format("%s", oldDirectory.getDirectoryName()));
        auditParameters.put("directorySize", String.format("%s;%s", oldDirectory.getDirectorySize(), directoryDto.getSize()));
        auditParameters.put("directoryThreshold", String.format("%s;%s", oldDirectory.getDirectoryThreshold(), directoryDto.getThreshold()));
        auditParameters.put("rootDirectory", Optional.ofNullable(oldDirectory.getRootDir()).map(Directory::getDirectoryName).orElse(""));
        auditParameters.put("device", Optional.ofNullable(oldDirectory.getDevice()).map(Device::getDeviceName).orElse(""));
        return auditParameters;
    }

    private Map<String, Object> createDeleteDirectoryAuditParameters(Directory directory) {
        HashMap<String, Object> auditParameters = new HashMap<String, Object>();
        auditParameters.put("directoryName", directory.getDirectoryName());
        auditParameters.put("directorySize", directory.getDirectorySize());
        auditParameters.put("directoryThreshold", directory.getDirectoryThreshold());
        auditParameters.put("rootDirectory", Optional.ofNullable(directory.getRootDir()).map(Directory::getDirectoryName).orElse(""));
        auditParameters.put("device", Optional.ofNullable(directory.getDevice()).map(Device::getDeviceName).orElse(""));
        return auditParameters;
    }

    private ExportColumn buildExportColumn(String name, List<DirectoryDto> data, Function<DirectoryDto, String> supplier) {
        return ExportColumnBuilder.create().name(name).data(data).by(supplier).build();
    }

    @ExceptionHandler(value={ServiceException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public RestResult handleServiceException(ServiceException e) {
        log.info(e.getMessage(), (Throwable)e);
        return new RestResult(false, e.getMessage());
    }

    @ExceptionHandler(value={NotFullRightsException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    @ResponseBody
    public RestResult handleUnauthorizedRequests(NotFullRightsException e) {
        log.info(this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
        return new RestResult(false, this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
    }

    @ConstructorProperties(value={"archiveStorageService", "exportService", "directoryMapper", "messageHelper", "authorizationHelper"})
    @Autowired
    public DirectoryController(ArchiveStorageService archiveStorageService, ExportService exportService, DirectoryMapper directoryMapper, MessageHelperBean messageHelper, AuthorizationHelper authorizationHelper) {
        this.archiveStorageService = archiveStorageService;
        this.exportService = exportService;
        this.directoryMapper = directoryMapper;
        this.messageHelper = messageHelper;
        this.authorizationHelper = authorizationHelper;
    }
}

