/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.calendar.exception;

import com.suncode.pwfl.administration.user.exception.UserNotFoundException;
import com.suncode.pwfl.calendar.exception.CalendarNotFoundException;
import com.suncode.pwfl.calendar.exception.CalendarProcessNotFoundException;
import com.suncode.pwfl.calendar.exception.CalendarRuntimeException;
import com.suncode.pwfl.calendar.exception.EmptyPropertyCalendarException;
import com.suncode.pwfl.calendar.exception.EventNotFoundException;
import com.suncode.pwfl.calendar.exception.EventsFetchException;
import com.suncode.pwfl.calendar.exception.EventsMappingException;
import com.suncode.pwfl.calendar.exception.ExternalCalendarNotFoundException;
import com.suncode.pwfl.calendar.exception.ExternalCalendarShareAlreadyExistsException;
import com.suncode.pwfl.calendar.exception.ExternalCalendarShareNotFoundException;
import com.suncode.pwfl.calendar.exception.ExternalCalendarSyncException;
import com.suncode.pwfl.calendar.exception.IllegalArgumentCalendarException;
import com.suncode.pwfl.calendar.exception.InvalidDateVariableException;
import com.suncode.pwfl.calendar.exception.ProcessCalendarShareAlreadyExistsException;
import com.suncode.pwfl.calendar.exception.ProcessCalendarShareNotFoundException;
import com.suncode.pwfl.calendar.exception.ResolvingProcessVariableTypeException;
import com.suncode.pwfl.calendar.exception.ResolvingViewVariableTypeException;
import com.suncode.pwfl.calendar.exception.UnauthorizedCalendarOperationException;
import com.suncode.pwfl.calendar.exception.UnauthorizedEventOperationException;
import com.suncode.pwfl.calendar.exception.UnauthorizedProcessException;
import com.suncode.pwfl.calendar.exception.UnauthorizedViewException;
import com.suncode.pwfl.calendar.exception.UserCalendarEventParticipantNotFoundException;
import com.suncode.pwfl.calendar.exception.UserCalendarShareAlreadyExistsException;
import com.suncode.pwfl.calendar.exception.UserCalendarShareNotFoundException;
import com.suncode.pwfl.calendar.exception.ViewCalendarShareAlreadyExistsException;
import com.suncode.pwfl.calendar.exception.ViewCalendarShareNotFoundException;
import com.suncode.pwfl.calendar.exception.ViewNotFoundException;
import com.suncode.pwfl.calendar.exception.ViewVariableNotFoundException;
import com.suncode.pwfl.calendar.processReservation.exception.ProcessDoesNotExistException;
import com.suncode.pwfl.calendar.processReservation.exception.StartDateAfterEndDateException;
import com.suncode.pwfl.calendar.resource.exception.CalendarResourceGroupNotEmptyException;
import com.suncode.pwfl.calendar.resource.exception.CalendarResourceGroupNotFoundException;
import com.suncode.pwfl.calendar.resource.exception.CalendarResourceGroupPermissionException;
import com.suncode.pwfl.calendar.resource.exception.CalendarResourceInactiveException;
import com.suncode.pwfl.calendar.resource.exception.CalendarResourceNotFoundException;
import com.suncode.pwfl.calendar.resource.exception.CalendarResourceOccupiedException;
import com.suncode.pwfl.calendar.resource.exception.CalendarResourcePermissionException;
import com.suncode.pwfl.calendar.resource.exception.CalendarResourceShareAlreadyExistsException;
import com.suncode.pwfl.calendar.resource.exception.CalendarResourceShareNotFoundException;
import com.suncode.pwfl.calendar.resource.exception.UserGroupNotFoundException;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.support.ParametrizedEmptyPropertyException;
import com.suncode.pwfl.support.ParametrizedRuntimeException;
import com.suncode.pwfl.util.exception.EmptyPropertyException;
import com.suncode.pwfl.web.controller.api.calendar.exception.CalendarExceptionMessageHelper;
import com.suncode.pwfl.web.support.ajax.RestResult;
import java.beans.ConstructorProperties;
import java.time.format.DateTimeParseException;
import org.dmfs.rfc5545.recur.InvalidRecurrenceRuleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@ControllerAdvice(basePackages={"com.suncode.pwfl.web.controller.api.calendar"})
public class CalendarExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(CalendarExceptionHandler.class);
    private final CalendarExceptionMessageHelper calendarExceptionMessageHelper;
    private final MessageHelperBean messageHelper;

    @ExceptionHandler(value={IllegalArgumentException.class, EmptyPropertyException.class, DateTimeParseException.class, ResolvingProcessVariableTypeException.class, UserNotFoundException.class, UserGroupNotFoundException.class, InvalidRecurrenceRuleException.class, CalendarResourceShareAlreadyExistsException.class, CalendarResourceGroupNotEmptyException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public RestResult handleBadRequestException(Exception e) {
        log.info(e.getMessage(), (Throwable)e);
        return new RestResult(false, e.getMessage());
    }

    @ExceptionHandler(value={CalendarResourceInactiveException.class, CalendarResourceOccupiedException.class, ParametrizedEmptyPropertyException.class, StartDateAfterEndDateException.class, ProcessDoesNotExistException.class, ResolvingViewVariableTypeException.class, ViewVariableNotFoundException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public RestResult handleBadRequestParametrizedException(ParametrizedRuntimeException e) {
        String exceptionMessage = this.messageHelper.getMessage(e.getMessageKey(), e.getParameters());
        log.info(exceptionMessage, (Throwable)e);
        return new RestResult(false, exceptionMessage);
    }

    @ExceptionHandler(value={IllegalArgumentCalendarException.class, EmptyPropertyCalendarException.class, InvalidDateVariableException.class, ViewNotFoundException.class, EventsFetchException.class, EventsMappingException.class, UserCalendarShareAlreadyExistsException.class, ViewCalendarShareAlreadyExistsException.class, ProcessCalendarShareAlreadyExistsException.class, ExternalCalendarShareAlreadyExistsException.class, ExternalCalendarSyncException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public RestResult handleBadRequestCalendarRuntimeException(CalendarRuntimeException e) {
        String message = this.calendarExceptionMessageHelper.getCalendarExceptionMessage(e);
        log.info(message, (Throwable)e);
        return new RestResult(false, message);
    }

    @ExceptionHandler(value={CalendarNotFoundException.class, EventNotFoundException.class, CalendarResourceGroupNotFoundException.class, UserCalendarEventParticipantNotFoundException.class, CalendarResourceShareNotFoundException.class, UserCalendarShareNotFoundException.class, ViewCalendarShareNotFoundException.class, ProcessCalendarShareNotFoundException.class, ExternalCalendarNotFoundException.class, ExternalCalendarShareNotFoundException.class, CalendarProcessNotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ResponseBody
    public RestResult handleNotFoundException(Exception e) {
        log.info(e.getMessage(), (Throwable)e);
        return new RestResult(false, e.getMessage());
    }

    @ExceptionHandler(value={CalendarResourceNotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ResponseBody
    public RestResult handleNotFoundParametrizedException(ParametrizedRuntimeException e) {
        String exceptionMessage = this.messageHelper.getMessage(e.getMessageKey(), e.getParameters());
        log.info(exceptionMessage, (Throwable)e);
        return new RestResult(false, exceptionMessage);
    }

    @ExceptionHandler(value={UnauthorizedCalendarOperationException.class, UnauthorizedEventOperationException.class, CalendarResourceGroupPermissionException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ResponseBody
    public RestResult handleForbiddenException(Exception e) {
        log.info(e.getMessage(), (Throwable)e);
        return new RestResult(false, e.getMessage());
    }

    @ExceptionHandler(value={CalendarResourcePermissionException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ResponseBody
    public RestResult handleForbiddenParametrizedException(ParametrizedRuntimeException e) {
        String exceptionMessage = this.messageHelper.getMessage(e.getMessageKey(), e.getParameters());
        log.info(exceptionMessage, (Throwable)e);
        return new RestResult(false, exceptionMessage);
    }

    @ExceptionHandler(value={UnauthorizedProcessException.class, UnauthorizedViewException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ResponseBody
    public RestResult handleUnauthorizedCalendarRuntimeException(CalendarRuntimeException e) {
        String message = this.calendarExceptionMessageHelper.getCalendarExceptionMessage(e);
        log.info(message, (Throwable)e);
        return new RestResult(false, message);
    }

    @ConstructorProperties(value={"calendarExceptionMessageHelper", "messageHelper"})
    public CalendarExceptionHandler(CalendarExceptionMessageHelper calendarExceptionMessageHelper, MessageHelperBean messageHelper) {
        this.calendarExceptionMessageHelper = calendarExceptionMessageHelper;
        this.messageHelper = messageHelper;
    }
}

