/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.administration.email;

import com.google.common.collect.ImmutableMap;
import com.suncode.pwfl.administration.email.oauth.OAuth2Service;
import com.suncode.pwfl.administration.email.oauth.client.OAuth2AuthenticationMethod;
import com.suncode.pwfl.administration.email.oauth.client.OAuth2Client;
import com.suncode.pwfl.administration.email.oauth.client.OAuth2ClientService;
import com.suncode.pwfl.administration.email.oauth.connection.OAuth2Connection;
import com.suncode.pwfl.administration.email.oauth.connection.OAuth2ConnectionService;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.util.exception.ServiceException;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import com.suncode.pwfl.web.support.ajax.RestResult;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"/oauth/connections"})
public class OAuth2ConnectionController {
    private static final Logger log = LoggerFactory.getLogger(OAuth2ConnectionController.class);
    @Autowired
    private OAuth2ConnectionService oAuth2ConnectionService;
    @Autowired
    private OAuth2ClientService oAuth2ClientService;
    @Autowired
    private OAuth2Service oAuth2Service;
    @Autowired
    private AuthorizationHelper authorizationHelper;
    @Autowired
    private MessageHelperBean messageHelperBean;

    @ResponseBody
    @RequestMapping(value={"/{id}"}, method={RequestMethod.DELETE})
    public ResponseEntity<?> delete(@PathVariable Long id, HttpServletRequest request) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_OAUTH2_CONNECTION);
        this.authorizationHelper.assertFullAdministrationRights(() -> request.setAttribute("audit", (Object)auditBuilder.buildFailure()));
        auditBuilder.params((Map)ImmutableMap.of((Object)"OAUTH2_CONNECTION_ID", (Object)id));
        try {
            OAuth2Connection oAuth2Connection = Optional.ofNullable((OAuth2Connection)this.oAuth2ConnectionService.get((Serializable)id)).orElseThrow(() -> new ServiceException(this.messageHelperBean.getMessage("Nie_znaleziono_polaczenia_oauth_o_podanym_identyfikatorze", new Object[]{id})));
            if (this.oAuth2ConnectionService.isConnectionInUse(oAuth2Connection)) {
                throw new ServiceException(this.messageHelperBean.getMessage("oauth_connection_used_error"));
            }
            this.oAuth2ConnectionService.delete((Object)oAuth2Connection);
            request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
            return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
    }

    @RequestMapping(value={""}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<?> connect(@RequestParam Long clientId) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        OAuth2Client oAuth2Client = Optional.ofNullable((OAuth2Client)this.oAuth2ClientService.get((Serializable)clientId, new String[]{"connections"})).orElseThrow(() -> new ServiceException(this.messageHelperBean.getMessage("Nie_znaleziono_klienta_oauth_o_podanym_identyfikatorze", new Object[]{clientId})));
        if (oAuth2Client.getAuthenticationMethod() != OAuth2AuthenticationMethod.CLIENT_CREDENTIALS) {
            throw new ServiceException(this.messageHelperBean.getMessage("Nieprawidlowa_metoda_autentykacji_klienta"));
        }
        if (oAuth2Client.getConnections().size() != 0) {
            throw new ServiceException(this.messageHelperBean.getMessage("Ten_klient_moze_miec_tylko_jedno_polaczenie"));
        }
        OAuth2Connection connection = this.oAuth2Service.addNewConnection(oAuth2Client);
        return new ResponseEntity((Object)connection, (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"/refresh"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<?> refreshConnection(@RequestParam Long connectionId) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        OAuth2Connection oAuth2Connection = Optional.ofNullable((OAuth2Connection)this.oAuth2ConnectionService.get((Serializable)connectionId)).orElseThrow(() -> new ServiceException(this.messageHelperBean.getMessage("Nie_znaleziono_polaczenia_oauth_o_podanym_identyfikatorze", new Object[]{connectionId})));
        OAuth2Client oAuth2Client = Optional.ofNullable((OAuth2Client)this.oAuth2ClientService.get((Serializable)oAuth2Connection.getClientId(), new String[]{"connections"})).orElseThrow(() -> new ServiceException(this.messageHelperBean.getMessage("Nie_znaleziono_klienta_oauth_o_podanym_identyfikatorze", new Object[]{oAuth2Connection.getClientId()})));
        if (oAuth2Client.getAuthenticationMethod() != OAuth2AuthenticationMethod.CLIENT_CREDENTIALS) {
            throw new ServiceException(this.messageHelperBean.getMessage("Nieprawidlowa_metoda_autentykacji_klienta"));
        }
        this.oAuth2Service.refreshConnection(oAuth2Connection);
        return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
    }

    @ExceptionHandler(value={ServiceException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public RestResult handleServiceException(ServiceException e) {
        log.info(e.getMessage());
        return new RestResult(false, e.getMessage());
    }
}

