/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web;

import com.suncode.plugin.framework.Module;
import com.suncode.plugin.framework.ModuleAccessor;
import com.suncode.pwfl.administration.configuration.DefinedSystemParameter;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.plugin.modules.UnauthorizedUrl;
import com.suncode.pwfl.util.SpringContext;
import com.suncode.pwfl.web.filter.BasicAuthFilter;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterRegistration;
import jakarta.servlet.ServletContext;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.web.csrf.CsrfFilter;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.security.web.csrf.CsrfTokenRequestHandler;
import org.springframework.security.web.csrf.HttpSessionCsrfTokenRepository;
import org.springframework.security.web.csrf.XorCsrfTokenRequestAttributeHandler;
import org.springframework.web.WebApplicationInitializer;
import org.springframework.web.util.UrlPathHelper;

@Configuration
public class SecurityConfig
implements WebApplicationInitializer {
    public static final String CSRF_REQUEST_ATTRIBUTE = "_csrf";
    private static final CsrfTokenRepository CSRF_TOKEN_REPOSITORY = new HttpSessionCsrfTokenRepository();
    private static final CsrfTokenRequestHandler CSRF_TOKEN_REQUEST_HANDLER = SecurityConfig.createCsrfTokenRequestHandler();
    private static UrlPathHelper PATH_HELPER = new UrlPathHelper();
    private static List<String> EXCLUDED_PATHS = Arrays.asList("/api/authentication/sso/login", "/api/authentication/sso/logout", "/sso/login", "/api/autoLogin");

    private static XorCsrfTokenRequestAttributeHandler createCsrfTokenRequestHandler() {
        XorCsrfTokenRequestAttributeHandler tokenRequestAttributeHandler = new XorCsrfTokenRequestAttributeHandler();
        tokenRequestAttributeHandler.setCsrfRequestAttributeName(CSRF_REQUEST_ATTRIBUTE);
        return tokenRequestAttributeHandler;
    }

    @Bean
    public CsrfTokenRepository csrfTokenRepository() {
        return CSRF_TOKEN_REPOSITORY;
    }

    @Bean
    public CsrfTokenRequestHandler csrfTokenRequestHandler() {
        return CSRF_TOKEN_REQUEST_HANDLER;
    }

    public void onStartup(ServletContext servletContext) {
        CsrfFilter filter = new CsrfFilter(CSRF_TOKEN_REPOSITORY);
        filter.setRequireCsrfProtectionMatcher(request -> {
            if (!SystemProperties.getBoolean((DefinedSystemParameter)DefinedSystemParameter.CSRF_PROTECTION_ENABLED).booleanValue()) {
                return false;
            }
            String requestUrl = PATH_HELPER.getPathWithinApplication(request);
            if (EXCLUDED_PATHS.contains(requestUrl)) {
                return false;
            }
            if (this.isExcludedByPlugin(requestUrl)) {
                return false;
            }
            if (BasicAuthFilter.isBasicAuthRequest(request)) {
                return false;
            }
            return !Arrays.asList("GET", "HEAD", "TRACE", "OPTIONS").contains(request.getMethod());
        });
        filter.setRequestHandler(CSRF_TOKEN_REQUEST_HANDLER);
        FilterRegistration.Dynamic registration = servletContext.addFilter("csrf-filter", (Filter)filter);
        registration.addMappingForServletNames(EnumSet.allOf(DispatcherType.class), false, new String[]{"api-servlet", "action-servlet", "customServlet", "jsp"});
        registration.addMappingForUrlPatterns(EnumSet.allOf(DispatcherType.class), false, new String[]{"/plugin/*"});
    }

    private boolean isExcludedByPlugin(String path) {
        ModuleAccessor moduleAccessor = (ModuleAccessor)SpringContext.getBean(ModuleAccessor.class);
        for (Module module : moduleAccessor.getModules(UnauthorizedUrl.class)) {
            if (!path.startsWith(((UnauthorizedUrl)module.getObject()).getUnauthorizedUrl())) continue;
            return true;
        }
        return false;
    }
}

