/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.object;

import com.plusmpm.util.SharkFunctions;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.workflow.activity.Activity;
import org.apache.log4j.Logger;
import org.enhydra.shark.Shark;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.client.wfservice.AdminMisc;

public class ActivityDef {
    public static final Logger log = Logger.getLogger(ActivityDef.class);
    private String processId;
    private String activityId;
    private String processDefId;
    private String activityDefId;
    private String processName;
    private String activityName;

    public ActivityDef() {
    }

    public ActivityDef(String processId, String activityId) {
        this.processId = processId;
        this.activityId = activityId;
        this.setProcessAndActivityDefIds();
        this.setProcessAndActivityNames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setProcessAndActivityDefIds() {
        AdminMisc am = null;
        SharkTransaction st = null;
        try {
            st = Shark.getInstance().createTransaction();
            am = Shark.getInstance().getAdminInterface().getAdminMisc();
            this.processDefId = am.getProcessDefinitionId(st, this.processId);
            this.activityDefId = am.getActivityDefinitionId(st, this.processId, this.activityId);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (st != null) {
                SharkFunctions.ClearSharkTransaction((SharkTransaction)st);
            }
        }
    }

    public void resolveProcessAndActivityNames(String processDefId, String activityDefId) {
        this.processDefId = processDefId;
        this.activityDefId = activityDefId;
        this.setProcessAndActivityNames();
    }

    private void setProcessAndActivityNames() {
        try {
            Activity activity = ServiceFactory.getActivityService().getActivity(this.processId, this.activityId, new String[]{"process"});
            this.processName = activity.getProcess().getName();
            this.activityName = activity.getName();
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            this.processName = new String(this.processDefId);
            this.activityName = new String(this.activityDefId);
        }
    }

    public String getProcessId() {
        return this.processId;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    public String getActivityId() {
        return this.activityId;
    }

    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    public String getProcessDefId() {
        return this.processDefId;
    }

    public void setProcessDefId(String processDefId) {
        this.processDefId = processDefId;
    }

    public String getActivityDefId() {
        return this.activityDefId;
    }

    public void setActivityDefId(String activityDefId) {
        this.activityDefId = activityDefId;
    }

    public String getProcessName() {
        return this.processName;
    }

    public void setProcessName(String processName) {
        this.processName = processName;
    }

    public String getActivityName() {
        return this.activityName;
    }

    public void setActivityName(String activityName) {
        this.activityName = activityName;
    }
}

