/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.struts.action.reports;

import com.plusmpm.database.DBManagement;
import com.plusmpm.database.ReportsTable;
import com.plusmpm.i18n.I18N;
import com.suncode.pwfl.report.ReportService;
import com.suncode.pwfl.translation.configElements.TranslatedFieldType;
import com.suncode.pwfl.util.ServiceFactory;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.springframework.context.i18n.LocaleContextHolder;

public class ReportsMgmtAction
extends Action {
    public static Logger log = Logger.getLogger(ReportsMgmtAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            HttpSession session = request.getSession(false);
            if (session == null || session.getAttribute("username") == null) {
                return mapping.findForward("disconnect");
            }
            String sUserName = (String)session.getAttribute("username");
            I18N i18n = new I18N(LocaleContextHolder.getLocale());
            DBManagement dbm = new DBManagement();
            ReportService reportService = ServiceFactory.getReportService();
            ArrayList alUserViews = dbm.GetAllReportsForUserWithType(sUserName, "all");
            for (Object report : alUserViews) {
                ReportsTable reportTable = (ReportsTable)report;
                reportTable.setI18n(i18n);
                reportTable.setReportName(reportService.getReportTranslation(reportTable.getId(), TranslatedFieldType.NAME));
                reportTable.setReportDescr(reportService.getReportTranslation(reportTable.getId(), TranslatedFieldType.DESCRIPTION));
            }
            request.setAttribute("alReports", (Object)alUserViews);
            return mapping.findForward("showReportsList");
        }
        catch (Exception e) {
            log.error((Object)("Exception:" + e.getLocalizedMessage()), (Throwable)e);
            return null;
        }
    }
}

