IF OBJECT_ID( 'copy_docids', 'P' ) IS NOT NULL
	DROP PROCEDURE copy_docids;
GO
CREATE PROCEDURE copy_docids AS
	DECLARE @activityid decimal(19,0),
			@ids varchar(MAX),
			@id varchar(255),
			@fileid numeric(19,0);

	-- Deklaracja kursora przechowujące objectid procesu oraz DocIds'y
	DECLARE list_row CURSOR LOCAL FOR
		SELECT activity as activityid, variablevaluevchar AS ids
		FROM activitydata
		WHERE variabledefinitionid='DocIds'
		  AND variablevaluevchar IS NOT NULL
		  AND variablevaluevchar != '';

	DECLARE @xml xml;

	-- Przechodzi przez wszystkie wiersze z procesami, które zawierają DocIds
	OPEN list_row;
	FETCH NEXT FROM list_row INTO @activityid, @ids;
    WHILE @@FETCH_STATUS = 0 
    BEGIN
		SET @xml = N'<root><r>' + replace(@ids,',','</r><r>') + '</r></root>'

		-- Rozbija DocIds do tablicy
		DECLARE list_ids CURSOR LOCAL FOR
			SELECT t.value('.','varchar(50)') AS [delimited items] 
			FROM @xml.nodes('//root/r') AS a(t);

		-- Przechodzi przez wszystkie DocIds dla dane procesu
		OPEN list_ids;
		FETCH NEXT FROM list_ids INTO @id;
		WHILE @@FETCH_STATUS = 0 
		BEGIN
				SET @fileid=Convert(numeric(19,0),@id); 
				BEGIN TRY
					INSERT INTO pm_activity_document (activity,fileid) VALUES( @activityid, @fileid );	
				END TRY
				-- Może wystąpić wyjątek z powodu już nie istniejące dokumentu w pm_files lub już z itniejące wpisu ;)
				BEGIN CATCH
					PRINT '-- Pomijam dodawanie DocIds: ' + @id;
				END CATCH
				FETCH NEXT FROM list_ids INTO @id;
		END
		CLOSE list_ids;
		DEALLOCATE list_ids;
		
		FETCH NEXT FROM list_row INTO @activityid, @ids;
	END
	CLOSE list_row;
	DEALLOCATE list_row;
;
GO

EXEC copy_docids;
GO

--uaktualnia koloumne process w pm_activity_document
update  pm_activity_document set process=(select a.process from activities a where pm_activity_document.activity=oid) where process is null;
GO
--uaktualnia koloumny date,userid,version w pm_activity_document
update  pm_activity_document  set date=file_date,userid=ut.oid,version=fv.id
from pm_files f join usertable ut on ut.userid=f.uploader join pm_file_versions fv on fv.fileid=f.id  where pm_activity_document.fileid=f.id 
and pm_activity_document.date is null or pm_activity_document.userid is null or pm_activity_document.version is null;

ALTER TABLE pm_activity_document alter column process decimal(19,0) not null;
ALTER TABLE pm_activity_document alter column userid decimal(19,0) not null;
ALTER TABLE pm_activity_document alter column version numeric(19,0) not null;
ALTER TABLE pm_activity_document alter column date datetime not null;
GO

DROP PROCEDURE copy_docids;
GO