/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.webapp.maintenance;

import com.google.common.hash.Hashing;
import com.suncode.pwfl.webapp.maintenance.MaintenanceStatus;
import com.suncode.pwfl.webapp.maintenance.Page;
import gg.jte.TemplateEngine;
import gg.jte.TemplateOutput;
import gg.jte.output.PrintWriterOutput;
import jakarta.servlet.http.HttpServletResponse;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import lombok.NonNull;
import org.springframework.http.CacheControl;

public class MaintenancePage
implements Page<MaintenanceStatus> {
    private static final String NAME = "maintenance/maintenance.jte";
    private final String contextPath;
    private final TemplateEngine templateEngine;

    MaintenancePage(@NonNull TemplateEngine templateEngine, @NonNull String contextPath) {
        if (templateEngine == null) {
            throw new NullPointerException("templateEngine is marked non-null but is null");
        }
        if (contextPath == null) {
            throw new NullPointerException("contextPath is marked non-null but is null");
        }
        this.contextPath = contextPath;
        this.templateEngine = templateEngine;
    }

    @Override
    public void render(@NonNull MaintenanceStatus model, @NonNull HttpServletResponse response) {
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        response.setContentType("text/html");
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        response.setHeader("Cache-Control", CacheControl.noCache().getHeaderValue());
        String etag = MaintenancePage.weakEtag(model);
        response.setHeader("ETag", etag);
        Map<String, String> params = Map.of("model", model, "contextPath", this.contextPath, "etag", etag);
        this.templateEngine.render(NAME, params, (TemplateOutput)new PrintWriterOutput(response.getWriter()));
    }

    @NonNull
    private static String weakEtag(@NonNull MaintenanceStatus model) {
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        return "W/\"%s\"".formatted(Hashing.md5().hashString((CharSequence)model.status(), StandardCharsets.UTF_8).toString());
    }
}

