/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.webapp.controllers.documents.show;

import com.plusmpm.database.DBManagement;
import com.plusmpm.database.IndexTable;
import com.plusmpm.util.DocumentData;
import com.plusmpm.util.HttpHeaders;
import com.plusmpm.util.Tools;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.FileService;
import com.suncode.pwfl.archive.Link;
import com.suncode.pwfl.archive.LinkConnection;
import com.suncode.pwfl.archive.LinkIndex;
import com.suncode.pwfl.archive.LinkService;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.workflow.archiver.ZipArchiverManager;
import com.suncode.pwfl.workflow.cipher.CipherManager;
import com.suncode.pwfl.workflow.support.DownloadFileEventManager;
import com.suncode.pwfl.workflow.support.MSWordFileCustomProperties;
import com.suncode.pwfl.workflow.support.OpenedFileContext;
import com.suncode.pwfl.workflow.support.ReadFileEventManager;
import java.beans.ConstructorProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class ShowFileController {
    private static final Logger log = LoggerFactory.getLogger(ShowFileController.class);
    private final LinkService linkService;
    private final FileService fileService;
    private final MessageHelperBean messageHelper;
    private final DocumentClassService documentClassService;

    @RequestMapping(value={"ShowFile.do"})
    public String showFile(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String fileName = request.getParameter("fileName");
        String encodedFileId = Tools.decodeStringBase64((String)fileName);
        String processId = request.getParameter("processId");
        String activityId = request.getParameter("activityId");
        String processRightKey = request.getParameter("key");
        String applet = request.getParameter("applet");
        String userName = (String)request.getSession().getAttribute("username");
        String userAgent = request.getHeader("User-Agent");
        if ("true".equals(applet)) {
            WfFile wfFile = this.fileService.getFile(new Long(encodedFileId), new String[]{"documentClass", "version"});
            String filePath = wfFile.getFullPath();
            File file = new File(filePath);
            String orgFileName = wfFile.getFileName();
            InputStream fileInputStream = new FileInputStream(file);
            fileInputStream = ZipArchiverManager.uncompress((InputStream)fileInputStream, (WfFile)wfFile);
            fileInputStream = CipherManager.decryptFile((InputStream)fileInputStream, (WfFile)wfFile);
            String sMimeType = Tools.MIMETYPES_FILE_TYPE_MAP.getContentType(file);
            OpenedFileContext fileContext = ReadFileEventManager.execute((InputStream)fileInputStream, (WfFile)wfFile, (String)sMimeType, (String)processId, (String)activityId, (String)userName);
            fileContext = DownloadFileEventManager.execute((OpenedFileContext)fileContext);
            fileInputStream = fileContext.getInputStream();
            fileInputStream = MSWordFileCustomProperties.addProperties((InputStream)fileInputStream, (WfFile)wfFile);
            ServletOutputStream outputStream = response.getOutputStream();
            this.setupResponseHeader(response, fileContext.getExtension(), fileContext.getFileName().replaceAll("[<>:\"/\\\\|?*]", "_"), fileInputStream.available());
            if (userAgent.contains("MSIE 8.0") || userAgent.contains("MSIE 7.0")) {
                response.setHeader("Cache-Control", "public");
            }
            int j = 0;
            while ((j = fileInputStream.read()) != -1) {
                outputStream.write(j);
            }
            outputStream.flush();
            outputStream.close();
            fileInputStream.close();
            if (fileContext.getInputStream() != null) {
                fileContext.getInputStream().close();
            }
            return null;
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)processId) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)activityId)) {
            return String.format("redirect:/documents/showForActivity.do?fileName=%s&processId=%s&activityId=%s&processRightKey=%s", fileName, processId, activityId, processRightKey);
        }
        return String.format("redirect:/documents/%s/show.do?processId=%s&activityId=%s&processRightKey=%s", encodedFileId, processId, activityId, processRightKey);
    }

    @RequestMapping(value={"ShowDocumentFromArchive.do"})
    public String showDocumentFromArchive(HttpServletRequest request) throws Exception {
        Optional linkIndex;
        String searchObjectName;
        String searchType = request.getParameter("type");
        String searchObject = request.getParameter("object");
        String searchIndexId = request.getParameter("index");
        String searchObjectValue = request.getParameter("value");
        DBManagement dbm = new DBManagement();
        if (searchObject == null) {
            searchObjectName = request.getParameter("objectName");
            if ("link".equalsIgnoreCase(searchType)) {
                Link link = this.linkService.getByName(searchObjectName, new String[0]);
                if (link != null) {
                    searchObject = link.getId().toString();
                } else {
                    log.error("Document set [{}] does not exist. Cannot show document.", (Object)searchObjectName);
                    request.setAttribute("message", (Object)(this.messageHelper.getMessage("Klasa_dokumentu_nie_istnieje") + "!"));
                    request.setAttribute("messageType", (Object)"error");
                    return "/archive/showFileMessage.jsp";
                }
            }
            if ("docclass".equalsIgnoreCase(searchType)) {
                DocumentClass documentClass = this.documentClassService.getDocumentClass(searchObjectName, new String[0]);
                if (documentClass != null) {
                    searchObject = documentClass.getId().toString();
                } else {
                    log.error("Document class [{}] does not exist. Cannot show document.", (Object)searchObjectName);
                    request.setAttribute("message", (Object)(this.messageHelper.getMessage("Klasa_dokumentu_nie_istnieje") + "!"));
                    request.setAttribute("messageType", (Object)"error");
                    return "/archive/showFileMessage.jsp";
                }
            }
        }
        if (searchIndexId == null) {
            searchObjectName = request.getParameter("indexName");
            if ("link".equalsIgnoreCase(searchType) && (linkIndex = this.linkService.getLinkIndexByName(Long.valueOf(searchObject), searchObjectName)).isPresent()) {
                searchIndexId = ((LinkIndex)linkIndex.get()).getId().toString();
            }
            if ("docclass".equalsIgnoreCase(searchType)) {
                IndexTable index = dbm.getIndexByNameInDocClass(searchObject, searchObjectName);
                searchIndexId = index.getId().toString();
            }
        }
        try {
            String fileId = "";
            if ("link".equalsIgnoreCase(searchType) && (linkIndex = this.linkService.getLinkIndex(Long.valueOf(searchIndexId), new String[0])) != null) {
                List linkConnections = this.linkService.getLinkConnectionsForLinkIndex(Long.valueOf(searchIndexId), new String[]{"documentClass", "documentClassIndex"});
                for (LinkConnection linkConnection : linkConnections) {
                    Long docClassId = linkConnection.getDocumentClass().getId();
                    Long indexId = linkConnection.getDocumentClassIndex().getId();
                    HashMap<IndexTable, String> indecies = new HashMap<IndexTable, String>();
                    IndexTable index = DBManagement.getIndex((String)indexId.toString());
                    log.info("sSearchObjectValue :" + searchObjectValue);
                    indecies.put(index, searchObjectValue);
                    fileId = this.getFirstDocumentByDocClassAndIndecies(dbm, docClassId.toString(), indecies);
                    if (StringUtils.isBlank((String)fileId)) continue;
                    break;
                }
            }
            if ("docclass".equalsIgnoreCase(searchType)) {
                String documentClassId = searchObject;
                log.info("sSearchObjectValue :" + searchObjectValue);
                HashMap<IndexTable, String> indecies = new HashMap<IndexTable, String>();
                IndexTable index = DBManagement.getIndex((String)searchIndexId);
                log.info("sSearchObjectValue :" + searchObjectValue);
                indecies.put(index, searchObjectValue);
                indecies.put(index, searchObjectValue);
                fileId = this.getFirstDocumentByDocClassAndIndecies(dbm, documentClassId, indecies);
            }
            return String.format("redirect:/documents/%s/show.do", fileId);
        }
        catch (NullPointerException e) {
            String message = this.messageHelper.getMessage("Dokument_o_indeksach_nie_istnieje") + ", '" + searchIndexId + "=" + searchObjectValue + "'!";
            log.warn(message);
            request.setAttribute("message", (Object)message);
            request.setAttribute("messageType", (Object)"error");
            return "/archive/showFileMessage.jsp";
        }
        catch (Exception e) {
            log.error("Blad podczas wyszukiwania {}" + e.getMessage());
            request.setAttribute("message", (Object)(this.messageHelper.getMessage("Blad_podczas_wyszukiwania") + "!"));
            request.setAttribute("messageType", (Object)"error");
            return "/archive/showFileMessage.jsp";
        }
    }

    private String getFirstDocumentByDocClassAndIndecies(DBManagement dbm, String documentClassId, HashMap<IndexTable, String> indecies) {
        ArrayList documents = DBManagement.SearchDocClass(indecies, (String)documentClassId, (String)"", (String)"", (String)"", (int)1, (int)0, (int)0, (int)0, (long)0L);
        if (CollectionUtils.isEmpty((Collection)documents)) {
            log.info("Brak dokument\u00f3w dla klasy dokument\u00f3w :" + documentClassId);
            return "";
        }
        DocumentData documentData = (DocumentData)documents.get(0);
        return Objects.toString(documentData.getLFileId(), "");
    }

    private void setupResponseHeader(HttpServletResponse response, String extension, String fileName, int fileSize) {
        if (extension.compareToIgnoreCase("pdf") == 0) {
            response.setContentLength(fileSize);
            response.setContentType("application/pdf");
            response.addHeader("Accept-Header", String.valueOf(fileSize));
        } else if (extension.compareToIgnoreCase("xml") == 0) {
            response.setContentType("application/xhtml+xml");
        } else if (extension.compareToIgnoreCase("doc") == 0) {
            response.setContentType("application/msword");
        } else if (extension.compareToIgnoreCase("txt") == 0) {
            response.setContentType("text/plain");
        } else if (extension.compareToIgnoreCase("html") == 0) {
            response.setContentType("text/html");
        } else if (extension.compareToIgnoreCase("jpeg") == 0) {
            response.setContentType("image/jpeg");
        } else if (extension.compareToIgnoreCase("jpg") == 0) {
            response.setContentType("image/jpeg");
        } else if (extension.compareToIgnoreCase("xls") == 0) {
            response.setContentType("application/vnd.ms-excel");
        } else if (extension.compareToIgnoreCase("rtf") == 0) {
            response.setContentType("application/rtf");
        } else {
            response.setContentType("APPLICATION/OCTET-STREAM");
            response.setCharacterEncoding("ASCII");
        }
        response.setHeader("Content-Disposition", HttpHeaders.getContentDisposition((String)(fileName + "." + extension), (boolean)false));
    }

    @ConstructorProperties(value={"linkService", "fileService", "messageHelper", "documentClassService"})
    @Autowired
    public ShowFileController(LinkService linkService, FileService fileService, MessageHelperBean messageHelper, DocumentClassService documentClassService) {
        this.linkService = linkService;
        this.fileService = fileService;
        this.messageHelper = messageHelper;
        this.documentClassService = documentClassService;
    }
}

