/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.support.plugin;

import com.suncode.plugin.framework.Plugin;
import com.suncode.plugin.framework.config.PluginDetails;
import com.suncode.plugin.framework.core.PluginSpec;
import com.suncode.plugin.framework.core.PluginSpecWithClusterStatus;
import com.suncode.plugin.framework.license.LicenseService;
import com.suncode.plugin.framework.license.trial.TrialLicenseService;
import com.suncode.pwfl.i18n.MessageHelper;
import com.suncode.pwfl.web.support.plugin.NodesReconciliationStatus;
import java.util.Date;
import javax.annotation.Nullable;
import lombok.NonNull;

public class PluginInformation {
    private String key;
    private boolean enabled;
    private String name;
    private String version;
    private String description;
    private String author;
    private String license;
    private Date updated;
    private String systemStartupError;
    private NodesReconciliationStatus status;

    public static PluginInformation convertFrom(@NonNull PluginSpecWithClusterStatus pluginSpecWithClusterStatus, @Nullable Plugin plugin, @NonNull LicenseService licenseService, @NonNull TrialLicenseService trialLicenseService) {
        if (pluginSpecWithClusterStatus == null) {
            throw new NullPointerException("pluginSpecWithClusterStatus is marked non-null but is null");
        }
        if (licenseService == null) {
            throw new NullPointerException("licenseService is marked non-null but is null");
        }
        if (trialLicenseService == null) {
            throw new NullPointerException("trialLicenseService is marked non-null but is null");
        }
        PluginSpec pluginSpec = pluginSpecWithClusterStatus.pluginSpec();
        PluginInformation information = new PluginInformation();
        information.setStatus(NodesReconciliationStatus.from(pluginSpecWithClusterStatus.clusterStatus()));
        information.setKey(pluginSpec.key());
        information.setEnabled(pluginSpec.enabled());
        information.setName(pluginSpec.name());
        information.setVersion(pluginSpec.version().toString());
        information.setUpdated(Date.from(pluginSpec.updated()));
        if (plugin != null) {
            information.setLicense(PluginInformation.resolveLicenseInfo(plugin, licenseService, trialLicenseService));
            information.setSystemStartupError(plugin.getSystemStartupErrorMessage());
            PluginDetails details = plugin.getPluginDescriptor().getDetails();
            information.setDescription(details.getDescription());
            information.setAuthor(details.getAuthor());
        }
        return information;
    }

    private static String resolveLicenseInfo(Plugin plugin, LicenseService licenseService, TrialLicenseService trialLicenseService) {
        String licenseState = plugin.getRequirements().licenseState().name().toLowerCase();
        return MessageHelper.getMessage((String)("plugins.view.information.licenseState." + licenseState), (Object[])new Object[]{PluginInformation.getTrialDaysLeft(plugin.getKey(), licenseService, trialLicenseService)});
    }

    private static long getTrialDaysLeft(String pluginId, LicenseService licenseService, TrialLicenseService trialLicenseService) {
        if (licenseService.getLicenseState(pluginId) != null) {
            return licenseService.getTrialDaysLeft(pluginId);
        }
        return trialLicenseService.getTrialDaysLeft(pluginId);
    }

    public String getKey() {
        return this.key;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getDescription() {
        return this.description;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getLicense() {
        return this.license;
    }

    public Date getUpdated() {
        return this.updated;
    }

    public String getSystemStartupError() {
        return this.systemStartupError;
    }

    public NodesReconciliationStatus getStatus() {
        return this.status;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public void setUpdated(Date updated) {
        this.updated = updated;
    }

    public void setSystemStartupError(String systemStartupError) {
        this.systemStartupError = systemStartupError;
    }

    public void setStatus(NodesReconciliationStatus status) {
        this.status = status;
    }
}

