/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.support;

import com.suncode.pwfl.administration.structure.Position;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.util.CollatorInstance;
import com.suncode.pwfl.web.dto.administration.GroupDto;
import com.suncode.pwfl.web.dto.administration.MappingRoleDto;
import com.suncode.pwfl.web.dto.administration.structure.organizationalUnit.OrganizationalUnitDto;
import com.suncode.pwfl.web.dto.administration.structure.position.PositionDto;
import com.suncode.pwfl.web.dto.administration.user.UserMappingDto;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class UserMapper {
    public UserMappingDto fromEntity(User user) {
        return UserMappingDto.builder().objectId(user.getObjectId()).userName(user.getUserName()).firstName(user.getFirstName()).lastName(user.getLastName()).groups(user.getGroups().stream().map(GroupDto::fromDomain).sorted(Comparator.comparing(GroupDto::getName, CollatorInstance.get())).collect(Collectors.toList())).organizationalUnits(user.getPositions().stream().map(Position::getOrganizationalUnit).filter(Objects::nonNull).map(OrganizationalUnitDto::from).sorted(Comparator.comparing(OrganizationalUnitDto::getName, CollatorInstance.get())).collect(Collectors.toList())).roles(user.getPositions().stream().map(Position::getRoles).flatMap(Collection::stream).map(MappingRoleDto::fromEntity).sorted(Comparator.comparing(MappingRoleDto::getRoleId, CollatorInstance.get())).collect(Collectors.toCollection(LinkedHashSet::new))).positions(user.getPositions().stream().map(PositionDto::fromDomain).sorted(Comparator.comparing(PositionDto::getName, CollatorInstance.get())).collect(Collectors.toList())).build();
    }
}

