/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.filter;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiErrorHandlingFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(ApiErrorHandlingFilter.class);
    private ObjectMapper objectMapper;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.objectMapper = new ObjectMapper();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        try {
            chain.doFilter(request, response);
        }
        catch (Exception e) {
            this.handleException(httpRequest, httpResponse, e);
        }
    }

    private void handleException(HttpServletRequest request, HttpServletResponse response, Exception e) throws IOException {
        String requestUri = request.getRequestURI();
        String method = request.getMethod();
        log.error("Unhandled exception for {} {}", new Object[]{method, requestUri, e});
        if (!response.isCommitted()) {
            response.reset();
            response.setStatus(500);
            response.setContentType("application/json;charset=UTF-8");
            Map<String, Object> errorResponse = this.buildErrorResponse();
            this.objectMapper.writeValue((OutputStream)response.getOutputStream(), errorResponse);
        } else {
            log.warn("Reply already sent, cannot return a safe error response for {} {}", (Object)method, (Object)requestUri);
        }
    }

    private Map<String, Object> buildErrorResponse() {
        LinkedHashMap<String, Object> response = new LinkedHashMap<String, Object>();
        response.put("success", false);
        response.put("status", 500);
        response.put("message", "Unknown error");
        return response;
    }

    public void destroy() {
    }
}

