/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.dto.administration.user;

import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.cache.CacheFactory;
import com.suncode.pwfl.cache.PlusWorkflowCache;
import com.suncode.pwfl.cache.SystemCacheId;
import com.suncode.pwfl.cache.config.InMemoryCacheConfig;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.util.SpringContext;
import com.suncode.pwfl.web.dto.administration.GroupDto;
import com.suncode.pwfl.web.dto.administration.structure.position.PositionDto;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.ExecutionException;

public class UserDto {
    private Long objectId;
    private String userName;
    private String firstName;
    private String lastName;
    private String email;
    private String number;
    private Boolean active;
    private Boolean onlySsoLogin;
    private List<PositionDto> positions;
    private List<GroupDto> groups;
    private boolean anonymous;
    private boolean waitingForPasswordAssign;
    private static PlusWorkflowCache<String, UserDto> loadingCache = ((CacheFactory)SpringContext.getBean(CacheFactory.class)).createInMemoryCache(SystemCacheId.USER_DTO_CACHE, InMemoryCacheConfig.builder().expireAfterWrite(Duration.ofSeconds(10L)).loadFunction(userName -> {
        UserService userService = ServiceFactory.getUserService();
        User user = userService.getUser(userName, new String[0]);
        if (user != null) {
            return new UserDto(user);
        }
        return null;
    }).build());

    public static UserDto get(String userId) {
        try {
            return (UserDto)loadingCache.get((Object)userId);
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    private UserDto(User user) {
        this.setObjectId(user.getObjectId());
        this.setUserName(user.getUserName());
        this.setFirstName(user.getFirstName());
        this.setLastName(user.getLastName());
        this.setEmail(user.getEmail());
        this.setNumber(user.getNumber());
        this.setActive(user.isActive());
        this.setOnlySsoLogin(user.isOnlySsoLogin());
        this.setAnonymous(user.isAnonymous());
        this.setWaitingForPasswordAssign(user.isWaitingForPasswordAssign());
    }

    public static UserDto from(User user) {
        return UserDto.builder().objectId(user.getObjectId()).userName(user.getUserName()).firstName(user.getFirstName()).lastName(user.getLastName()).email(user.getEmail()).number(user.getNumber()).active(user.isActive()).onlySsoLogin(user.isOnlySsoLogin()).anonymous(user.isAnonymous()).waitingForPasswordAssign(user.isWaitingForPasswordAssign()).build();
    }

    public static UserDtoBuilder builder() {
        return new UserDtoBuilder();
    }

    public Long getObjectId() {
        return this.objectId;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getEmail() {
        return this.email;
    }

    public String getNumber() {
        return this.number;
    }

    public Boolean getActive() {
        return this.active;
    }

    public Boolean getOnlySsoLogin() {
        return this.onlySsoLogin;
    }

    public List<PositionDto> getPositions() {
        return this.positions;
    }

    public List<GroupDto> getGroups() {
        return this.groups;
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    public boolean isWaitingForPasswordAssign() {
        return this.waitingForPasswordAssign;
    }

    public void setObjectId(Long objectId) {
        this.objectId = objectId;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public void setOnlySsoLogin(Boolean onlySsoLogin) {
        this.onlySsoLogin = onlySsoLogin;
    }

    public void setPositions(List<PositionDto> positions) {
        this.positions = positions;
    }

    public void setGroups(List<GroupDto> groups) {
        this.groups = groups;
    }

    public void setAnonymous(boolean anonymous) {
        this.anonymous = anonymous;
    }

    public void setWaitingForPasswordAssign(boolean waitingForPasswordAssign) {
        this.waitingForPasswordAssign = waitingForPasswordAssign;
    }

    @ConstructorProperties(value={"objectId", "userName", "firstName", "lastName", "email", "number", "active", "onlySsoLogin", "positions", "groups", "anonymous", "waitingForPasswordAssign"})
    public UserDto(Long objectId, String userName, String firstName, String lastName, String email, String number, Boolean active, Boolean onlySsoLogin, List<PositionDto> positions, List<GroupDto> groups, boolean anonymous, boolean waitingForPasswordAssign) {
        this.objectId = objectId;
        this.userName = userName;
        this.firstName = firstName;
        this.lastName = lastName;
        this.email = email;
        this.number = number;
        this.active = active;
        this.onlySsoLogin = onlySsoLogin;
        this.positions = positions;
        this.groups = groups;
        this.anonymous = anonymous;
        this.waitingForPasswordAssign = waitingForPasswordAssign;
    }

    public UserDto() {
    }

    public static class UserDtoBuilder {
        private Long objectId;
        private String userName;
        private String firstName;
        private String lastName;
        private String email;
        private String number;
        private Boolean active;
        private Boolean onlySsoLogin;
        private List<PositionDto> positions;
        private List<GroupDto> groups;
        private boolean anonymous;
        private boolean waitingForPasswordAssign;

        UserDtoBuilder() {
        }

        public UserDtoBuilder objectId(Long objectId) {
            this.objectId = objectId;
            return this;
        }

        public UserDtoBuilder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public UserDtoBuilder firstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        public UserDtoBuilder lastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        public UserDtoBuilder email(String email) {
            this.email = email;
            return this;
        }

        public UserDtoBuilder number(String number) {
            this.number = number;
            return this;
        }

        public UserDtoBuilder active(Boolean active) {
            this.active = active;
            return this;
        }

        public UserDtoBuilder onlySsoLogin(Boolean onlySsoLogin) {
            this.onlySsoLogin = onlySsoLogin;
            return this;
        }

        public UserDtoBuilder positions(List<PositionDto> positions) {
            this.positions = positions;
            return this;
        }

        public UserDtoBuilder groups(List<GroupDto> groups) {
            this.groups = groups;
            return this;
        }

        public UserDtoBuilder anonymous(boolean anonymous) {
            this.anonymous = anonymous;
            return this;
        }

        public UserDtoBuilder waitingForPasswordAssign(boolean waitingForPasswordAssign) {
            this.waitingForPasswordAssign = waitingForPasswordAssign;
            return this;
        }

        public UserDto build() {
            return new UserDto(this.objectId, this.userName, this.firstName, this.lastName, this.email, this.number, this.active, this.onlySsoLogin, this.positions, this.groups, this.anonymous, this.waitingForPasswordAssign);
        }

        public String toString() {
            return "UserDto.UserDtoBuilder(objectId=" + this.objectId + ", userName=" + this.userName + ", firstName=" + this.firstName + ", lastName=" + this.lastName + ", email=" + this.email + ", number=" + this.number + ", active=" + this.active + ", onlySsoLogin=" + this.onlySsoLogin + ", positions=" + String.valueOf(this.positions) + ", groups=" + String.valueOf(this.groups) + ", anonymous=" + this.anonymous + ", waitingForPasswordAssign=" + this.waitingForPasswordAssign + ")";
        }
    }
}

