/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.workflow.archive;

import com.google.common.collect.ImmutableMap;
import com.plusmpm.database.DocumentTemplateTable;
import com.suncode.pwfl.archive.DocumentTemplateService;
import com.suncode.pwfl.archive.FileService;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.export.extension.ExportExtension;
import com.suncode.pwfl.export.model.ExportColumn;
import com.suncode.pwfl.export.model.ExportColumnBuilder;
import com.suncode.pwfl.export.model.ExportModel;
import com.suncode.pwfl.export.service.ExportService;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.util.exception.ServiceException;
import com.suncode.pwfl.web.dto.archive.NewDocumentTemplateDto;
import com.suncode.pwfl.web.dto.archive.ReadDocumentTemplateDto;
import com.suncode.pwfl.web.dto.archive.UpdateDocumentTemplateDto;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import com.suncode.pwfl.web.security.exception.NotFullRightsException;
import com.suncode.pwfl.web.support.DocumentTemplateMapper;
import com.suncode.pwfl.web.support.ajax.RestResult;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"/templates"})
public class DocumentTemplateController {
    private static final Logger log = LoggerFactory.getLogger(DocumentTemplateController.class);
    private final DocumentTemplateService documentTemplateService;
    private final DocumentTemplateMapper documentTemplateMapper;
    private final ExportService exportService;
    private final MessageHelperBean messageHelper;
    private final FileService fileService;
    private final AuthorizationHelper authorizationHelper;

    @RequestMapping(value={"{processDefId}/{id}/validate"}, method={RequestMethod.GET})
    @ResponseBody
    public boolean validateDocumentTemplate(@PathVariable String processDefId, @PathVariable Long id) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        DocumentTemplateTable documentTemplateTable = (DocumentTemplateTable)this.documentTemplateService.get((Serializable)id);
        if (documentTemplateTable == null || !documentTemplateTable.getProcessId().equals(processDefId)) {
            throw new ServiceException(this.messageHelper.getMessage("Szablon_nie_istnieje"));
        }
        return this.fileService.validateFileExistsAndHasRightsToIt(documentTemplateTable.getTemplatePath());
    }

    @RequestMapping(method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<ReadDocumentTemplateDto> getDocumentTemplates(@RequestParam String processId, @RequestParam Integer start, @RequestParam Integer limit, @RequestParam(required=false, defaultValue="templateName") String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        List documentTemplates = this.documentTemplateService.getDocumentTemplatesForProcess(processId, start.intValue(), limit.intValue(), sortBy, sortDirection).stream().map(this.documentTemplateMapper::toReadDocumentTemplateDto).collect(Collectors.toList());
        long count = this.documentTemplateService.getDocumentTemplatesCountForProcess(processId);
        return new CountedResult(count, documentTemplates);
    }

    @RequestMapping(method={RequestMethod.POST})
    public ResponseEntity<RestResult> create(HttpServletRequest request, @RequestBody NewDocumentTemplateDto documentTemplateDto) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_ADD_DOCUMENT_TEMPLATE).params(this.createAddTemplateAuditParams(documentTemplateDto));
        this.authorizationHelper.assertFullAdministrationRights(() -> auditBuilder.buildFailure(request));
        try {
            this.documentTemplateService.addDocumentTemplate(this.documentTemplateMapper.toEntity(documentTemplateDto));
            request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
            return new ResponseEntity((Object)new RestResult(true), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (IllegalArgumentException e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            return new ResponseEntity((Object)new RestResult(false, e.getMessage()), (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(method={RequestMethod.PATCH})
    public ResponseEntity<RestResult> update(HttpServletRequest request, @RequestBody UpdateDocumentTemplateDto documentTemplateDto) {
        Map<String, Object> params = this.createInitialUpdateTemplateAuditParams(documentTemplateDto);
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_EDIT_DOCUMENT_TEMPLATE).params(params);
        this.authorizationHelper.assertFullAdministrationRights(() -> auditBuilder.buildFailure(request));
        try {
            DocumentTemplateTable oldDocumentTemplate = (DocumentTemplateTable)this.documentTemplateService.get((Serializable)documentTemplateDto.getId());
            params = this.createFullUpdateTemplateAuditParams(Optional.ofNullable(oldDocumentTemplate), documentTemplateDto);
            this.documentTemplateService.updateDocumentTemplate(this.documentTemplateMapper.toEntity(documentTemplateDto));
            auditBuilder.params(params);
            request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
            return new ResponseEntity((Object)new RestResult(true), (HttpStatusCode)HttpStatus.OK);
        }
        catch (IllegalArgumentException e) {
            auditBuilder.params(params);
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            return new ResponseEntity((Object)new RestResult(false, e.getMessage()), (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(method={RequestMethod.DELETE})
    public ResponseEntity<RestResult> delete(HttpServletRequest request, @RequestParam long docTemplateId) {
        Map<String, Object> params = this.initDeleteTemplateAuditParams(docTemplateId);
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_DOCUMENT_TEMPLATE).params(params);
        this.authorizationHelper.assertFullAdministrationRights(() -> auditBuilder.buildFailure(request));
        DocumentTemplateTable documentTemplate = (DocumentTemplateTable)this.documentTemplateService.get((Serializable)Long.valueOf(docTemplateId));
        if (documentTemplate != null) {
            this.documentTemplateService.delete((Object)documentTemplate);
            auditBuilder.params(this.createDeleteTemplateAuditParams(documentTemplate));
            request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
            return new ResponseEntity((Object)new RestResult(true), (HttpStatusCode)HttpStatus.OK);
        }
        auditBuilder.params(params);
        request.setAttribute("audit", (Object)auditBuilder.buildFailure());
        return new ResponseEntity((Object)new RestResult(false, this.messageHelper.getMessage("Szablon_nie_istnieje")), (HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"export/{extension}"})
    public void export(HttpServletResponse response, @PathVariable String extension, @RequestParam String processId, @RequestParam(required=false, defaultValue="templateName") String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection) throws IOException {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        List documentTemplates = this.documentTemplateService.getDocumentTemplatesForProcess(processId, 0, Integer.MAX_VALUE, sortBy, sortDirection).stream().map(this.documentTemplateMapper::toReadDocumentTemplateDto).collect(Collectors.toList());
        List<ExportColumn> columns = Arrays.asList(ExportColumnBuilder.create().name(this.messageHelper.getMessage("Nazwa_szablonu")).data(documentTemplates).by(ReadDocumentTemplateDto::getTemplateName).build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Sciezka_szablonu")).data(documentTemplates).by(ReadDocumentTemplateDto::getTemplatePath).build());
        ExportModel model = ExportModel.builder().title(this.messageHelper.getMessage("Szablony_dokumentow")).columns(columns).build();
        ExportExtension extensionEnum = ExportExtension.valueOf((String)extension.toUpperCase());
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", String.format("attachment; filename=\"export.%s\"", extensionEnum.getExtension()));
        this.exportService.export(model, extensionEnum, (OutputStream)response.getOutputStream());
    }

    private Map<String, Object> createAddTemplateAuditParams(NewDocumentTemplateDto documentTemplate) {
        return ImmutableMap.builder().put((Object)"processId", (Object)StringUtils.defaultIfEmpty((CharSequence)documentTemplate.getProcessId(), (CharSequence)"")).put((Object)"templateName", (Object)StringUtils.defaultIfEmpty((CharSequence)documentTemplate.getTemplateName(), (CharSequence)"")).put((Object)"templatePath", (Object)StringUtils.defaultIfEmpty((CharSequence)documentTemplate.getTemplatePath(), (CharSequence)"")).build();
    }

    private Map<String, Object> createInitialUpdateTemplateAuditParams(UpdateDocumentTemplateDto updateDocumentTemplateDto) {
        return ImmutableMap.builder().put((Object)"templateName", (Object)StringUtils.defaultIfEmpty((CharSequence)updateDocumentTemplateDto.getTemplateName(), (CharSequence)"")).put((Object)"templatePath", (Object)StringUtils.defaultIfEmpty((CharSequence)updateDocumentTemplateDto.getTemplatePath(), (CharSequence)"")).build();
    }

    private Map<String, Object> createFullUpdateTemplateAuditParams(Optional<DocumentTemplateTable> oldDocumentTemplate, UpdateDocumentTemplateDto updateDocumentTemplateDto) {
        return ImmutableMap.builder().put((Object)"processId", (Object)oldDocumentTemplate.map(DocumentTemplateTable::getProcessId).orElse("")).put((Object)"templateName", (Object)StringUtils.defaultIfEmpty((CharSequence)String.format("%s; %s", oldDocumentTemplate.map(DocumentTemplateTable::getTemplateName).orElse(""), updateDocumentTemplateDto.getTemplateName()), (CharSequence)"")).put((Object)"templatePath", (Object)StringUtils.defaultIfEmpty((CharSequence)String.format("%s; %s", oldDocumentTemplate.map(DocumentTemplateTable::getTemplatePath).orElse(""), updateDocumentTemplateDto.getTemplatePath()), (CharSequence)"")).build();
    }

    private Map<String, Object> initDeleteTemplateAuditParams(long docTemplateId) {
        return ImmutableMap.builder().put((Object)"docTemplateId", (Object)docTemplateId).build();
    }

    private Map<String, Object> createDeleteTemplateAuditParams(DocumentTemplateTable documentTemplate) {
        return ImmutableMap.builder().put((Object)"processId", (Object)documentTemplate.getProcessId()).put((Object)"docTemplateId", (Object)documentTemplate.getId()).build();
    }

    @ExceptionHandler(value={NotFullRightsException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ResponseBody
    public RestResult handleNotFullRightsException(NotFullRightsException e) {
        log.info(this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
        return new RestResult(false, this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
    }

    @ExceptionHandler(value={ServiceException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public RestResult handleBadRequest(Exception e) {
        log.info(e.getMessage());
        return new RestResult(false, e.getMessage());
    }

    @ConstructorProperties(value={"documentTemplateService", "documentTemplateMapper", "exportService", "messageHelper", "fileService", "authorizationHelper"})
    @Autowired
    public DocumentTemplateController(DocumentTemplateService documentTemplateService, DocumentTemplateMapper documentTemplateMapper, ExportService exportService, MessageHelperBean messageHelper, FileService fileService, AuthorizationHelper authorizationHelper) {
        this.documentTemplateService = documentTemplateService;
        this.documentTemplateMapper = documentTemplateMapper;
        this.exportService = exportService;
        this.messageHelper = messageHelper;
        this.fileService = fileService;
        this.authorizationHelper = authorizationHelper;
    }
}

