/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.system;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import com.plusmpm.database.authorization.RightTreeBuilder;
import com.plusmpm.util.Authorization;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.configuration.ConfigurationExportService;
import com.suncode.pwfl.configuration.ConfigurationImportService;
import com.suncode.pwfl.configuration.ConfigurationTransferResult;
import com.suncode.pwfl.configuration.ConfigurationTypes;
import com.suncode.pwfl.configuration.dto.ConfigurationDtoRoot;
import com.suncode.pwfl.configuration.dto.plugins.PluginConfigurationDtoRoot;
import com.suncode.pwfl.configuration.plugins.PluginConfigurationService;
import com.suncode.pwfl.configuration.plugins.PluginConfigurationTransferSupportService;
import com.suncode.pwfl.core.type.support.RuntimeTypeAdapterFactory;
import com.suncode.pwfl.plugin.modules.configurationTransfer.PluginConfigurationTransferDefinition;
import com.suncode.pwfl.util.exception.ServiceException;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import com.suncode.pwfl.web.util.JsonMessage;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/system/configuration/transfer"})
@Api(tags={"system configuration"})
public class ConfigurationTransferController {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationTransferController.class);
    @Autowired
    private ConfigurationImportService configurationImportService;
    @Autowired
    private ConfigurationExportService configurationExportService;
    @Autowired
    private PluginConfigurationService pluginConfigurationService;
    @Autowired
    private PluginConfigurationTransferSupportService pluginConfigurationTransferSupportService;
    @Autowired
    private AuthorizationHelper authorizationHelper;

    @ApiOperation(value="", hidden=true)
    @GetMapping(value={"export/configuration"})
    @ResponseBody
    public ResponseEntity<String> exportConfigurationForType(@RequestParam ConfigurationTypes type) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        try {
            List config = this.configurationExportService.exportConfiguration(type);
            Gson gson = this.prepareGsonForPlugins();
            String json = gson.toJson((Object)config);
            return new ResponseEntity((Object)json, (HttpStatusCode)HttpStatus.OK);
        }
        catch (ServiceException e) {
            log.error("Service error during configuration export", (Throwable)e);
            return new ResponseEntity((Object)e.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @ApiOperation(value="", hidden=true)
    @GetMapping(value={"root"})
    @ResponseBody
    public ResponseEntity<String> getRootConfig() {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        Gson gson = this.prepareGsonForPlugins();
        String json = gson.toJson((Object)new ConfigurationDtoRoot());
        return new ResponseEntity((Object)json, (HttpStatusCode)HttpStatus.OK);
    }

    @ApiOperation(value="(Admin) Downloading system configuration", notes="Returns a string with the whole system configuration.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=403, message="Forbidden")})
    @ResponseBody
    @GetMapping
    public ResponseEntity<String> getBase(HttpSession session, HttpServletRequest request) throws SQLException {
        if (this.loggedUserHasAdminRights(session)) {
            AuditBuilder configTransferAudit = AuditBuilder.getInstance().type(AuditTypes.AUDIT_CONFIG_TRANSFER_GET_FROM_BASE);
            ConfigurationDtoRoot config = this.configurationExportService.getBaseConfiguration();
            Gson gson = this.prepareGsonForPlugins();
            String json = gson.toJson((Object)config);
            request.setAttribute("audit", (Object)configTransferAudit.success(true).build());
            return new ResponseEntity((Object)json, (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.FORBIDDEN);
    }

    @ApiOperation(value="(Admin) Downloading system configuration as json", notes="Returns a json with the whole system configuration.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=403, message="Forbidden")})
    @PostMapping(value={"export"})
    public ResponseEntity<JsonMessage> exportConf(HttpSession session, HttpServletRequest request, @ApiParam(value="The executed query exports system configuration as json. The query is a String with system configuration", required=true) @RequestBody String config) throws SQLException {
        if (this.loggedUserHasAdminRights(session)) {
            AuditBuilder configTransferAudit = AuditBuilder.getInstance().type(AuditTypes.AUDIT_CONFIG_TRANSFER_EXPORT);
            try {
                Gson gson = this.prepareGsonForPlugins();
                ConfigurationDtoRoot root = (ConfigurationDtoRoot)gson.fromJson(config, ConfigurationDtoRoot.class);
                ConfigurationTransferResult configurationTransferResult = new ConfigurationTransferResult();
                configurationTransferResult.setWarnings(this.configurationExportService.removeUnnecessaryElements(root));
                this.configurationExportService.validConfig(root);
                String jsonConfig = gson.toJson((Object)root);
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("config", jsonConfig);
                data.put("warnings", configurationTransferResult.getWarnings());
                JsonMessage response = new JsonMessage();
                response.setData(data);
                response.setSuccess(true);
                request.setAttribute("audit", (Object)configTransferAudit.success(true).build());
                return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.OK);
            }
            catch (Exception e) {
                return this.configTransferError(request, configTransferAudit, e);
            }
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.FORBIDDEN);
    }

    @ApiOperation(value="(Admin) Importing json system configuration")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=403, message="Forbidden")})
    @PostMapping(value={"import"})
    public ResponseEntity<JsonMessage> importConf(HttpSession session, @ApiParam(value="System configuration as JSON", required=true) @RequestBody String config, @ApiParam(value="Default password for imported users", required=true) @RequestParam(value="defaultPassword", required=false) String defaultPassword, @ApiParam(value="Default group for imported users", required=true) @RequestParam(value="defaultGroup", required=false) String defaultGroup, @ApiParam(value="Deactivate imported scheduled tasks", defaultValue="true") @RequestParam(value="deactivateScheduledTasks", required=false, defaultValue="true") Boolean deactivateScheduledTasks, @ApiParam(value="Use override mode (experimental)", defaultValue="false") @RequestParam(value="overrideMode", required=false, defaultValue="false") boolean overrideMode) throws SQLException {
        if (this.loggedUserHasAdminRights(session)) {
            try {
                Gson gson = this.prepareGsonForPlugins();
                ConfigurationDtoRoot root = (ConfigurationDtoRoot)gson.fromJson(config, ConfigurationDtoRoot.class);
                ConfigurationTransferResult transferResult = this.configurationImportService.importConfigurationWithResults(root, defaultPassword, defaultGroup, deactivateScheduledTasks.booleanValue(), overrideMode);
                JsonMessage response = new JsonMessage();
                response.setSuccess(true);
                response.setData((Object)transferResult);
                return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.OK);
            }
            catch (Exception e) {
                JsonMessage response = new JsonMessage();
                response.setErrorMsg((String)(e.getMessage() != null ? e.getMessage() : "Error:" + String.valueOf(e)));
                response.setSuccess(false);
                log.error(e.getMessage(), (Throwable)e);
                return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.OK);
            }
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.FORBIDDEN);
    }

    @ApiOperation(value="", hidden=true)
    @PostMapping(value={"clean"})
    public ResponseEntity<JsonMessage> cleanConf(HttpServletRequest request, @RequestBody String config) {
        AuditBuilder configTransferAudit = AuditBuilder.getInstance().type(AuditTypes.AUDIT_CONFIG_TRANSFER_GET_FROM_FILE);
        try {
            Gson gson = this.prepareGsonForPlugins();
            ConfigurationDtoRoot root = (ConfigurationDtoRoot)gson.fromJson(config, ConfigurationDtoRoot.class);
            this.configurationImportService.removeUnnecessaryElements(root);
            JsonMessage response = new JsonMessage();
            response.setData((Object)gson.toJson((Object)root));
            response.setSuccess(true);
            request.setAttribute("audit", (Object)configTransferAudit.success(true).build());
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            return this.configTransferError(request, configTransferAudit, e);
        }
    }

    @ApiOperation(value="", hidden=true)
    @ResponseBody
    @GetMapping(value={"availablePlugins"})
    public List<String> availablePlugins() {
        return this.pluginConfigurationTransferSupportService.getAvailablePluginsToTransfer();
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ResponseBody
    public ResponseEntity<JsonMessage> handleHttpMessageNotReadableException(HttpServletRequest request, Exception e) {
        log.info(e.getMessage());
        AuditBuilder configTransferAudit = AuditBuilder.getInstance().type(AuditTypes.AUDIT_CONFIG_TRANSFER_GET_FROM_FILE);
        return this.configTransferError(request, configTransferAudit, e);
    }

    private ResponseEntity<JsonMessage> configTransferError(HttpServletRequest request, AuditBuilder configTransferAudit, Exception e) {
        JsonMessage response = new JsonMessage();
        response.setErrorMsg((String)(e.getMessage() != null ? e.getMessage() : "Error:" + String.valueOf(e)));
        response.setSuccess(false);
        log.error(e.getMessage(), (Throwable)e);
        request.setAttribute("audit", (Object)configTransferAudit.success(false).build());
        return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.OK);
    }

    private boolean loggedUserHasAdminRights(HttpSession session) throws SQLException {
        String username = (String)session.getAttribute("username");
        int rights = Authorization.checkRight((String)RightTreeBuilder.builder().system().admin().build(), (String)username, (boolean)false, (boolean)false);
        return rights == 0;
    }

    private Gson prepareGsonForPlugins() {
        RuntimeTypeAdapterFactory pluginDtoAdapterFactory = RuntimeTypeAdapterFactory.of(PluginConfigurationDtoRoot.class, (String)"pluginId");
        List pluginConfigDefinitions = this.pluginConfigurationService.getAllPluginTransferDefinitions();
        for (PluginConfigurationTransferDefinition pluginConfigDef : pluginConfigDefinitions) {
            if (pluginConfigDef.getConfigurationDtoRootClass() == null) continue;
            Class clazz = pluginConfigDef.getConfigurationDtoRootClass();
            pluginDtoAdapterFactory.registerSubtype(clazz, pluginConfigDef.getPluginId());
        }
        pluginDtoAdapterFactory.registerSubtype(PluginConfigurationDtoRoot.class, "com.suncode.noplugin-default");
        GsonBuilder gsonBuilder = new GsonBuilder().disableHtmlEscaping().registerTypeAdapterFactory((TypeAdapterFactory)pluginDtoAdapterFactory);
        return gsonBuilder.create();
    }
}

