/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.plannedtask.datafilesync;

import com.suncode.pwfl.plannedtask.datafilesync.DataFileSyncConfiguration;
import com.suncode.pwfl.plannedtask.datafilesync.DataFileSyncConfigurationService;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.util.Paginator;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import com.suncode.pwfl.web.support.ajax.RestResult;
import io.swagger.annotations.Api;
import java.beans.ConstructorProperties;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"dataFileSync"})
@Api(hidden=true)
public class DataFileSyncTaskController {
    private final DataFileSyncConfigurationService dataFileSyncConfigurationService;
    private final AuthorizationHelper authorizationHelper;

    @GetMapping(value={"/configuration"})
    public CountedResult<DataFileSyncConfiguration> getAllConfigurations(@RequestParam(required=false) Integer start, @RequestParam(required=false) Integer limit, @RequestParam(required=false) String query) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        List<DataFileSyncConfiguration> configurations = this.dataFileSyncConfigurationService.findAll();
        if (StringUtils.isNotBlank((CharSequence)query)) {
            configurations = configurations.stream().filter(configuration -> configuration.getName().toLowerCase().contains(query.toLowerCase())).toList();
        }
        return Paginator.forAll((List)configurations).viewPageByOffset(start, limit);
    }

    @PostMapping(value={"/configuration"})
    public DataFileSyncConfiguration addConfiguration(@RequestBody DataFileSyncConfiguration configuration) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        return this.dataFileSyncConfigurationService.addConfiguration(configuration);
    }

    @PostMapping(value={"/configuration/{id}"})
    public DataFileSyncConfiguration updateConfiguration(@PathVariable Long id, @RequestBody DataFileSyncConfiguration configuration) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        return this.dataFileSyncConfigurationService.updateConfiguration(id, configuration);
    }

    @DeleteMapping(value={"/configuration/{id}"})
    public RestResult deleteConfiguration(@PathVariable Long id) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        this.dataFileSyncConfigurationService.deleteConfiguration(id);
        return new RestResult(true, "");
    }

    @ConstructorProperties(value={"dataFileSyncConfigurationService", "authorizationHelper"})
    @Autowired
    public DataFileSyncTaskController(DataFileSyncConfigurationService dataFileSyncConfigurationService, AuthorizationHelper authorizationHelper) {
        this.dataFileSyncConfigurationService = dataFileSyncConfigurationService;
        this.authorizationHelper = authorizationHelper;
    }
}

