/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.calendar;

import com.suncode.pwfl.calendar.processReservation.ProcessReservationService;
import com.suncode.pwfl.calendar.support.CalendarDateConverter;
import com.suncode.pwfl.web.dto.calendar.processReservation.ProcessReservationDto;
import io.swagger.annotations.Api;
import java.beans.ConstructorProperties;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"calendar/processReservation"})
@Api(hidden=true)
public class ProcessReservationController {
    private final ProcessReservationService processReservationService;
    private final CalendarDateConverter calendarDateConverter;

    @PostMapping
    @ResponseStatus(value=HttpStatus.CREATED)
    public long createReservation(@RequestBody ProcessReservationDto processReservationDto) {
        LocalDateTime startDateTimeUtc = this.calendarDateConverter.toLocalDateTime(processReservationDto.startDateTimeUtc(), processReservationDto.allDay());
        LocalDateTime endDateTimeUtc = this.calendarDateConverter.toLocalDateTime(processReservationDto.endDateTimeUtc(), processReservationDto.allDay());
        return this.processReservationService.createReservation(processReservationDto.processId(), processReservationDto.calendarResourceId(), processReservationDto.allDay(), startDateTimeUtc, endDateTimeUtc, processReservationDto.nameTemplate());
    }

    @DeleteMapping(value={"{id}"})
    public void deleteReservation(@PathVariable long id) {
        this.processReservationService.deleteReservation(id);
    }

    @GetMapping(value={"count"})
    public long countByResourceIdAndPeriod(@RequestParam Long resourceId, @RequestParam(required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) OffsetDateTime fromDateTime, @RequestParam(required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) OffsetDateTime toDateTime) {
        LocalDateTime fromDateTimeUtc = fromDateTime != null ? fromDateTime.atZoneSameInstant(ZoneOffset.UTC).toLocalDateTime() : null;
        LocalDateTime toDateTimeUtc = toDateTime != null ? toDateTime.atZoneSameInstant(ZoneOffset.UTC).toLocalDateTime() : null;
        return this.processReservationService.countReservationsByResourceAndPeriod(resourceId.longValue(), fromDateTimeUtc, toDateTimeUtc);
    }

    @ConstructorProperties(value={"processReservationService", "calendarDateConverter"})
    @Autowired
    public ProcessReservationController(ProcessReservationService processReservationService, CalendarDateConverter calendarDateConverter) {
        this.processReservationService = processReservationService;
        this.calendarDateConverter = calendarDateConverter;
    }
}

