/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.administration.organizationalUnit;

import com.suncode.pwfl.administration.structure.OrganizationalUnit;
import com.suncode.pwfl.administration.structure.Position;
import com.suncode.pwfl.administration.structure.StructureService;
import com.suncode.pwfl.administration.structure.exception.OrganizationalUnitAlreadyExistException;
import com.suncode.pwfl.administration.structure.exception.OrganizationalUnitNotFoundException;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.builder.AuditParamsBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.export.extension.ExportExtension;
import com.suncode.pwfl.export.model.ExportColumn;
import com.suncode.pwfl.export.model.ExportColumnBuilder;
import com.suncode.pwfl.export.model.ExportModel;
import com.suncode.pwfl.export.service.ExportService;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.Pagination;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.search.Sorter;
import com.suncode.pwfl.translation.configElements.TranslatedFieldType;
import com.suncode.pwfl.util.exception.EmptyPropertyException;
import com.suncode.pwfl.util.exception.ServiceException;
import com.suncode.pwfl.web.controller.api.administration.organizationalUnit.OrganizationalUnitSearchFilters;
import com.suncode.pwfl.web.dto.administration.structure.organizationalUnit.AddOrganizationalUnitDto;
import com.suncode.pwfl.web.dto.administration.structure.organizationalUnit.StructureOrganizationalUnitDto;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import com.suncode.pwfl.web.security.exception.NotFullRightsException;
import com.suncode.pwfl.web.support.ajax.RestResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"organizationalUnits"})
@Api(tags={"organizational units"})
public class OrganizationalUnitController {
    private static final Logger log = LoggerFactory.getLogger(OrganizationalUnitController.class);
    private final StructureService structureService;
    private final ExportService exportService;
    private final AuthorizationHelper authorizationHelper;
    private final MessageHelperBean messageHelper;

    @ApiOperation(value="(Admin) Downloading a list of organizational units", notes="Retrieves a list of system ogranizational units")
    @GetMapping
    @ResponseBody
    public CountedResult<StructureOrganizationalUnitDto> getOrganizationalUnits(HttpServletRequest request, OrganizationalUnitSearchFilters filters, @ApiParam(value="Result number from which results are to be returned", defaultValue="0") @RequestParam(required=false) Integer start, @ApiParam(value="Number of returned results", defaultValue="20") @RequestParam(required=false) Integer limit, @ApiParam(value="Sort by", defaultValue="name") @RequestParam(required=false, defaultValue="name") String sortBy, @ApiParam(value="Sort direction", defaultValue="ASC", allowableValues="ASC,DESC") @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_SEARCH_ORG_UNIT).params(this.createSearchAudit(filters));
        this.authorizationHelper.assertFullAdministrationRights(() -> auditBuilder.buildFailure(request));
        CountedResult organizationalUnits = this.structureService.getOrganizationalUnits(filters.getName(), filters.getSymbol(), filters.getHighOuName(), filters.getHighOuSymbol(), filters.getDirectorName(), filters.getDirectorSymbol(), Pagination.create((Sorter)new Sorter(sortBy, sortDirection), (Integer)start, (Integer)limit));
        List organizationalUnitsDtos = organizationalUnits.getData().stream().map(StructureOrganizationalUnitDto::from).collect(Collectors.toList());
        auditBuilder.buildSuccess(request);
        return new CountedResult(organizationalUnits.getTotal(), organizationalUnitsDtos);
    }

    private Map<String, Object> createSearchAudit(OrganizationalUnitSearchFilters filters) {
        HashMap<String, Object> auditParams = new HashMap<String, Object>();
        Object orgUnitDirectorValue = StringUtils.defaultString((String)filters.getDirectorName());
        orgUnitDirectorValue = ((String)orgUnitDirectorValue).isEmpty() ? (String)orgUnitDirectorValue + StringUtils.defaultString((String)filters.getDirectorSymbol()) : (String)orgUnitDirectorValue + " - " + StringUtils.defaultString((String)filters.getDirectorSymbol());
        Object orgUnitHigherOrgUnitValue = StringUtils.defaultString((String)filters.getHighOuName());
        orgUnitHigherOrgUnitValue = ((String)orgUnitHigherOrgUnitValue).isEmpty() ? StringUtils.defaultString((String)filters.getHighOuSymbol()) : (String)orgUnitHigherOrgUnitValue + " - " + StringUtils.defaultString((String)filters.getHighOuSymbol());
        auditParams.put("orgUnitName", StringUtils.defaultString((String)filters.getName()));
        auditParams.put("orgUnitSymbol", StringUtils.defaultString((String)filters.getSymbol()));
        auditParams.put("orgUnitHigherOrgUnit", orgUnitHigherOrgUnitValue);
        auditParams.put("orgUnitDirector", orgUnitDirectorValue);
        return auditParams;
    }

    @ApiOperation(value="(Admin) Deleting organizational unit", notes="Deletes organizational unit with given id")
    @DeleteMapping(value={"/{id}"})
    @ResponseBody
    public RestResult deleteOrganizationalUnit(HttpServletRequest request, @ApiParam(value="Id of the organizational unit", required=true) @PathVariable Long id) throws OrganizationalUnitNotFoundException {
        AuditParamsBuilder auditParamsBuilder = new AuditParamsBuilder().param("orgUnitId", (Object)id);
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_ORG_UNIT).params(auditParamsBuilder.build());
        this.authorizationHelper.assertFullAdministrationRights(() -> auditBuilder.buildFailure(request));
        if (this.structureService.getOrganizationalUnit(id, new String[0]) == null) {
            auditBuilder.buildFailure(request);
            throw new OrganizationalUnitNotFoundException(this.messageHelper.getMessage("Jednostka_organizacyjna_o_podanym_id_nie_istnieje", new Object[]{id}));
        }
        auditParamsBuilder.params(this.createAddAndDeleteOrgUnitAuditParams(AddOrganizationalUnitDto.from(this.structureService.getOrganizationalUnit(id, new String[0]))));
        auditBuilder.params(auditParamsBuilder.build());
        try {
            this.structureService.deleteOrganizationalUnit(id);
            auditBuilder.buildSuccess(request);
            return new RestResult(true);
        }
        catch (Exception e) {
            auditBuilder.buildFailure(request);
            throw new ServiceException((Throwable)e);
        }
    }

    @ApiOperation(value="(Admin) Adding new organizational unit", notes="Adds new organizational unit to the system")
    @PostMapping
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public RestResult addOrganizationalUnit(HttpServletRequest request, @ApiParam(value="The executed query saves new organizational unit. The query is a JSON object with the following fields\n- **organizationalUnitName** - name of the organizational unit\n- **organizationalUnitSymbol** - symbol of the organizational unit\n- **directorPositionId** - id of the higher position\n- **higherOrganizationalUnitId** - id of the organizational unit", required=true) @RequestBody AddOrganizationalUnitDto unit) throws OrganizationalUnitAlreadyExistException, EmptyPropertyException {
        AuditParamsBuilder auditParamsBuilder = new AuditParamsBuilder().params(this.createAddAndDeleteOrgUnitAuditParams(unit));
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_ADD_ORG_UNIT).params(auditParamsBuilder.build());
        this.authorizationHelper.assertFullAdministrationRights(() -> auditBuilder.buildFailure(request));
        try {
            OrganizationalUnit organizationalUnit = new OrganizationalUnit(unit.getOrganizationalUnitName(), unit.getOrganizationalUnitSymbol());
            this.addHigherOrganizationalUnitAndDirector(unit, organizationalUnit);
            this.structureService.validateOrganizationalUnit(organizationalUnit);
            Long orgUnitId = this.structureService.createOrganizationalUnit(organizationalUnit);
            auditBuilder.params(auditParamsBuilder.param("orgUnitId", (Object)orgUnitId).build());
            auditBuilder.buildSuccess(request);
            return new RestResult(true);
        }
        catch (Exception e) {
            auditBuilder.buildFailure(request);
            throw e;
        }
    }

    @ApiOperation(value="(Admin) Editing organizational unit", notes="Edits organizational unit with given id")
    @PatchMapping(value={"/{id}"})
    @ResponseBody
    public RestResult changeOrganizationalUnit(HttpServletRequest request, @ApiParam(value="Id of the organizational unit", required=true) @PathVariable Long id, @ApiParam(value="The executed query edits organizational unit. The query is a JSON object with the following fields\n- **organizationalUnitName** - name of the organizational unit\n- **organizationalUnitSymbol** - symbol of the organizational unit\n- **directorPositionId** - id of the higher position\n- **higherOrganizationalUnitId** - id of the organizational unit", required=true) @RequestBody AddOrganizationalUnitDto unit) throws OrganizationalUnitAlreadyExistException {
        AuditParamsBuilder auditParamsBuilder = new AuditParamsBuilder().param("orgUnitId", (Object)id);
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_UPDATE_ORG_UNIT).params(auditParamsBuilder.build());
        this.authorizationHelper.assertFullAdministrationRights(() -> auditBuilder.buildFailure(request));
        OrganizationalUnit organizationalUnit = this.structureService.getOrganizationalUnit(id, new String[]{"directorPosition", "higherOrganizationalUnit"});
        if (organizationalUnit == null) {
            auditBuilder.buildFailure(request);
            throw new ServiceException(this.messageHelper.getMessage("Jednostka_organizacyjna_nie_istnieje", new Object[]{id}));
        }
        try {
            organizationalUnit.setName(unit.getOrganizationalUnitName());
            organizationalUnit.setSymbol(unit.getOrganizationalUnitSymbol());
            this.addHigherOrganizationalUnitAndDirector(unit, organizationalUnit);
            this.structureService.validateOrganizationalUnit(organizationalUnit);
            this.structureService.changeOrganizationalUnit(organizationalUnit);
            auditBuilder.params(auditParamsBuilder.params(this.updateOrgUnitAuditParams(unit, organizationalUnit)).build());
            auditBuilder.buildSuccess(request);
            return new RestResult(true);
        }
        catch (Exception e) {
            auditBuilder.buildFailure(request);
            throw e;
        }
    }

    @ApiOperation(value="(Admin) Exporting a list of organizational units", notes="Exports a list of system organizational units")
    @GetMapping(value={"export/{extension}"})
    public void export(HttpServletResponse response, @ApiParam(value="Extension", required=true) @PathVariable String extension, OrganizationalUnitSearchFilters filters, @ApiParam(value="Sort by", defaultValue="name") @RequestParam(required=false, defaultValue="name") String sortBy, @ApiParam(value="Sort direction", defaultValue="ASC", allowableValues="ASC,DESC") @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection) throws IOException {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        ArrayList<OrganizationalUnit> organizationalUnitDtos = new ArrayList<OrganizationalUnit>(this.structureService.getOrganizationalUnits(filters.getName(), filters.getSymbol(), filters.getHighOuName(), filters.getHighOuSymbol(), filters.getDirectorName(), filters.getDirectorSymbol(), Pagination.create((Sorter)new Sorter(sortBy, sortDirection), null, null)).getData());
        List<ExportColumn> columns = Arrays.asList(this.buildExportColumn(this.messageHelper.getMessage("Nazwa"), organizationalUnitDtos, organizationalUnit -> this.structureService.getOrganizationalUnitTranslation(organizationalUnit.getId(), TranslatedFieldType.NAME)), this.buildExportColumn(this.messageHelper.getMessage("Symbol"), organizationalUnitDtos, OrganizationalUnit::getSymbol), this.buildExportColumn(this.messageHelper.getMessage("Jednostka_nadrzedna"), organizationalUnitDtos, structureOrganizationalUnitDto -> Optional.ofNullable(structureOrganizationalUnitDto.getHigherOrganizationalUnit()).map(this::formatOrganizationalUnitNameAndSymbol).orElse("")), this.buildExportColumn(this.messageHelper.getMessage("Stanowisko_kierownicze"), organizationalUnitDtos, structureOrganizationalUnitDto -> Optional.ofNullable(structureOrganizationalUnitDto.getDirectorPosition()).map(this::formatPositionNameAndSymbol).orElse("")));
        ExportModel model = ExportModel.builder().title(this.messageHelper.getMessage("Jednostki_organizacyjne")).columns(columns).build();
        ExportExtension extensionEnum = ExportExtension.valueOf((String)extension.toUpperCase());
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", String.format("attachment; filename=\"export.%s\"", extensionEnum.getExtension()));
        this.exportService.export(model, extensionEnum, (OutputStream)response.getOutputStream());
    }

    private ExportColumn buildExportColumn(String name, List<OrganizationalUnit> data, Function<OrganizationalUnit, String> supplier) {
        return ExportColumnBuilder.create().name(name).data(data).by(supplier).build();
    }

    private void addHigherOrganizationalUnitAndDirector(AddOrganizationalUnitDto unit, OrganizationalUnit organizationalUnit) {
        if (unit.getHigherOrganizationalUnitId() != null) {
            organizationalUnit.setHigherOrganizationalUnit(Optional.ofNullable(this.structureService.getOrganizationalUnit(unit.getHigherOrganizationalUnitId(), new String[0])).orElseThrow(() -> new ServiceException(this.messageHelper.getMessage("Jednostka_organizacyjna_nie_istnieje", new Object[]{unit.getHigherOrganizationalUnitId()}))));
        } else {
            organizationalUnit.setHigherOrganizationalUnit(null);
        }
        if (unit.getDirectorPositionId() != null) {
            organizationalUnit.setDirectorPosition(Optional.ofNullable(this.structureService.getPosition(unit.getDirectorPositionId(), new String[0])).orElseThrow(() -> new ServiceException(this.messageHelper.getMessage("Stanowisko_nie_istnieje", new Object[]{unit.getDirectorPositionId()}))));
        } else {
            organizationalUnit.setDirectorPosition(null);
        }
    }

    private Map<String, Object> createAddAndDeleteOrgUnitAuditParams(AddOrganizationalUnitDto unit) {
        HashMap<String, Object> auditParams = new HashMap<String, Object>();
        OrganizationalUnit organizationalUnit = Optional.ofNullable(unit.getHigherOrganizationalUnitId()).map(x$0 -> this.structureService.getOrganizationalUnit(x$0, new String[0])).orElse(null);
        Position director = Optional.ofNullable(unit.getDirectorPositionId()).map(x$0 -> this.structureService.getPosition(x$0, new String[0])).orElse(null);
        String higherOuId = Optional.ofNullable(organizationalUnit).map(OrganizationalUnit::getId).map(String::valueOf).orElse("");
        String directorId = Optional.ofNullable(director).map(Position::getId).map(String::valueOf).orElse("");
        String higherUnitName = Optional.ofNullable(organizationalUnit).map(this::formatOrganizationalUnitNameAndSymbol).orElse("");
        String directorName = Optional.ofNullable(director).map(this::formatPositionNameAndSymbol).orElse("");
        auditParams.put("orgUnitName", unit.getOrganizationalUnitName());
        auditParams.put("orgUnitSymbol", unit.getOrganizationalUnitSymbol());
        auditParams.put("orgUnitHigherOrgUnit", higherOuId);
        auditParams.put("orgUnitHigherOrgUnitName", higherUnitName);
        auditParams.put("orgUnitDirector", directorId);
        auditParams.put("orgUnitDirectorName", directorName);
        return auditParams;
    }

    private String formatPositionNameAndSymbol(Position position) {
        return "%s - %s".formatted(position.getSymbol(), position.getName());
    }

    private String formatOrganizationalUnitNameAndSymbol(OrganizationalUnit organizationalUnit) {
        return "%s - %s".formatted(organizationalUnit.getSymbol(), organizationalUnit.getName());
    }

    private Map<String, Object> updateOrgUnitAuditParams(AddOrganizationalUnitDto unit, OrganizationalUnit oldUnit) {
        HashMap<String, Object> auditParams = new HashMap<String, Object>();
        OrganizationalUnit higherOrgUnit = Optional.ofNullable(unit.getHigherOrganizationalUnitId()).map(x$0 -> this.structureService.getOrganizationalUnit(x$0, new String[0])).orElse(null);
        Position director = Optional.ofNullable(unit.getDirectorPositionId()).map(x$0 -> this.structureService.getPosition(x$0, new String[0])).orElse(null);
        String oldOrgUnitHigherOrgUnitName = Optional.ofNullable(oldUnit.getHigherOrganizationalUnit()).map(this::formatOrganizationalUnitNameAndSymbol).orElse("");
        String oldOrgUnitDirectorName = Optional.ofNullable(oldUnit.getDirectorPosition()).map(this::formatPositionNameAndSymbol).orElse("");
        String orgUnitDirectorName = Optional.ofNullable(director).map(this::formatPositionNameAndSymbol).orElse("");
        String orgUnitHigherOuName = Optional.ofNullable(higherOrgUnit).map(this::formatOrganizationalUnitNameAndSymbol).orElse("");
        auditParams.put("orgUnitName", oldUnit.getName() + " > " + unit.getOrganizationalUnitName());
        auditParams.put("orgUnitSymbol", oldUnit.getSymbol() + " > " + unit.getOrganizationalUnitSymbol());
        auditParams.put("orgUnitHigherOrgUnit", oldOrgUnitHigherOrgUnitName + ";" + orgUnitHigherOuName);
        auditParams.put("orgUnitDirector", oldOrgUnitDirectorName + ";" + orgUnitDirectorName);
        return auditParams;
    }

    @ExceptionHandler(value={OrganizationalUnitAlreadyExistException.class, ServiceException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public RestResult handleBadRequest(Exception e) {
        log.info(e.getMessage());
        return new RestResult(false, e.getMessage());
    }

    @ExceptionHandler(value={EmptyPropertyException.class})
    @ResponseStatus(value=HttpStatus.PARTIAL_CONTENT)
    @ResponseBody
    public RestResult handleEmptyPropertyException(EmptyPropertyException e) {
        log.info(e.getMessage());
        return new RestResult(false, e.getMessage());
    }

    @ExceptionHandler(value={OrganizationalUnitNotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ResponseBody
    public RestResult handleOrganizationalUnitNotFoundException(OrganizationalUnitNotFoundException e) {
        log.info(e.getMessage());
        return new RestResult(false, e.getMessage());
    }

    @ExceptionHandler(value={NotFullRightsException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ResponseBody
    public RestResult handleNotFullRightsException(NotFullRightsException e) {
        log.info(this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
        return new RestResult(false, this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
    }

    @ConstructorProperties(value={"structureService", "exportService", "authorizationHelper", "messageHelper"})
    @Autowired
    public OrganizationalUnitController(StructureService structureService, ExportService exportService, AuthorizationHelper authorizationHelper, MessageHelperBean messageHelper) {
        this.structureService = structureService;
        this.exportService = exportService;
        this.authorizationHelper = authorizationHelper;
        this.messageHelper = messageHelper;
    }
}

