/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.struts.action;

import com.plusmpm.database.DBManagement;
import com.plusmpm.database.DomainTable;
import com.plusmpm.database.authorization.RightTreeBuilder;
import com.plusmpm.struts.action.util.DesEncrypter;
import com.plusmpm.struts.form.DomainForm;
import com.plusmpm.util.Authorization;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.i18n.MessageHelper;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class ChangeDomainAction
extends Action {
    public static Logger log = Logger.getLogger(ChangeDomainAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(false);
        String userName = (String)session.getAttribute("username");
        int rights = Authorization.checkRight((String)RightTreeBuilder.builder().system().admin().build(), (String)userName, (boolean)false, (boolean)false);
        if (rights == 0) {
            DomainForm domainForm = (DomainForm)form;
            if (session == null || userName == null) {
                return mapping.findForward("disconnect");
            }
            DBManagement dbm = new DBManagement();
            String domainId = domainForm.getDomainId();
            DomainTable domainTable = dbm.getDomain(domainId);
            Object message = "";
            String messageType = "";
            AuditBuilder builder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_UPDATE_LDAP_SERVER);
            HashMap<String, Object> params = new HashMap<String, Object>();
            try {
                params.put("domainId", domainForm.getDomainId());
                params.put("domainName", this.ensureAuditParamNotNull(domainTable.getDomainName()) + " > " + domainForm.getDomainName());
                String oldDomainServer = domainTable.getDomainName() != null ? domainTable.getDomainName() : "";
                params.put("domainServer", this.ensureAuditParamNotNull(domainTable.getDomainServerAdres()) + " > " + domainForm.getDomainServer());
                params.put("domainServerPort", this.ensureAuditParamNotNull(domainTable.getDomainServerPort()) + " > " + domainForm.getDomainServerPort());
                params.put("domainUser", this.ensureAuditParamNotNull(domainTable.getDomainUser()) + " > " + domainForm.getDomainUser());
                params.put("domainBaseSearch", this.ensureAuditParamNotNull(domainTable.getDomainBaseSearch()) + " > " + domainForm.getDomainBaseSearch());
                params.put("usernameTemplate", this.ensureAuditParamNotNull(domainTable.getUsernameTemplate()) + " > " + domainForm.getUsernameTemplate());
                params.put("domainSpnego", this.ensureAuditParamNotNull(domainTable.getDomainSpnego()) + " > " + domainForm.getDomainSpnego());
                builder.params(params);
                if (domainForm.validateSelectedFields()) {
                    domainTable = new DomainTable(domainForm.getDomainId(), domainForm.getDomainName(), domainForm.getDomainServer(), new Long(domainForm.getDomainServerPort()), domainForm.getDomainUser(), this.getDomainPassword(domainForm, domainTable), domainForm.getDomainBaseSearch(), domainForm.getUsernameTemplate(), domainForm.getDomainSpnego());
                    domainTable.setUsernameMapping(domainForm.getUsernameMapping());
                    domainTable.setFirstnameMapping(domainForm.getFirstnameMapping());
                    domainTable.setLastnameMapping(domainForm.getLastnameMapping());
                    domainTable.setEmailMapping(domainForm.getEmailMapping());
                    domainTable.setMemberMapping(domainForm.getMemberMapping());
                    domainTable.setMemberOfMapping(domainForm.getMemberOfMapping());
                    domainTable.setUserAttributeMapping(domainForm.getUserAttributeMapping());
                    domainTable.setGroupAttributeMapping(domainForm.getGroupAttributeMapping());
                    domainTable.setNumberMapping(domainForm.getNumberMapping());
                    domainTable.setLdapOverSsl(domainForm.getLdapOverSsl());
                    domainTable.setStartTLS(domainForm.getStartTLS());
                    dbm.changeDomain(domainTable);
                    request.setAttribute("audit", (Object)builder.buildSuccess());
                    message = MessageHelper.getMessage((String)"ldapChange.success");
                    messageType = "success";
                } else {
                    request.setAttribute("audit", (Object)builder.buildFailure());
                    message = MessageHelper.getMessage((String)"ldapChange.error.general") + " " + MessageHelper.getMessage((String)"ldapChange.error.incorrectValues");
                    messageType = "error";
                }
            }
            catch (Exception e) {
                log.error((Object)"B\u0142\u0105d podczas edycji serwera LDAP:", (Throwable)e);
                request.setAttribute("audit", (Object)builder.buildFailure());
                message = MessageHelper.getMessage((String)"ldapChange.error.general");
                messageType = "error";
            }
            request.setAttribute("message", message);
            request.setAttribute("messageType", (Object)messageType);
            ArrayList alDomains = dbm.GetAllDomains();
            request.setAttribute("alDomains", (Object)alDomains);
            return mapping.findForward("showNewDomains");
        }
        return mapping.findForward("welcome");
    }

    private String ensureAuditParamNotNull(Object auditParam) {
        return auditParam != null ? auditParam.toString() : "";
    }

    private String getDomainPassword(DomainForm domainForm, DomainTable domainTable) {
        String sDomainPassword = domainForm.getDomainUserPassword();
        if (sDomainPassword == null || sDomainPassword.trim().equals("")) {
            sDomainPassword = domainTable.getDomainUserPassword();
        } else {
            DesEncrypter d = new DesEncrypter();
            sDomainPassword = d.encrypt(sDomainPassword);
        }
        return sDomainPassword;
    }
}

