/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.servlet;

import com.plusmpm.database.workflow.activities.ActivityStatus;
import com.plusmpm.database.workflow.activities.ActivityStatusManagerExtended;
import com.plusmpm.util.json.extjs.gson.GsonCustomUtils;
import com.plusmpm.util.json.extjs.objects.JsonStore;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class GetActivityStatusesHistoryServlet
extends HttpServlet {
    public static final Logger LOG = Logger.getLogger(GetActivityStatusesHistoryServlet.class);
    private static final long serialVersionUID = -2676637618577300015L;

    private static List<Map<String, String>> convertRecordsToJson(List<ActivityStatus> records) {
        ArrayList<Map<String, String>> jsonRecords = new ArrayList<Map<String, String>>(records.size());
        for (ActivityStatus record : records) {
            HashMap<String, String> jsonRecord = new HashMap<String, String>();
            jsonRecord.put("id", record.getId().toString());
            jsonRecord.put("processId", record.getProcessId());
            jsonRecord.put("activityId", record.getActivityId());
            jsonRecord.put("authorUserName", record.getAuthorUserName());
            jsonRecord.put("acceptanceTime", record.getAcceptanceTime().toString());
            jsonRecord.put("createDate", String.valueOf(record.getCreateDate().getTime()));
            jsonRecord.put("message", record.getMessage());
            jsonRecord.put("newest", record.getNewest().toString());
            jsonRecord.put("type", record.getTypeAsEnum().toString());
            jsonRecords.add(jsonRecord);
        }
        return jsonRecords;
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        LOG.trace((Object)"****************************** GetActivityStatusesHistoryServlet.doGet ******************************");
        super.doGet(req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        LOG.trace((Object)"****************************** GetActivityStatusesHistoryServlet.doPost ******************************");
        try (PrintWriter printWriter = null;){
            String processId = req.getParameter("processId");
            String activityId = req.getParameter("activityId");
            List<Map<String, String>> jsonRecords = GetActivityStatusesHistoryServlet.convertRecordsToJson(ActivityStatusManagerExtended.getActivityStatuses((String)processId, (String)activityId));
            JsonStore jsonStore = new JsonStore();
            jsonStore.setRecords(jsonRecords);
            GsonCustomUtils gsonCustomUtils = new GsonCustomUtils();
            String sJsonData = gsonCustomUtils.getJsonForExtJsonStore(jsonStore);
            resp.setContentType("application/json");
            resp.setCharacterEncoding("UTF-8");
            printWriter = resp.getWriter();
            printWriter.print(sJsonData);
        }
    }
}

