/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.webapp.controllers.documents.show;

import com.plusmpm.util.Authorization;
import com.plusmpm.util.MimeTypeResolver;
import com.plusmpm.util.SharkFunctions;
import com.plusmpm.util.Tools;
import com.suncode.pwfl.administration.configuration.DefinedSystemParameter;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentSearchCache;
import com.suncode.pwfl.archive.DocumentService;
import com.suncode.pwfl.archive.DocumentViewExternalSource;
import com.suncode.pwfl.archive.DocumentViewsService;
import com.suncode.pwfl.archive.FileFinder;
import com.suncode.pwfl.archive.FileService;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.form.service.DocumentsService;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.security.XSSContentTypeProvider;
import com.suncode.pwfl.util.SpringContext;
import com.suncode.pwfl.web.util.SessionUtils;
import com.suncode.pwfl.workflow.form.documentview.actions.DocumentViewDto;
import com.suncode.pwfl.workflow.support.AdditionalFileRights;
import com.suncode.pwfl.workflow.support.OpenedFileContext;
import com.suncode.pwfl.workflow.support.ReadFileEventManager;
import com.suncode.pwfl.workflow.support.ViewFileEventManager;
import java.beans.ConstructorProperties;
import java.io.InputStream;
import java.util.List;
import java.util.UUID;
import javax.annotation.PostConstruct;
import javax.naming.NoPermissionException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"documents"})
public class DocumentShowController {
    private static final Logger log = LoggerFactory.getLogger(DocumentShowController.class);
    private final FileService fileService;
    private final FileFinder fileFinder;
    private final MessageHelperBean messageHelper;
    private final DocumentSearchCache documentSearchCache;
    private final DocumentsService documentsService;
    private final DocumentService documentService;
    private final XSSContentTypeProvider xssContentTypeProvider;
    private List<String> xssProneContentTypes;

    @PostConstruct
    protected void init() {
        this.xssProneContentTypes = this.xssContentTypeProvider.getXSSProneContentTypes();
    }

    @RequestMapping(value={"{fileId}/show.do"})
    public String show(@PathVariable Long fileId, @RequestParam(required=false) String processId, @RequestParam(required=false) String activityId, @RequestParam(required=false) String processRightKey, HttpServletRequest request) throws NoPermissionException {
        return this.executeShow(fileId, processId, activityId, processRightKey, request);
    }

    @RequestMapping(value={"showForActivity.do"})
    public String showDecoded(@RequestParam String fileName, @RequestParam String processId, @RequestParam String activityId, @RequestParam(required=false) String processRightKey, HttpServletRequest request) throws NoPermissionException {
        return this.executeShow(Long.parseLong(Tools.decodeStringBase64((String)fileName)), processId, activityId, processRightKey, request);
    }

    @NotNull
    private String executeShow(Long fileId, String processId, String activityId, String processRightKey, HttpServletRequest request) throws NoPermissionException {
        String userName = SessionUtils.getLoggedUserName();
        WfFile wfFile = this.fileService.getFile(fileId, new String[]{"documentClass", "version"});
        DocumentClass docClass = wfFile.getDocumentClass();
        if (docClass != null) {
            boolean hasRightsToNewestVersion;
            boolean hasRights = this.documentSearchCache.containsFileIdForUser(userName, fileId) || Authorization.hasRightsToReadFile((String)userName, (Long)fileId, (String)processRightKey);
            Long newestVersionFileId = wfFile.getVersion().getNewestFile().getId();
            boolean bl = hasRightsToNewestVersion = this.documentSearchCache.containsFileIdForUser(userName, newestVersionFileId) || Authorization.hasRightsToReadFile((String)userName, (Long)newestVersionFileId, (String)processRightKey);
            if (hasRights || hasRightsToNewestVersion) {
                try {
                    boolean condition = this.checkAdditionalRights(userName, fileId, processId);
                    if (!condition) {
                        throw new NoPermissionException(this.messageHelper.getMessage("Nie_masz_dostepu_do_tego_pliku"));
                    }
                }
                catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException e) {
                    log.error("Podana klasa w pliku konfiguracyjnym do sprawdzania dodatkowych uprawnie\u0144 musi implementowa\u0107 interfejs AdditionalFileRights");
                    throw new NoPermissionException(this.messageHelper.getMessage("Wystapil_nieoczekiwany_blad"));
                }
                long fileSize = wfFile.getSize();
                String fileName = wfFile.getSystemFileName();
                String orgFileName = wfFile.getFileName();
                log.info("Wczytano plik - id: " + fileId + " fileName: " + fileName + " orgFileName: " + orgFileName + " size: " + fileSize);
                boolean oneDrivePreviewAvailable = false;
                boolean googleDocsPreviewAvailable = false;
                if (this.documentsService.isMSOfficeDocument(orgFileName)) {
                    String actDefId;
                    DocumentViewsService documentViewsService = (DocumentViewsService)SpringContext.getBean(DocumentViewsService.class);
                    DocumentViewDto document = DocumentViewDto.builder().fileId(fileId).fileName(fileName).documentClassId(docClass.getId()).build();
                    String procDefId = SharkFunctions.getProcessDefId((String)processId);
                    if (documentViewsService.checkAllowExternalPreviewInGlobalDocumentViewsSettings(procDefId, actDefId = SharkFunctions.getActivityDefId((String)processId, (String)activityId), document, DocumentViewExternalSource.ONE_DRIVE).booleanValue()) {
                        oneDrivePreviewAvailable = true;
                    } else if (documentViewsService.checkAllowExternalPreviewInGlobalDocumentViewsSettings(procDefId, actDefId, document, DocumentViewExternalSource.GOOGLE_DOCS).booleanValue()) {
                        googleDocsPreviewAvailable = true;
                    }
                }
                request.setAttribute("success", (Object)true);
                request.setAttribute("fileId", (Object)fileId);
                request.setAttribute("documentId", (Object)this.documentService.getDocument(fileId).getId());
                request.setAttribute("documentClassId", (Object)docClass.getId());
                request.setAttribute("originalFilename", (Object)this.getOriginalFileName(orgFileName));
                request.setAttribute("processId", (Object)processId);
                request.setAttribute("activityId", (Object)activityId);
                request.setAttribute("sandbox", (Object)this.getSandBoxParameter(wfFile, processId, activityId));
                request.setAttribute("oneDrivePreviewAvailable", (Object)oneDrivePreviewAvailable);
                request.setAttribute("googleDocsPreviewAvailable", (Object)googleDocsPreviewAvailable);
            } else {
                log.info("Brak praw do wy\u015bwietlenia dokumentu - u\u017cytkownik: " + userName);
                request.setAttribute("success", (Object)false);
                request.setAttribute("errorMessage", (Object)this.messageHelper.getMessage("Brak_uprawnien"));
            }
        }
        return "/documents/documentShowFile.jsp";
    }

    @GetMapping
    @RequestMapping(value={"showByLink.do"})
    public String show(@RequestParam(value="guid") UUID guid, HttpServletRequest request) throws NoPermissionException {
        String userName = SessionUtils.getLoggedUserName();
        WfFile wfFile = this.fileFinder.findByGuid(guid);
        if (wfFile == null) {
            log.warn("Nie znaleziono dokumentu z GUID = " + String.valueOf(guid));
            request.setAttribute("success", (Object)false);
            request.setAttribute("errorMessage", (Object)this.messageHelper.getMessage("Plik_z_podanym_guid_nie_istnieje"));
            return "/documents/documentShowFile.jsp";
        }
        DocumentClass docClass = wfFile.getDocumentClass();
        if (docClass == null || !docClass.isShowByLink()) {
            log.warn("Klasa dokument\u00f3w dla pliku o GUID = {} nie istnieje lub nie obs\u0142uguje wy\u015bwietlania za pomoc\u0105 GUID ", (Object)guid.toString());
            request.setAttribute("success", (Object)false);
            request.setAttribute("errorMessage", (Object)this.messageHelper.getMessage("Klasa_dokumentow_nie_obsluguje_otwieranie_za_pomoca_linku"));
            return "/documents/documentShowFile.jsp";
        }
        if (!Authorization.hasRightsToDisplayDocumentByLink((Long)docClass.getId(), (String)userName)) {
            log.warn("Brak praw do wy\u015bwietlenia dokumentu - u\u017cytkownik: " + userName);
            request.setAttribute("success", (Object)false);
            request.setAttribute("errorMessage", (Object)this.messageHelper.getMessage("Brak_uprawnien"));
            return "/documents/documentShowFile.jsp";
        }
        String orgFileName = wfFile.getFileName();
        request.setAttribute("success", (Object)true);
        request.setAttribute("guid", (Object)guid);
        request.setAttribute("originalFilename", (Object)this.getOriginalFileName(orgFileName));
        request.setAttribute("sandbox", (Object)this.getSandBoxParameter(wfFile, null, null));
        request.setAttribute("showByLink", (Object)true);
        return "/documents/documentShowFile.jsp";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean getSandBoxParameter(WfFile wfFile, String processId, String activityId) {
        String mimeType = MimeTypeResolver.resolve((String)wfFile.getFileName());
        String username = UserContext.current().getUser().getUserName();
        try (InputStream is = this.fileService.getFileInputStream(Long.valueOf(wfFile.getId()));){
            OpenedFileContext fileContext = ReadFileEventManager.execute((InputStream)is, (WfFile)wfFile, (String)mimeType, (String)processId, (String)activityId, (String)username);
            OpenedFileContext viewFileContext = ViewFileEventManager.execute((OpenedFileContext)fileContext);
            if (viewFileContext.getSandbox() != null) {
                boolean bl2 = viewFileContext.getSandbox();
                return bl2;
            }
            boolean bl = this.xssProneContentTypes.stream().anyMatch(type -> type.equals(viewFileContext.getMimeType()));
            return bl;
        }
        catch (Exception e) {
            log.error("Couldn't resolve if file is save to display in iframe. Sandbox will be enabled.");
            log.error(e.getMessage(), (Throwable)e);
            return true;
        }
    }

    private String getOriginalFileName(String orgFileName) {
        return StringEscapeUtils.escapeEcmaScript((String)orgFileName).replaceAll("/", "_").replaceAll("\\\\", "_").replace("'", "\\'");
    }

    private boolean checkAdditionalRights(String username, Long fileId, String processId) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> cls;
        String additionalFileRights = SystemProperties.getString((DefinedSystemParameter)DefinedSystemParameter.ADDITIONAL_FILE_RIGHTS);
        if (StringUtils.isEmpty((String)additionalFileRights)) {
            return true;
        }
        String callPlace = "process";
        if (StringUtils.isEmpty((String)processId)) {
            callPlace = "archive";
        }
        if (!AdditionalFileRights.class.isAssignableFrom(cls = Class.forName(additionalFileRights))) {
            throw new IllegalArgumentException();
        }
        AdditionalFileRights sfc = (AdditionalFileRights)cls.newInstance();
        return sfc.checkAdditionalRights(username, fileId.toString(), callPlace);
    }

    @ConstructorProperties(value={"fileService", "fileFinder", "messageHelper", "documentSearchCache", "documentsService", "documentService", "xssContentTypeProvider"})
    @Autowired
    public DocumentShowController(FileService fileService, FileFinder fileFinder, MessageHelperBean messageHelper, DocumentSearchCache documentSearchCache, DocumentsService documentsService, DocumentService documentService, XSSContentTypeProvider xssContentTypeProvider) {
        this.fileService = fileService;
        this.fileFinder = fileFinder;
        this.messageHelper = messageHelper;
        this.documentSearchCache = documentSearchCache;
        this.documentsService = documentsService;
        this.documentService = documentService;
        this.xssContentTypeProvider = xssContentTypeProvider;
    }
}

