/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.support.plugin;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.suncode.plugin.framework.cluster.NodeId;
import com.suncode.plugin.framework.core.ReconciliationStatus;
import com.suncode.pwfl.util.Maps;
import com.suncode.pwfl.web.support.plugin.PluginReconciliationStatus;
import java.util.Map;
import lombok.NonNull;

public record NodesReconciliationStatus(@NonNull Map<NodeId, PluginReconciliationStatus> nodes) {
    public NodesReconciliationStatus(@NonNull Map<NodeId, PluginReconciliationStatus> nodes) {
        if (nodes == null) {
            throw new NullPointerException("nodes is marked non-null but is null");
        }
    }

    @JsonProperty
    public int total() {
        return this.nodes.size();
    }

    @JsonProperty
    public int synced() {
        return (int)this.nodes.values().stream().filter(PluginReconciliationStatus::isSynced).count();
    }

    public static NodesReconciliationStatus from(Map<NodeId, ReconciliationStatus> clusterStatus) {
        return new NodesReconciliationStatus(Maps.mapValues(clusterStatus, (nodeId, nodeStatus) -> PluginReconciliationStatus.from(nodeStatus)));
    }
}

