/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.dto.archive;

import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.Link;
import com.suncode.pwfl.archive.LinkConnection;
import com.suncode.pwfl.archive.LinkService;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.translation.configElements.TranslatedFieldType;
import com.suncode.pwfl.util.DtoComparator;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.web.dto.archive.AssociatedIndexesDto;
import java.beans.ConstructorProperties;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class LinkAssociationDto {
    private Long linkId;
    private String linkTranslatedName;
    private Long documentClassId;
    private String documentClassTranslatedName;
    private List<AssociatedIndexesDto> associatedIndexes;

    public static LinkAssociationDto from(List<LinkConnection> linkConnections, Link link, DocumentClass documentClass) {
        LinkService linkService = ServiceFactory.getLinkService();
        DocumentClassService documentClassService = ServiceFactory.getDocumentClassService();
        LinkAssociationDto linkAssociationDto = LinkAssociationDto.builder().linkId(link.getId()).linkTranslatedName(linkService.getLinkTranslation(link.getId(), TranslatedFieldType.NAME)).documentClassId(documentClass.getId()).documentClassTranslatedName(documentClassService.getDocumentClassTranslation(documentClass.getId(), TranslatedFieldType.NAME)).build();
        List<AssociatedIndexesDto> associatedIndexesDtos = linkConnections.stream().map(AssociatedIndexesDto::fromLinkConnection).sorted((Comparator<AssociatedIndexesDto>)DtoComparator.of(AssociatedIndexesDto.class, (String)"parentIndexOrder", (SortDirection)SortDirection.ASC)).collect(Collectors.toList());
        linkAssociationDto.setAssociatedIndexes(associatedIndexesDtos);
        return linkAssociationDto;
    }

    public static LinkAssociationDtoBuilder builder() {
        return new LinkAssociationDtoBuilder();
    }

    public Long getLinkId() {
        return this.linkId;
    }

    public String getLinkTranslatedName() {
        return this.linkTranslatedName;
    }

    public Long getDocumentClassId() {
        return this.documentClassId;
    }

    public String getDocumentClassTranslatedName() {
        return this.documentClassTranslatedName;
    }

    public List<AssociatedIndexesDto> getAssociatedIndexes() {
        return this.associatedIndexes;
    }

    public void setLinkId(Long linkId) {
        this.linkId = linkId;
    }

    public void setLinkTranslatedName(String linkTranslatedName) {
        this.linkTranslatedName = linkTranslatedName;
    }

    public void setDocumentClassId(Long documentClassId) {
        this.documentClassId = documentClassId;
    }

    public void setDocumentClassTranslatedName(String documentClassTranslatedName) {
        this.documentClassTranslatedName = documentClassTranslatedName;
    }

    public void setAssociatedIndexes(List<AssociatedIndexesDto> associatedIndexes) {
        this.associatedIndexes = associatedIndexes;
    }

    @ConstructorProperties(value={"linkId", "linkTranslatedName", "documentClassId", "documentClassTranslatedName", "associatedIndexes"})
    public LinkAssociationDto(Long linkId, String linkTranslatedName, Long documentClassId, String documentClassTranslatedName, List<AssociatedIndexesDto> associatedIndexes) {
        this.linkId = linkId;
        this.linkTranslatedName = linkTranslatedName;
        this.documentClassId = documentClassId;
        this.documentClassTranslatedName = documentClassTranslatedName;
        this.associatedIndexes = associatedIndexes;
    }

    public LinkAssociationDto() {
    }

    public static class LinkAssociationDtoBuilder {
        private Long linkId;
        private String linkTranslatedName;
        private Long documentClassId;
        private String documentClassTranslatedName;
        private List<AssociatedIndexesDto> associatedIndexes;

        LinkAssociationDtoBuilder() {
        }

        public LinkAssociationDtoBuilder linkId(Long linkId) {
            this.linkId = linkId;
            return this;
        }

        public LinkAssociationDtoBuilder linkTranslatedName(String linkTranslatedName) {
            this.linkTranslatedName = linkTranslatedName;
            return this;
        }

        public LinkAssociationDtoBuilder documentClassId(Long documentClassId) {
            this.documentClassId = documentClassId;
            return this;
        }

        public LinkAssociationDtoBuilder documentClassTranslatedName(String documentClassTranslatedName) {
            this.documentClassTranslatedName = documentClassTranslatedName;
            return this;
        }

        public LinkAssociationDtoBuilder associatedIndexes(List<AssociatedIndexesDto> associatedIndexes) {
            this.associatedIndexes = associatedIndexes;
            return this;
        }

        public LinkAssociationDto build() {
            return new LinkAssociationDto(this.linkId, this.linkTranslatedName, this.documentClassId, this.documentClassTranslatedName, this.associatedIndexes);
        }

        public String toString() {
            return "LinkAssociationDto.LinkAssociationDtoBuilder(linkId=" + this.linkId + ", linkTranslatedName=" + this.linkTranslatedName + ", documentClassId=" + this.documentClassId + ", documentClassTranslatedName=" + this.documentClassTranslatedName + ", associatedIndexes=" + String.valueOf(this.associatedIndexes) + ")";
        }
    }
}

