/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.workflow.search;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.google.common.collect.ImmutableMap;
import com.plusmpm.database.AdvanceSearchVariableTable;
import com.plusmpm.database.DBManagement;
import com.plusmpm.database.SearchMode;
import com.plusmpm.database.UserSearchViewTable;
import com.plusmpm.database.authorization.RightTreeBuilder;
import com.plusmpm.struts.form.AdvanceVariableForm;
import com.plusmpm.util.ActivityVariable;
import com.plusmpm.util.Authorization;
import com.plusmpm.util.ProcesType;
import com.plusmpm.util.ProcessVariableHelper;
import com.plusmpm.util.SearchProcessVariable;
import com.plusmpm.util.XpdlPackageManager;
import com.suncode.plugin.framework.PluginFramework;
import com.suncode.pwfl.administration.configuration.DefinedSystemParameter;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.administration.configuration.SystemPropertiesBean;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.experimental.Experimental;
import com.suncode.pwfl.license.LicenseService;
import com.suncode.pwfl.search.SearchFormModelBuilder;
import com.suncode.pwfl.search.SearchViewService;
import com.suncode.pwfl.util.exception.ServiceException;
import com.suncode.pwfl.view.ViewAccessLevel;
import com.suncode.pwfl.web.search.model.SaveViewDto;
import com.suncode.pwfl.web.search.model.SearchFormModelDto;
import com.suncode.pwfl.web.search.model.SearchViewDto;
import com.suncode.pwfl.web.support.ajax.RestResult;
import com.suncode.pwfl.web.util.SessionUtils;
import java.beans.ConstructorProperties;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import lombok.NonNull;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.DynaActionForm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"search"})
public class SearchController {
    private static final Logger log = LoggerFactory.getLogger(SearchController.class);
    private final LicenseService licenseService;
    private final SystemPropertiesBean systemPropertiesBean;
    private final SearchFormModelBuilder searchFormBuilder;
    private final PluginFramework pluginFramework;
    private final Experimental experimental;
    private final UserService userService;
    private final SearchViewService searchViewService;

    @ResponseBody
    @RequestMapping(value={"feature/preview"})
    public Boolean hasPreviewFeature() {
        return this.licenseService.hasFeature("process-search-documents-preview");
    }

    @ResponseBody
    @RequestMapping(value={"feature/attach"})
    public Boolean hasAttachFeature() {
        return this.licenseService.hasFeature("process-search-documents-attach") || this.pluginFramework.isActive("com.suncode.plugin-wizards-attach-documents");
    }

    @ResponseBody
    @RequestMapping(value={"parameter/resultsInOneRow"})
    public Boolean getResultsInOneRow() {
        return SystemProperties.getBoolean((DefinedSystemParameter)DefinedSystemParameter.AGGREGATE_ARRAY_VARIABLES_ENABLED);
    }

    @ResponseBody
    @RequestMapping(value={"parameter/elasticEnabled"})
    public Boolean getElasticEnabled() {
        return SystemProperties.getBoolean((DefinedSystemParameter)DefinedSystemParameter.ELASTIC_ENABLED);
    }

    @ResponseBody
    @RequestMapping(value={"parameter/elasticMaxResultWindow"})
    public Long getElasticMaxResultWindow() {
        return SystemProperties.getLong((DefinedSystemParameter)DefinedSystemParameter.ELASTIC_MAX_RESULT_WINDOW);
    }

    @ResponseBody
    @RequestMapping(value={"parameter/caseSensitiveDisabled"})
    public Boolean getCaseSensitiveDisabled() {
        return SystemProperties.getBoolean((DefinedSystemParameter)DefinedSystemParameter.CASE_SENSITIVE_DISABLED);
    }

    @RequestMapping(value={"view/form/save/{id}"}, method={RequestMethod.POST})
    public ResponseEntity<?> updateView(HttpServletRequest request, @PathVariable Long id, @RequestBody SaveViewDto saveViewDto) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_SAVE_VIEW).params(this.buildAuditParams(id, saveViewDto));
        try {
            this.searchViewService.updateSearchView(id, saveViewDto);
        }
        catch (Exception e) {
            log.error("Exception: " + e.getLocalizedMessage(), (Throwable)e);
            auditBuilder.buildFailure(request);
            throw e;
        }
        auditBuilder.buildSuccess(request);
        return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"view/form/save"}, method={RequestMethod.POST})
    public ResponseEntity<?> addView(HttpServletRequest request, @RequestBody SaveViewDto saveViewDto) {
        long viewId;
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_SAVE_VIEW);
        Map<String, Object> auditParams = this.buildAuditParams(null, saveViewDto);
        User user = this.userService.getUser(SessionUtils.getLoggedUserName(), new String[0]);
        try {
            viewId = this.searchViewService.addSearchView(saveViewDto, ViewAccessLevel.PRIVATE, user);
        }
        catch (Exception e) {
            log.error("Exception: " + e.getLocalizedMessage(), (Throwable)e);
            auditBuilder.params(auditParams).buildFailure(request);
            throw e;
        }
        auditParams.put("viewId", viewId);
        auditBuilder.params(auditParams).buildSuccess(request);
        return new ResponseEntity((Object)ImmutableMap.of((Object)"viewId", (Object)viewId), (HttpStatusCode)HttpStatus.OK);
    }

    @ResponseBody
    @RequestMapping(value={"/view/form/{id}"}, method={RequestMethod.GET})
    public SearchViewDto getViewById(@PathVariable Long id) {
        try {
            return this.getSearchViewById(id);
        }
        catch (MalformedSearchFormValue | MissingSearchFormValue e) {
            return this.getSearchViewById(id, false);
        }
    }

    @ResponseBody
    @RequestMapping(value={"/view/filters/{id}"}, method={RequestMethod.GET})
    public SearchViewDto getViewFiltersById(@PathVariable Long id) {
        return this.getSearchViewById(id, true);
    }

    private SearchViewDto getSearchViewById(@NonNull Long id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        DBManagement dbm = new DBManagement();
        UserSearchViewTable userSearchViewTable = dbm.getUserSearchView(String.valueOf(id));
        SearchViewDto searchViewDto = new SearchViewDto();
        String searchFormModel = userSearchViewTable.getSearchFormModel();
        if (StringUtils.isBlank((String)searchFormModel)) {
            throw new MissingSearchFormValue();
        }
        try {
            SearchFormModelDto searchFormModelDto = this.searchFormBuilder.buildSearchFormModelWithTypeInfo(searchFormModel);
            searchViewDto.setSearchFormModelDto(searchFormModelDto);
            ViewAccessLevel viewAccessLevel = userSearchViewTable.getAccessLevel() == ViewAccessLevel.PUBLIC && !userSearchViewTable.getUserName().equalsIgnoreCase(UserContext.current().getUser().getUserName()) ? ViewAccessLevel.PUBLIC : ViewAccessLevel.PRIVATE;
            searchViewDto.setViewType(viewAccessLevel);
            searchViewDto.setAcceptFromAllPages(Boolean.parseBoolean(userSearchViewTable.getAcceptFromAllPages()));
            searchViewDto.setAcceptManyTasks(Boolean.parseBoolean(userSearchViewTable.getAcceptManyTasks()));
            searchViewDto.setShowSearchResultOnResult(Boolean.parseBoolean(userSearchViewTable.getShowSearchResultOnResult()));
            searchViewDto.setShowVariables(StringUtils.isNotBlank((String)searchFormModelDto.getProcessVariablesSearchModel().getProcessDefinitionId()));
            searchViewDto.setShowFormOnResult(Boolean.parseBoolean(userSearchViewTable.getShowFormOnResult()));
            searchViewDto.setShowOnlyLatestActivityDetails(userSearchViewTable.isShowOnlyLatestActivityDetails());
            searchViewDto.setEnableDocumentZipExport(userSearchViewTable.isEnableDocumentZipExport());
            return searchViewDto;
        }
        catch (JsonParseException | JsonMappingException e) {
            log.debug("Search form model object: " + searchFormModel);
            log.error("Error occurred when processing search form value: ", e);
            throw new MalformedSearchFormValue();
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SearchViewDto getSearchViewById(Long id, boolean isFilters) {
        boolean enableDocumentZipExport;
        boolean showOnlyLatestActivityDetails;
        boolean showFormOnResult;
        boolean acceptFromAllPages;
        boolean acceptManyTasks;
        boolean showSearchResultOnResult;
        ViewAccessLevel viewAccessLevel;
        boolean showVariables;
        AdvanceVariableForm[] extraSearchVariable;
        TreeMap<Integer, AdvanceVariableForm> searchVariable;
        block25: {
            searchVariable = new TreeMap<Integer, AdvanceVariableForm>();
            extraSearchVariable = new AdvanceVariableForm[]{new AdvanceVariableForm(), new AdvanceVariableForm()};
            showVariables = false;
            viewAccessLevel = null;
            showSearchResultOnResult = false;
            acceptManyTasks = false;
            acceptFromAllPages = false;
            showFormOnResult = false;
            showOnlyLatestActivityDetails = false;
            enableDocumentZipExport = false;
            try {
                int iMax = 0;
                HttpServletRequest request = (HttpServletRequest)SessionUtils.getCurrentRequest();
                HttpSession session = request.getSession(false);
                String userName = SessionUtils.getLoggedUserName();
                if (!StringUtils.isNotBlank((String)userName)) break block25;
                ArrayList<ProcesType> alNewProcTypes = new ArrayList<ProcesType>();
                ArrayList alProcTypes = SearchProcessVariable.SearchProcessesTypes((HttpServletRequest)request);
                DynaActionForm advanceSearchForm = new DynaActionForm();
                advanceSearchForm.getMap().put("variable", searchVariable);
                advanceSearchForm.getMap().put("extra", extraSearchVariable);
                HashMap<String, Integer> hmVariables = new HashMap<String, Integer>();
                hmVariables.put("processType", 0);
                hmVariables.put("procName", 1);
                hmVariables.put("procDescr", 2);
                hmVariables.put("procInitiator", 3);
                hmVariables.put("procStateSelect", 4);
                hmVariables.put("realizationPercent", 5);
                hmVariables.put("procStart", 6);
                hmVariables.put("procFinish", 7);
                hmVariables.put("processDeadline", 8);
                hmVariables.put("taskName", 9);
                hmVariables.put("taskStateSelect", 10);
                hmVariables.put("taskUser", 11);
                hmVariables.put("taskStart", 12);
                hmVariables.put("taskFinish", 13);
                hmVariables.put("taskDeadline", 14);
                hmVariables.put("onlyActiveTask", 15);
                hmVariables.put("onlyLoggedUserTask", 16);
                hmVariables.put("procDefId", 17);
                hmVariables.put("taskDeadlineName", 18);
                hmVariables.put("resultsInOneRow", 19);
                HashMap<String, Integer> extraVariables = new HashMap<String, Integer>();
                extraVariables.put("process-search-documents-preview", 0);
                extraVariables.put("process-search-documents-attach", 1);
                int iStartVarNr = 20;
                Connection con = null;
                try {
                    con = DBManagement.ConnectToDB();
                    int i = 0;
                    while (true) {
                        if (i >= alProcTypes.size()) {
                            this.sortProcessesByName(alNewProcTypes);
                            break;
                        }
                        ProcesType procType = (ProcesType)alProcTypes.get(i);
                        String rightType = RightTreeBuilder.builder().system().workflow().processes().view().custom((Object)procType.getSProcTypeId()).build();
                        if (Authorization.CheckRight((String)rightType, (String)userName, (boolean)false, (Connection)con) == 0) {
                            alNewProcTypes.add(procType);
                            Long variablesSize = XpdlPackageManager.getInstance().getVariablesCount(procType.getSPackageId(), procType.getSProcTypeId());
                            if (variablesSize > (long)iMax) {
                                iMax = variablesSize.intValue();
                            }
                        }
                        ++i;
                    }
                }
                finally {
                    DBManagement.CloseConnection((Connection)con);
                }
                String sViewId = id.toString();
                if (sViewId != null && sViewId.compareToIgnoreCase("") != 0) {
                    String sAcceptFromAllPages;
                    String sAcceptManyTasks;
                    String procDefId;
                    DBManagement dbm = new DBManagement();
                    UserSearchViewTable userSearchViewTable = dbm.getUserSearchView(sViewId);
                    ArrayList alAdvVariables = dbm.GetAllAdvanceSearchVariableInView(sViewId);
                    HashMap<String, String> variablesSubTypes = new HashMap<String, String>();
                    HashMap<String, String> variablesTypes = new HashMap<String, String>();
                    showVariables = false;
                    Optional<Object> processDefVariable = alAdvVariables.stream().filter(variable -> "procDefId".equals(((AdvanceSearchVariableTable)variable).getName())).findFirst();
                    if (processDefVariable.isPresent() && StringUtils.isNotBlank((String)(procDefId = ((AdvanceSearchVariableTable)processDefVariable.get()).getValue()))) {
                        showVariables = true;
                        ProcessVariableHelper processVariableHelper = new ProcessVariableHelper();
                        ArrayList<ActivityVariable> alVariables = processVariableHelper.getVariablesForProcess(((AdvanceSearchVariableTable)processDefVariable.get()).getValue());
                        for (int iVarSetLength = 0; iVarSetLength < alVariables.size(); ++iVarSetLength) {
                            ActivityVariable actVar = alVariables.get(iVarSetLength);
                            if (actVar == null) continue;
                            hmVariables.put(actVar.getM_sVariableName(), iStartVarNr);
                            variablesSubTypes.put(actVar.getM_sVariableName(), actVar.getM_sSubType());
                            variablesTypes.put(actVar.getM_sVariableName(), actVar.getM_sVariableType());
                            ++iStartVarNr;
                        }
                    }
                    for (int i = 0; i < alAdvVariables.size(); ++i) {
                        AdvanceSearchVariableTable advSearchVariable = (AdvanceSearchVariableTable)alAdvVariables.get(i);
                        String sName = advSearchVariable.getName();
                        if (sName == null || sName.compareToIgnoreCase("") == 0) continue;
                        Integer iIntObj = (Integer)hmVariables.get(sName);
                        if (iIntObj == null) {
                            Integer index;
                            if (!advSearchVariable.isExtra() || (index = (Integer)extraVariables.get(sAcceptManyTasks = advSearchVariable.getExtraName())) == null) continue;
                            extraSearchVariable[index].setName(sAcceptManyTasks);
                            extraSearchVariable[index].setValue(advSearchVariable.getValue());
                            extraSearchVariable[index].setValue2(advSearchVariable.getValue2());
                            extraSearchVariable[index].setPosition(advSearchVariable.getPosition());
                            extraSearchVariable[index].setActive(advSearchVariable.getActive());
                            extraSearchVariable[index].setSortType(advSearchVariable.getSortType());
                            extraSearchVariable[index].setUpperCase(advSearchVariable.getUppercase());
                            continue;
                        }
                        int iPos = iIntObj;
                        sAcceptFromAllPages = advSearchVariable.getValue();
                        String viewName = advSearchVariable.getValue2();
                        SearchMode searchMode = advSearchVariable.getSearchMode();
                        AdvanceVariableForm searchVariableAtPosition = new AdvanceVariableForm();
                        searchVariableAtPosition.setName(sName);
                        searchVariableAtPosition.setValue(sAcceptFromAllPages);
                        searchVariableAtPosition.setValue2(viewName);
                        searchVariableAtPosition.setPosition(advSearchVariable.getPosition());
                        searchVariableAtPosition.setActive(advSearchVariable.getActive());
                        String showFilter = advSearchVariable.getShowFilter();
                        searchVariableAtPosition.setShowFilter(showFilter);
                        String disableFilter = advSearchVariable.getDisableFilter();
                        searchVariableAtPosition.setDisableFilter(disableFilter);
                        searchVariableAtPosition.setSortType(advSearchVariable.getSortType());
                        searchVariableAtPosition.setUpperCase(advSearchVariable.getUppercase());
                        String variableType = (String)variablesTypes.get(sName);
                        if (searchMode == null && ("INTEGER".equals(variableType) || "FLOAT".equals(variableType))) {
                            searchVariableAtPosition.setSearchMode(SearchMode.RANGE.name());
                        } else if (searchMode == null && StringUtils.isNotBlank((String)viewName)) {
                            searchVariableAtPosition.setSearchMode(SearchMode.RANGE.name());
                        } else if (searchMode == null) {
                            searchVariableAtPosition.setSearchMode(SearchMode.SINGLE.name());
                        } else {
                            searchVariableAtPosition.setSearchMode(searchMode.name());
                        }
                        searchVariable.put(iPos, searchVariableAtPosition);
                    }
                    String owner = userSearchViewTable.getUserName();
                    viewAccessLevel = userSearchViewTable.getAccessLevel();
                    viewAccessLevel = viewAccessLevel.equals((Object)ViewAccessLevel.PUBLIC) && !owner.equalsIgnoreCase(userName) ? ViewAccessLevel.PUBLIC : ViewAccessLevel.PRIVATE;
                    String sShowSearchResultOnResult = userSearchViewTable.getShowSearchResultOnResult();
                    showSearchResultOnResult = sShowSearchResultOnResult != null && sShowSearchResultOnResult.compareToIgnoreCase("true") == 0;
                    sAcceptManyTasks = userSearchViewTable.getAcceptManyTasks();
                    sAcceptFromAllPages = userSearchViewTable.getAcceptFromAllPages();
                    String showFormOnResultSetting = userSearchViewTable.getShowFormOnResult();
                    showFormOnResult = showFormOnResultSetting != null && showFormOnResultSetting.equalsIgnoreCase("true");
                    showOnlyLatestActivityDetails = userSearchViewTable.isShowOnlyLatestActivityDetails();
                    enableDocumentZipExport = userSearchViewTable.isEnableDocumentZipExport();
                    if (sAcceptManyTasks != null && sAcceptManyTasks.compareToIgnoreCase("true") == 0) {
                        acceptManyTasks = true;
                        session.setAttribute("acceptManyTasks", (Object)"TRUE");
                        if (sAcceptFromAllPages != null && sAcceptFromAllPages.equalsIgnoreCase("true")) {
                            acceptFromAllPages = true;
                            session.setAttribute("acceptFromAllPages", (Object)"TRUE");
                        } else {
                            acceptFromAllPages = false;
                            session.setAttribute("acceptFromAllPages", (Object)"FALSE");
                        }
                    } else {
                        acceptManyTasks = false;
                        session.setAttribute("acceptManyTasks", (Object)"FALSE");
                        acceptFromAllPages = false;
                        session.setAttribute("acceptFromAllPages", (Object)"FALSE");
                    }
                    request.setAttribute("viewId", (Object)sViewId);
                    if (!isFilters) {
                        session.setAttribute("viewId", (Object)sViewId);
                    }
                }
            }
            catch (Exception iMax) {
                // empty catch block
            }
        }
        ArrayList searchVariableList = new ArrayList();
        AtomicInteger counter = new AtomicInteger(0);
        searchVariable.keySet().forEach(key -> searchVariableList.add(counter.getAndIncrement(), (AdvanceVariableForm)searchVariable.get(key)));
        SearchFormModelDto searchFormModelDto = this.searchFormBuilder.buildSearchFormModel(searchVariableList.toArray(new AdvanceVariableForm[0]));
        searchFormModelDto.setExtrasSearchModel(this.searchFormBuilder.buildExtrasSearchModelDto(extraSearchVariable));
        SearchViewDto searchViewDto = new SearchViewDto();
        searchViewDto.setSearchFormModelDto(searchFormModelDto);
        searchViewDto.setViewType(viewAccessLevel);
        searchViewDto.setAcceptFromAllPages(acceptFromAllPages);
        searchViewDto.setAcceptManyTasks(acceptManyTasks);
        searchViewDto.setShowSearchResultOnResult(showSearchResultOnResult);
        searchViewDto.setShowVariables(showVariables);
        searchViewDto.setShowFormOnResult(showFormOnResult);
        searchViewDto.setShowOnlyLatestActivityDetails(showOnlyLatestActivityDetails);
        searchViewDto.setEnableDocumentZipExport(enableDocumentZipExport);
        return searchViewDto;
    }

    private void sortProcessesByName(List<ProcesType> procTypes) {
        procTypes.sort((proc1, proc2) -> {
            if (proc1 != null && proc2 != null) {
                String procName1 = proc1.getSProcTypeName();
                String procName2 = proc2.getSProcTypeName();
                return procName1.compareToIgnoreCase(procName2);
            }
            if (proc1 != null) {
                return 1;
            }
            return proc2 != null ? -1 : 0;
        });
    }

    private Map<String, Object> buildAuditParams(Long viewId, SaveViewDto saveViewDto) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        String viewIdParam = viewId != null ? viewId.toString() : "";
        params.put("viewId", viewIdParam);
        params.put("searchViewName", saveViewDto.getName());
        params.put("searchViewDescr", saveViewDto.getDescription());
        params.put("showFormOnResult", saveViewDto.isShowFormOnResult());
        params.put("showSearchResultOnResult", saveViewDto.isShowSearchResultOnResult());
        params.put("acceptManyTasks", saveViewDto.isAcceptManyTasks());
        params.put("acceptFromAllPages", saveViewDto.isAcceptFromAllPages());
        params.put("showOnlyLatestActivityDetails", saveViewDto.isShowOnlyLatestActivityDetails());
        params.put("enableDocumentZipExport", saveViewDto.isEnableDocumentZipExport());
        return params;
    }

    @ExceptionHandler(value={ServiceException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public RestResult handleBadRequestException(ServiceException e) {
        log.info(e.getMessage());
        return new RestResult(false, e.getMessage());
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ResponseBody
    public RestResult handleException(Exception e) {
        log.info(e.getMessage());
        return new RestResult(false, e.getMessage());
    }

    @ConstructorProperties(value={"licenseService", "systemPropertiesBean", "searchFormBuilder", "pluginFramework", "experimental", "userService", "searchViewService"})
    @Autowired
    public SearchController(LicenseService licenseService, SystemPropertiesBean systemPropertiesBean, SearchFormModelBuilder searchFormBuilder, PluginFramework pluginFramework, Experimental experimental, UserService userService, SearchViewService searchViewService) {
        this.licenseService = licenseService;
        this.systemPropertiesBean = systemPropertiesBean;
        this.searchFormBuilder = searchFormBuilder;
        this.pluginFramework = pluginFramework;
        this.experimental = experimental;
        this.userService = userService;
        this.searchViewService = searchViewService;
    }

    private static class MalformedSearchFormValue
    extends RuntimeException {
        private MalformedSearchFormValue() {
        }
    }

    private static class MissingSearchFormValue
    extends RuntimeException {
        private MissingSearchFormValue() {
        }
    }
}

