/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.workflow.process;

import com.suncode.pwfl.process.variables.ProcessVariableService;
import com.suncode.pwfl.web.search.model.SearchFormExtendedVariablesDto;
import com.suncode.pwfl.web.search.model.SearchFormTableDto;
import com.suncode.pwfl.web.search.model.SearchFormVariableDefinitionDto;
import com.suncode.pwfl.workflow.process.ProcessService;
import com.suncode.pwfl.xpdl.table.Table;
import com.suncode.pwfl.xpdl.table.XpdlTableService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"processes/variables"})
public class VariableController {
    @Autowired
    private ProcessVariableService processVariableService;
    @Autowired
    private ProcessService processService;
    @Autowired
    private XpdlTableService xpdlTableService;

    @RequestMapping(value={"{processDefId}"})
    @ResponseBody
    public List<SearchFormVariableDefinitionDto> getVariablesForProcessDefinition(@PathVariable String processDefId) {
        return this.processVariableService.getVariablesForProcessDefinition(processDefId);
    }

    @RequestMapping(value={"extended/{processDefId}"})
    @ResponseBody
    public SearchFormExtendedVariablesDto getExtendedVariablesForProcessDefinition(@PathVariable String processDefId) throws IOException {
        if (StringUtils.isBlank((String)processDefId)) {
            return new SearchFormExtendedVariablesDto(new ArrayList(), new ArrayList(), new ArrayList());
        }
        List variablesForProcessDefinition = this.processVariableService.getVariablesForProcessDefinition(processDefId);
        List tables = this.xpdlTableService.getHeuristicGlobalTables(processDefId, LocaleContextHolder.getLocale()).stream().map(table -> new SearchFormTableDto(table.getId(), this.getTableName((Table)table), table.getColumns().stream().map(column -> variablesForProcessDefinition.stream().filter(variable -> variable.getId().equals(column.getVarId())).findFirst().orElse(null)).filter(Objects::nonNull).sorted(Comparator.comparing(SearchFormVariableDefinitionDto::getName)).collect(Collectors.toList()))).collect(Collectors.toList());
        List<String> tableVariablesIds = tables.stream().map(SearchFormTableDto::columns).flatMap(Collection::stream).map(SearchFormVariableDefinitionDto::getId).toList();
        List<SearchFormVariableDefinitionDto> nonGlobalTableVariables = variablesForProcessDefinition.stream().filter(variable -> !tableVariablesIds.contains(variable.getId())).filter(SearchFormVariableDefinitionDto::getIsArray).sorted(Comparator.comparing(SearchFormVariableDefinitionDto::getName)).toList();
        List<String> nonGlobalTableVariablesIds = nonGlobalTableVariables.stream().map(SearchFormVariableDefinitionDto::getId).toList();
        return new SearchFormExtendedVariablesDto(variablesForProcessDefinition.stream().filter(variable -> !tableVariablesIds.contains(variable.getId())).filter(variable -> !nonGlobalTableVariablesIds.contains(variable.getId())).sorted(Comparator.comparing(SearchFormVariableDefinitionDto::getName)).collect(Collectors.toList()), tables.stream().sorted(Comparator.comparing(SearchFormTableDto::tableName)).toList(), nonGlobalTableVariables);
    }

    @ResponseBody
    @RequestMapping(value={"{processId}/values"}, method={RequestMethod.POST})
    public Map<String, Object> getAdvanceSearchResultValues(@PathVariable String processId, @RequestBody List<String> columnIds) throws IOException {
        Map processContext = this.processService.getProcessContext(processId);
        HashMap<String, Object> newDocumentIndexes = new HashMap<String, Object>();
        for (String name : columnIds) {
            Object indexValue = processContext.get(name);
            newDocumentIndexes.put(name, indexValue);
        }
        return newDocumentIndexes;
    }

    private String getTableName(Table table) {
        if (StringUtils.isNotBlank((String)table.getTranslatedName())) {
            return table.getTranslatedName();
        }
        if (StringUtils.isNotBlank((String)table.getName())) {
            return table.getName();
        }
        return table.getId();
    }
}

