/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.workflow.process;

import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.web.dto.activity.CommentDto;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import com.suncode.pwfl.web.util.SessionUtils;
import com.suncode.pwfl.workflow.activity.Activity;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.activity.ActivityState;
import com.suncode.pwfl.workflow.process.Comment;
import com.suncode.pwfl.workflow.process.CommentService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/comments"})
@Api(value="/api/comments", tags={"comments"})
public class CommentController {
    private final CommentService commentService;
    private final ActivityService activityService;
    private final AuthorizationHelper authorizationHelper;
    private final MessageHelperBean messageHelper;

    @ApiOperation(value="Add comment", notes="The response contains a comment definition object (with the userId, timestamp, and id fields completed)\n- **processId** - id of the process\n- **activityId** - id of the activity\n- **comment** - comment content\nEach comment in the system has information about the user who wrote it, and the date it was added. When saving a comment using the above servlet, the user is retrieved from the session, and the date is set to the current one.", response=CommentDto.class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad input parameter")})
    @RequestMapping(method={RequestMethod.POST})
    @ResponseBody
    public CommentDto add(@RequestBody Comment comment) {
        this.authorizationHelper.assertProcessAccess(comment.getProcessId(), () -> {});
        String userId = SessionUtils.getLoggedUserName();
        comment.setUserId(userId);
        comment.setTimestamp(Long.valueOf(new Date().getTime()));
        if (this.isActivityClosed(comment.getProcessId(), comment.getActivityId())) {
            throw new RuntimeException("Cannot add comment. Activity is closed.");
        }
        Long commentId = this.commentService.createComment(comment);
        return commentId != null ? new CommentDto(comment) : null;
    }

    private boolean isActivityClosed(String processId, String activityId) {
        Activity activity = this.activityService.getActivity(processId, activityId, new String[0]);
        return !ActivityState.isOpen((ActivityState)activity.getState());
    }

    @ApiOperation(value="Downloading activity comments", notes="The answer includes a comment definition object.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad input parameter")})
    @Transactional
    @RequestMapping(value={"query"}, method={RequestMethod.GET})
    @ResponseBody
    public List<CommentDto> query(@ApiParam(value="Id of the process", required=false) @RequestParam(required=false) String processId, @ApiParam(value="Id of the activity", required=true) @RequestParam(required=false) String activityId) {
        if (StringUtils.isNotBlank((CharSequence)processId)) {
            this.authorizationHelper.assertProcessAccess(processId, () -> {});
        }
        if (StringUtils.isBlank((CharSequence)processId) && StringUtils.isBlank((CharSequence)activityId)) {
            throw new IllegalArgumentException(this.messageHelper.getMessage("Nie_podano_wymaganych_parametrow"));
        }
        if (StringUtils.isNotBlank((CharSequence)activityId)) {
            List comments = this.commentService.getCommentsForActivity(activityId);
            return this.commentsToDto(comments);
        }
        List comments = this.commentService.getCommentsForProcess(processId);
        return this.commentsToDto(comments);
    }

    private List<CommentDto> commentsToDto(List<Comment> comments) {
        return comments.stream().map(CommentDto::new).collect(Collectors.toList());
    }

    @ApiOperation(value="Download comment by id", notes="The answer includes a comment definition object", response=CommentDto.class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad input parameter")})
    @RequestMapping(value={"/{commentId}"}, method={RequestMethod.GET})
    @ResponseBody
    @Transactional
    public CommentDto get(@ApiParam(value="Id of the comment (parameter passed in servlet path)", required=true) @PathVariable Long commentId) {
        Comment comment = (Comment)this.commentService.get((Serializable)commentId);
        if (comment == null) {
            return null;
        }
        this.authorizationHelper.assertProcessAccess(comment.getProcessId(), () -> {});
        return new CommentDto(comment);
    }

    @ApiOperation(value="Delete comment", notes="Delete the comment with the indicated id")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad input parameter")})
    @RequestMapping(value={"/{commentId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void delete(@ApiParam(value="Id of the comment", required=true) @PathVariable Long commentId) {
        Comment comment = (Comment)this.commentService.get((Serializable)commentId);
        this.authorizationHelper.assertProcessAccess(comment.getProcessId(), () -> {});
        this.commentService.deleteById(commentId);
    }

    @ConstructorProperties(value={"commentService", "activityService", "authorizationHelper", "messageHelper"})
    @Autowired
    public CommentController(CommentService commentService, ActivityService activityService, AuthorizationHelper authorizationHelper, MessageHelperBean messageHelper) {
        this.commentService = commentService;
        this.activityService = activityService;
        this.authorizationHelper = authorizationHelper;
        this.messageHelper = messageHelper;
    }
}

