/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.workflow.activity.finder.view.controller;

import com.plusmpm.util.AdvanceSearchResult;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.search.AdvanceProcessSearchDBHelper;
import com.suncode.pwfl.search.AdvanceProcessSearchService;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.PaginationException;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.search.ViewVariablesToSearchModelMapper;
import com.suncode.pwfl.util.exception.ServiceException;
import com.suncode.pwfl.view.DetailedViewFetchType;
import com.suncode.pwfl.view.ViewService;
import com.suncode.pwfl.view.dto.ViewWithRightLevelDto;
import com.suncode.pwfl.view.exception.NoPermissionToViewException;
import com.suncode.pwfl.view.exception.ViewDoesNotExistException;
import com.suncode.pwfl.web.controller.api.workflow.activity.finder.view.results.converter.ActivityViewFinderResultConverter;
import com.suncode.pwfl.web.controller.api.workflow.activity.finder.view.results.dto.ActivityViewFinderResults;
import com.suncode.pwfl.web.controller.api.workflow.activity.finder.view.search.dto.ActivityViewSearchCriteria;
import com.suncode.pwfl.web.controller.api.workflow.activity.finder.view.search.mapper.ActivityViewSearchModelMapper;
import com.suncode.pwfl.web.search.model.SearchFormModelDto;
import com.suncode.pwfl.web.support.ajax.ResponseMessageLevel;
import com.suncode.pwfl.web.support.ajax.RestResponse;
import com.suncode.pwfl.web.support.ajax.RestResult;
import com.suncode.pwfl.web.util.SessionUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"/activities/find"})
@Api(value="Activity view based finder", tags={"activities", "views"})
public class ActivityViewFinderController {
    private static final Logger log = LoggerFactory.getLogger(ActivityViewFinderController.class);
    @Autowired
    private AdvanceProcessSearchService advanceProcessSearchService;
    @Autowired
    private ActivityViewFinderResultConverter activityViewFinderResultConverter;
    @Autowired
    private ViewService viewService;
    @Autowired
    private MessageHelperBean messageHelper;
    @Autowired
    private AdvanceProcessSearchDBHelper advanceProcessSearchDBHelper;
    @Autowired
    private ViewVariablesToSearchModelMapper viewVariablesToSearchModelMapper;
    @Autowired
    private ActivityViewSearchModelMapper activityViewSearchModelMapper;

    @ApiOperation(value="Get activity id, process id, process data from view.", notes="Retrieves a count and results list from view. Enable to filter results with filter lists")
    @ApiImplicitParam(name="activityViewSearchCriteria", value="Container for DTO objects with filtering criteria", dataType="ActivityViewSearchCriteria", paramType="body")
    @ApiResponses(value={@ApiResponse(code=200, message="Ok"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=403, message="Forbidden")})
    @RequestMapping(value={"byView/{viewId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ActivityViewFinderResults getActivitiesByView(@ApiParam(value="ID of the view to search", required=true) @PathVariable Long viewId, @ApiParam(value="Filtering criteria") @RequestBody(required=false) ActivityViewSearchCriteria activityViewSearchCriteria, @ApiParam(value="Starting index for pagination", required=true) @RequestParam(required=false) Integer start, @ApiParam(value="Maximum number of results to return", required=true) @RequestParam(required=false) Integer limit, @ApiParam(value="Sorting property. Only variables/headers defined in view configuration can be used. For headers use names specified in requestBody section. For incorrect sorting property API returns 0 results without any error message. When not present processId is default value.", required=false) @RequestParam(required=false, defaultValue="processId") String sortBy, @ApiParam(value="Sorting direction. Possible values are ASC or DESC. When not present ASC is default value.", required=false) @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection) throws ViewDoesNotExistException, NoPermissionToViewException {
        if (start == null || limit == null) {
            throw new PaginationException(this.messageHelper.getMessage("Brak_wymaganych_paremetrow_paginacji"));
        }
        String userName = SessionUtils.getLoggedUserName();
        List viewsForUser = this.viewService.getAvailableViews(DetailedViewFetchType.ALL);
        Optional.ofNullable(this.viewService.getView(viewId)).orElseThrow(() -> new ViewDoesNotExistException(this.messageHelper.getMessage("Widok_nie_istnieje", new Object[]{viewId})));
        Optional<ViewWithRightLevelDto> viewAvailableForUser = viewsForUser.stream().filter(viewDto -> viewDto.getId().equals(viewId)).findFirst();
        viewAvailableForUser.orElseThrow(() -> new NoPermissionToViewException(this.messageHelper.getMessage("Brak_uprawnien_do_widoku")));
        try {
            List searchVariablesForView = this.advanceProcessSearchDBHelper.getSearchVariablesForView(viewId);
            SearchFormModelDto searchFormModel = this.viewVariablesToSearchModelMapper.map(searchVariablesForView);
            if (activityViewSearchCriteria != null) {
                this.activityViewSearchModelMapper.applySearchFilters(searchFormModel, activityViewSearchCriteria);
            }
            CountedResult extendedSearchResults = this.advanceProcessSearchService.search(searchFormModel, userName, start, limit, sortBy, sortDirection, false);
            return this.activityViewFinderResultConverter.convert((CountedResult<AdvanceSearchResult>)extendedSearchResults);
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @ExceptionHandler(value={ViewDoesNotExistException.class, PaginationException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public RestResult handleBadRequest(Throwable t) {
        log.info(t.getMessage());
        return new RestResult(false, t.getMessage());
    }

    @ExceptionHandler(value={NoPermissionToViewException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ResponseBody
    public RestResult handleForbiddenRequest(Throwable t) {
        log.info(t.getMessage());
        return new RestResult(false, t.getMessage());
    }

    @ExceptionHandler(value={ServiceException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ResponseBody
    public RestResponse<?> handleServiceException(ServiceException e) {
        log.info(e.getMessage());
        return new RestResponse(e.getMessage(), ResponseMessageLevel.ERROR);
    }
}

