/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.system;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.plusmpm.security.TextCipher;
import com.suncode.pwfl.administration.configuration.ParameterType;
import com.suncode.pwfl.administration.configuration.SystemParameter;
import com.suncode.pwfl.administration.configuration.SystemParameterFinder;
import com.suncode.pwfl.administration.configuration.SystemParameterService;
import com.suncode.pwfl.web.dto.administration.CategoryExportDto;
import com.suncode.pwfl.web.dto.administration.ImportResultDto;
import com.suncode.pwfl.web.dto.administration.SystemParameterExportDto;
import com.suncode.pwfl.web.util.JsonMessage;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/system/parameters"})
public class SystemParameterExportController {
    private static final Logger log = LoggerFactory.getLogger(SystemParameterExportController.class);
    private ObjectMapper mapper = new ObjectMapper();
    @Autowired
    private SystemParameterService paramService;
    @Autowired
    private SystemParameterFinder paramFinder;

    @RequestMapping(value={"export"})
    public HttpEntity<byte[]> exportParameters(HttpSession session) throws JsonProcessingException {
        String username = (String)session.getAttribute("username");
        boolean exportHiddenParameters = username.equals("admin");
        List categories = this.paramFinder.getAllCategories(new String[]{"systemParameters"});
        List categoriesDto = categories.stream().peek(category -> category.getSystemParameters().removeIf(parameter -> !exportHiddenParameters && parameter.isHidden())).map(CategoryExportDto::create).peek(category -> Collections.sort(category.getParameters())).sorted().collect(Collectors.toList());
        String json = this.mapper.writerWithDefaultPrettyPrinter().writeValueAsString(categoriesDto);
        byte[] byteResponse = json.getBytes(StandardCharsets.UTF_8);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
        headers.set("Content-Disposition", "attachment; filename=parameters.json");
        return new HttpEntity((Object)byteResponse, (MultiValueMap)headers);
    }

    @ResponseBody
    @RequestMapping(value={"import"}, method={RequestMethod.POST})
    public JsonMessage importParameters(@RequestParam(value="file") MultipartFile file, HttpSession session) throws IOException {
        String username = (String)session.getAttribute("username");
        try {
            List<SystemParameter> parameters = this.getEntities(this.readCategories(file));
            ImportResultDto result = this.executeImport(username, parameters);
            JsonMessage response = new JsonMessage();
            response.setData((Object)result);
            return response;
        }
        catch (JsonMappingException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            return new JsonMessage(false, "File has incorrect format");
        }
    }

    private List<SystemParameter> getEntities(List<CategoryExportDto> categories) {
        LinkedList<SystemParameter> parameters = new LinkedList<SystemParameter>();
        categories.forEach(category -> category.getParameters().forEach(parameter -> parameters.add(parameter.convert((CategoryExportDto)category))));
        return parameters;
    }

    private List<CategoryExportDto> readCategories(MultipartFile file) throws IOException {
        String stringFile = new String(file.getBytes(), StandardCharsets.UTF_8);
        return (List)this.mapper.readValue(stringFile, (TypeReference)new TypeReference<List<CategoryExportDto>>(){});
    }

    private ImportResultDto executeImport(String username, List<SystemParameter> parameters) {
        ImportResultDto result = new ImportResultDto();
        boolean importHiddenParameters = username.equals("admin");
        parameters.forEach(newParameter -> {
            SystemParameterExportDto systemParamDto = SystemParameterExportDto.convert(newParameter);
            SystemParameter existingParameter = this.paramService.getParameter(newParameter.getKey());
            if (existingParameter == null) {
                try {
                    this.paramService.create(newParameter);
                    result.getAdded().add(systemParamDto);
                }
                catch (Exception ex) {
                    log.error(ex.getMessage(), (Throwable)ex);
                    result.getNotAdded().add(systemParamDto);
                }
            } else if (!importHiddenParameters && existingParameter.isHidden()) {
                result.getNotOverwritten().add(systemParamDto);
            } else {
                try {
                    boolean comboUpdated = false;
                    String value = systemParamDto.getValue();
                    if (existingParameter.getParameterType() == ParameterType.PASSWORD && StringUtils.isNotEmpty((CharSequence)value)) {
                        value = TextCipher.decrypt((String)value);
                    }
                    boolean valueUpdated = this.paramService.updateValue(value, existingParameter);
                    if (existingParameter.getParameterType() == ParameterType.COMBOBOX) {
                        List comboValues = systemParamDto.getComboValues().stream().map(comboValueDto -> comboValueDto.create(existingParameter)).collect(Collectors.toList());
                        comboUpdated = this.paramService.updateComboValues(existingParameter, comboValues);
                    }
                    if (valueUpdated || comboUpdated) {
                        result.getOverwritten().add(systemParamDto);
                    }
                }
                catch (Exception ex) {
                    log.error(ex.getMessage(), (Throwable)ex);
                    result.getNotOverwritten().add(systemParamDto);
                }
            }
        });
        return result;
    }
}

