/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.swagger;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.suncode.pwfl.util.Sneaky;
import java.io.IOException;
import java.io.InputStream;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"swagger"})
public class SwaggerController {
    private final Resource resource;

    public SwaggerController(@Value(value="classpath:swagger/swagger.json") Resource resource) {
        this.resource = resource;
    }

    @GetMapping(value={"plusworkflow"})
    JsonNode getSwaggerJson() throws IOException {
        try (InputStream inputStream = this.resource.getInputStream();){
            JsonNode jsonNode = (JsonNode)Sneaky.throwing(() -> new ObjectMapper().readTree(inputStream));
            return jsonNode;
        }
    }
}

