/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.scheduledtasks;

import com.plusmpm.database.scheduledTasks.PeriodUnit;
import com.plusmpm.database.scheduledTasks.ScheduledTasksParametersTable;
import com.plusmpm.database.scheduledTasks.ScheduledTasksTable;
import com.plusmpm.util.scheduledTasks.ScheduledTasksManager;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTask;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskMethodDto;
import com.suncode.pwfl.administration.scheduledtask.domain.ScheduledTaskComponentEntity;
import com.suncode.pwfl.administration.scheduledtask.email.ScheduledTaskEmailNotification;
import com.suncode.pwfl.administration.scheduledtask.exception.ScheduledTaskParameterNotCompatibleException;
import com.suncode.pwfl.administration.scheduledtask.info.exceptions.ScheduledTaskParameterNotFoundException;
import com.suncode.pwfl.administration.scheduledtask.parameter.ScheduledTaskParameterFinder;
import com.suncode.pwfl.administration.scheduledtask.parameter.ScheduledTaskParameterSelector;
import com.suncode.pwfl.administration.scheduledtask.service.ScheduledTaskComponentService;
import com.suncode.pwfl.administration.scheduledtask.service.ScheduledTaskEntityMethodValidator;
import com.suncode.pwfl.administration.scheduledtask.service.ScheduledTaskHelper;
import com.suncode.pwfl.administration.scheduledtask.service.ScheduledTaskMethodFinder;
import com.suncode.pwfl.administration.scheduledtask.service.ScheduledTaskService;
import com.suncode.pwfl.customfile.CustomFile;
import com.suncode.pwfl.customfile.CustomFileService;
import com.suncode.pwfl.i18n.MessageHelper;
import com.suncode.pwfl.web.controller.api.scheduledtasks.dto.ScheduledTaskDto;
import com.suncode.pwfl.web.controller.api.scheduledtasks.dto.ScheduledTaskParameterDto;
import com.suncode.pwfl.web.controller.api.scheduledtasks.exception.ScheduledTaskInvalidHoursRangeException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ScheduledTaskDtoHelper {
    private static final Logger log = LoggerFactory.getLogger(ScheduledTaskDtoHelper.class);
    @Autowired
    private ScheduledTaskHelper scheduledTaskHelper;
    @Autowired
    private ScheduledTaskParameterFinder scheduledTaskParameterFinder;
    @Autowired
    private ScheduledTaskMethodFinder scheduledTaskMethodFinder;
    @Autowired
    private ScheduledTaskEntityMethodValidator scheduledTaskEntityMethodValidator;
    @Autowired
    private CustomFileService customFileService;
    @Autowired
    private ScheduledTaskComponentService scheduledTaskComponentService;
    @Autowired
    private ScheduledTaskService scheduledTaskService;

    public ScheduledTaskDto entityToDto(ScheduledTasksTable taskEntity) {
        Optional foundMethodDto;
        ScheduledTaskDto taskDto = this.baseTaskToDto(taskEntity);
        taskDto.setIsComponent(false);
        if (taskDto.getProcessing().booleanValue()) {
            taskDto.setProgress(ScheduledTasksManager.getInstance().getExecutor().getTaskProgress((Object)taskEntity.getId()));
        }
        if (!(foundMethodDto = this.scheduledTaskMethodFinder.findScheduledTaskMethod(taskEntity)).isPresent()) {
            log.warn("Could not find method for scheduled task entity with id {}", (Object)taskEntity.getId());
            taskDto.setAvailable(false);
            return taskDto;
        }
        ScheduledTaskMethodDto methodDto = (ScheduledTaskMethodDto)foundMethodDto.get();
        try {
            this.scheduledTaskEntityMethodValidator.validateEntityParametersAgainstMethod(taskEntity, methodDto, false);
        }
        catch (ScheduledTaskParameterNotCompatibleException | ScheduledTaskParameterNotFoundException e) {
            log.warn(e.getMessage());
            taskDto.setAvailable(false);
            return taskDto;
        }
        catch (Exception e) {
            log.error("Failed to validate entity with id {} against the method", (Object)taskEntity.getId(), (Object)e);
            taskDto.setAvailable(false);
            return taskDto;
        }
        if (this.scheduledTaskHelper.isComponent(taskEntity)) {
            ScheduledTaskComponentEntity componentTaskEntity;
            taskDto.setIsComponent(true);
            ScheduledTask componentTask = this.scheduledTaskHelper.getComponent(taskEntity.getClass_name());
            if (componentTask != null) {
                taskDto.setComponentTaskId(componentTask.getId());
            }
            if ((componentTaskEntity = this.scheduledTaskComponentService.findByScheduledTaskId(taskEntity.getId())) != null) {
                String pluginId = componentTaskEntity.getPluginId();
                taskDto.setPluginId(pluginId);
            }
        }
        taskDto.setAnnotationName(methodDto.getAnnotationName());
        taskDto.setAnnotationDesc(methodDto.getAnnotationDesc());
        taskDto.setCategory(methodDto.getCategory());
        taskDto.setCancelable(methodDto.getCancelable());
        taskDto.setDeprecated(this.scheduledTaskService.isScheduledTaskDeprecated(taskEntity));
        try {
            this.fillParameterDtos(taskDto, taskEntity, methodDto);
            this.fillTaskMetadata(taskDto, taskEntity, methodDto);
            return taskDto;
        }
        catch (ScheduledTaskParameterNotCompatibleException | ScheduledTaskParameterNotFoundException e) {
            log.warn(e.getMessage());
            taskDto.setAvailable(false);
            return taskDto;
        }
        catch (Exception e) {
            log.error("Failed to map method {} to dto for scheduled task entity with id {}", new Object[]{methodDto, taskEntity.getId(), e});
            taskDto.setAvailable(false);
            return taskDto;
        }
    }

    private ScheduledTaskDto baseTaskToDto(ScheduledTasksTable taskEntity) {
        ScheduledTaskDto dto = new ScheduledTaskDto();
        dto.setId(taskEntity.getId());
        dto.setName(taskEntity.getName());
        dto.setDesc(taskEntity.getDescription());
        dto.setStaticId(taskEntity.getStaticId());
        dto.setMethodName(taskEntity.getMethod_name());
        dto.setClassName(taskEntity.getClass_name());
        dto.setPlanMode(taskEntity.getPlanMode());
        Long taskPeriod = taskEntity.getPeriodValue();
        PeriodUnit periodUnit = taskEntity.getPeriodUnit();
        if (taskPeriod != null) {
            dto.setPeriod(taskPeriod);
            dto.setPeriodUnit(periodUnit);
        } else {
            dto.setPeriodUnit(PeriodUnit.MINUTES);
        }
        dto.setActive(taskEntity.getIs_active());
        dto.setProcessing(taskEntity.getIs_processing());
        dto.setSaveHistory(taskEntity.getSaveHistory());
        dto.setUserNameNotifications(taskEntity.getUserNotifications().stream().map(notification -> notification.getUser().getUserName()).collect(Collectors.toList()));
        dto.setEmailNotifications(taskEntity.getEmailNotifications().stream().map(ScheduledTaskEmailNotification::getEmail).collect(Collectors.toList()));
        dto.setAvailable(true);
        SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        dto.setFirstRun(dateFormatter.format(taskEntity.getFirst_run()));
        dto.setNextRun(dateFormatter.format(taskEntity.getNext_run() == null ? taskEntity.getFirst_run() : taskEntity.getNext_run()));
        Date lastRun = taskEntity.getLast_run();
        dto.setLastRun(lastRun != null ? dateFormatter.format(lastRun) : null);
        dto.setStartingHour(taskEntity.getStartingHour());
        dto.setEndingHour(taskEntity.getEndingHour());
        dto.setMaxWorkingMinutes(taskEntity.getMaxWorkingMinutes());
        dto.setDaysFromMonthEnd(taskEntity.getDaysFromMonthEnd());
        dto.setTargetHour(taskEntity.getTargetHour());
        dto.setTargetMinute(taskEntity.getTargetMinute());
        return dto;
    }

    private void fillParameterDtos(ScheduledTaskDto taskDto, ScheduledTasksTable taskEntity, ScheduledTaskMethodDto methodDto) {
        ArrayList<ScheduledTaskParameterDto> dtoParameters = new ArrayList<ScheduledTaskParameterDto>();
        this.forEachParameterRightJoined(taskEntity, methodDto, (nullableParameterEntity, methodParameterDto) -> {
            ScheduledTaskParameterDto parameterDto = this.parameterToDto((ScheduledTasksParametersTable)nullableParameterEntity, methodDto, (ScheduledTaskMethodDto.Parameter)methodParameterDto);
            dtoParameters.add(parameterDto);
        });
        taskDto.setParameters(dtoParameters);
    }

    private void forEachParameterRightJoined(ScheduledTasksTable taskEntity, ScheduledTaskMethodDto methodDto, BiConsumer<ScheduledTasksParametersTable, ScheduledTaskMethodDto.Parameter> func) {
        for (ScheduledTaskMethodDto.Parameter parameterDto : methodDto.getParameters()) {
            ScheduledTasksParametersTable nullableParameterEntity = this.scheduledTaskParameterFinder.findInEntity(taskEntity).by(parameterDto).orElse(null);
            func.accept(nullableParameterEntity, parameterDto);
        }
    }

    private ScheduledTaskParameterDto parameterToDto(ScheduledTasksParametersTable nullableParameterEntity, ScheduledTaskMethodDto methodDto, ScheduledTaskMethodDto.Parameter methodParameterDto) {
        if (nullableParameterEntity != null) {
            return this.existingParameterToDto(nullableParameterEntity, methodDto, methodParameterDto);
        }
        return this.newParameterToDto(methodParameterDto);
    }

    private ScheduledTaskParameterDto existingParameterToDto(ScheduledTasksParametersTable parameterEntity, ScheduledTaskMethodDto methodDto, ScheduledTaskMethodDto.Parameter methodParameterDto) {
        if (!StringUtils.equals((CharSequence)parameterEntity.getParameter_type(), (CharSequence)methodParameterDto.getType())) {
            throw new ScheduledTaskParameterNotCompatibleException(String.format("Parameter of method %s at position %d of type %s is not compatible with saved parameter of type %s", methodDto, methodParameterDto.getPosition(), methodParameterDto, parameterEntity.getParameter_type()));
        }
        ScheduledTaskParameterDto dto = new ScheduledTaskParameterDto();
        dto.setId(parameterEntity.getId());
        dto.setType(parameterEntity.getParameter_type());
        dto.setPosition(parameterEntity.getParameter_position());
        dto.setFieldType(methodParameterDto.getFieldType());
        dto.setIsOptional(methodParameterDto.getIsOptional());
        dto.setDefaultValue(methodParameterDto.getDefaultValue());
        dto.setAnnotationName(methodParameterDto.getAnnotationName());
        dto.setAnnotationDesc(methodParameterDto.getAnnotationDesc());
        String componentParameterId = this.scheduledTaskHelper.findComponentParameterId(parameterEntity).orElse(null);
        dto.setComponentParameterId(componentParameterId);
        boolean isArray = dto.getType().startsWith("[");
        if (isArray) {
            List values = this.scheduledTaskHelper.getParameterValues(parameterEntity, componentParameterId != null);
            dto.setValue(values);
        } else {
            String value = this.scheduledTaskHelper.getParameterValue(parameterEntity, componentParameterId != null);
            dto.setValue(value);
        }
        return dto;
    }

    private ScheduledTaskParameterDto newParameterToDto(ScheduledTaskMethodDto.Parameter methodParameterDto) {
        ScheduledTaskParameterDto dto = new ScheduledTaskParameterDto();
        dto.setComponentParameterId(methodParameterDto.getComponentParameterId());
        dto.setType(methodParameterDto.getType());
        dto.setPosition(methodParameterDto.getPosition());
        dto.setFieldType(methodParameterDto.getFieldType());
        dto.setIsOptional(methodParameterDto.getIsOptional());
        dto.setDefaultValue(methodParameterDto.getDefaultValue());
        dto.setAnnotationName(methodParameterDto.getAnnotationName());
        dto.setAnnotationDesc(methodParameterDto.getAnnotationDesc());
        return dto;
    }

    private void fillTaskMetadata(ScheduledTaskDto taskDto, ScheduledTasksTable taskEntity, ScheduledTaskMethodDto methodDto) {
        this.tryForEachEntityParameter(taskEntity, taskDto, (paramEntity, paramDto) -> {
            String parameterType = paramEntity.getParameter_type();
            if (this.scheduledTaskHelper.isFileType(parameterType)) {
                String rawValue = this.scheduledTaskHelper.getParameterValue(paramEntity);
                Long fileId = Long.valueOf(rawValue);
                CustomFile fileEntity = this.customFileService.getFile(fileId);
                ScheduledTaskParameterDto.ValueMetadata valueMetadata = new ScheduledTaskParameterDto.ValueMetadata();
                valueMetadata.setFileName(fileEntity.getFileName());
                paramDto.setValueMetadata(Collections.singletonList(valueMetadata));
            } else if (this.scheduledTaskHelper.isFileTypeArray(parameterType)) {
                List rawValues = this.scheduledTaskHelper.getParameterValues(paramEntity);
                LinkedList<ScheduledTaskParameterDto.ValueMetadata> valueMetadataList = new LinkedList<ScheduledTaskParameterDto.ValueMetadata>();
                for (String value : rawValues) {
                    Long fileId = Long.valueOf(value);
                    CustomFile fileEntity = this.customFileService.getFile(fileId);
                    ScheduledTaskParameterDto.ValueMetadata valueMetadata = new ScheduledTaskParameterDto.ValueMetadata();
                    valueMetadata.setFileName(fileEntity.getFileName());
                    valueMetadataList.add(valueMetadata);
                }
                paramDto.setValueMetadata(valueMetadataList);
            }
        });
    }

    private void tryForEachEntityParameter(ScheduledTasksTable taskEntity, ScheduledTaskDto taskDto, BiConsumer<ScheduledTasksParametersTable, ScheduledTaskParameterDto> func) {
        for (ScheduledTasksParametersTable parameterEntity : taskEntity.getScheduled_tasks_parameters()) {
            ScheduledTaskParameterDto parameterDto = (ScheduledTaskParameterDto)this.scheduledTaskParameterFinder.findIn(taskDto.getParameters(), this::toSelector).by(parameterEntity).orElseThrow(() -> new ScheduledTaskParameterNotFoundException(String.format("Parameter of task method %s at position %d of type %s could not be found", taskDto, parameterEntity.getParameter_position(), parameterEntity.getParameter_type())));
            func.accept(parameterEntity, parameterDto);
        }
    }

    private ScheduledTaskParameterSelector toSelector(ScheduledTaskParameterDto parameterDto) {
        return new ScheduledTaskParameterSelector(parameterDto.getComponentParameterId(), parameterDto.getPosition());
    }

    public static void validateWorkingHours(Integer startingHour, Integer endingHour, Long period, PeriodUnit periodUnit) {
        long periodMilliseconds;
        if (startingHour == null && endingHour == null) {
            return;
        }
        if (period == null || periodUnit == null) {
            throw new ScheduledTaskInvalidHoursRangeException("Cannot set working hours for one-time scheduled tasks", MessageHelper.getMessage((String)"Cannot_set_working_hours_for_one_time_scheduled_tasks"));
        }
        if (startingHour == null || endingHour == null) {
            throw new ScheduledTaskInvalidHoursRangeException("Working hour range must either be fully bounded or not declared at all", MessageHelper.getMessage((String)"Working_hour_range_must_either_be_fully_bounded_or_not_declared_at_all"));
        }
        if (startingHour < 0 || startingHour > 23) {
            throw new ScheduledTaskInvalidHoursRangeException(String.format("Provided starting hour (%s) is not in range between 0-23", startingHour), MessageHelper.getMessage((String)"Provided_starting_hour_is_not_in_range", (Object[])new Object[]{startingHour}));
        }
        if (endingHour < 0 || endingHour > 23) {
            throw new ScheduledTaskInvalidHoursRangeException(String.format("Provided ending hour (%s) is not in range between 0-23", endingHour), MessageHelper.getMessage((String)"Provided_ending_hour_is_not_in_range", (Object[])new Object[]{endingHour}));
        }
        if (startingHour.equals(endingHour)) {
            throw new ScheduledTaskInvalidHoursRangeException(String.format("Starting hour (%s) cannot be the same as ending hour (%s)", startingHour, endingHour), MessageHelper.getMessage((String)"Starting_hour_cannot_be_the_same_as_ending_hour", (Object[])new Object[]{startingHour, endingHour}));
        }
        long workingHours = endingHour - startingHour;
        if (workingHours < 0L) {
            workingHours += 24L;
        }
        if (periodUnit.equals((Object)PeriodUnit.MINUTES)) {
            periodMilliseconds = TimeUnit.MINUTES.toMillis(period);
        } else if (periodUnit.equals((Object)PeriodUnit.HOURS)) {
            periodMilliseconds = TimeUnit.HOURS.toMillis(period);
        } else {
            throw new ScheduledTaskInvalidHoursRangeException(String.format("Working hours (%s-%s) must be larger than provided period", startingHour, endingHour), MessageHelper.getMessage((String)"Working_hours_must_be_larger_than_provided_period", (Object[])new Object[]{startingHour, endingHour}));
        }
        long workingMillis = TimeUnit.HOURS.toMillis(workingHours);
        if (workingMillis <= periodMilliseconds) {
            throw new ScheduledTaskInvalidHoursRangeException(String.format("Working hours (%s-%s) must be larger than provided period", startingHour, endingHour), MessageHelper.getMessage((String)"Working_hours_must_be_larger_than_provided_period", (Object[])new Object[]{startingHour, endingHour}));
        }
    }
}

