/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.calendar;

import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.builder.AuditParamsBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.calendar.ViewCalendar;
import com.suncode.pwfl.calendar.view.ViewCalendarShare;
import com.suncode.pwfl.calendar.view.api.ViewCalendarService;
import com.suncode.pwfl.calendar.view.api.ViewCalendarShareService;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.util.Paginator;
import com.suncode.pwfl.web.dto.calendar.ViewCalendarShareDto;
import com.suncode.pwfl.web.support.ajax.RestResult;
import com.suncode.pwfl.web.support.calendar.CalendarMapper;
import io.swagger.annotations.Api;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"calendar/view/{calendarId}/share"})
@Api(hidden=true)
public class ViewCalendarShareController {
    private final ViewCalendarShareService viewCalendarShareService;
    private final CalendarMapper calendarMapper;
    private final UserService userService;
    private final ViewCalendarService viewCalendarService;

    @GetMapping
    public CountedResult<ViewCalendarShareDto> getViewCalendarShares(@PathVariable long calendarId, @RequestParam(required=false) Integer start, @RequestParam(required=false) Integer limit) {
        List<ViewCalendarShareDto> viewCalendarShares = this.viewCalendarShareService.getViewCalendarSharesForCalendar(calendarId).stream().map(this.calendarMapper::toViewCalendarShareDto).toList();
        return Paginator.forAll(viewCalendarShares).viewPageByOffset(start, limit);
    }

    @PostMapping
    @ResponseStatus(value=HttpStatus.CREATED)
    public long addViewCalendarShare(@PathVariable long calendarId, @RequestBody ViewCalendarShareDto viewCalendarShareDto, HttpServletRequest request) {
        AuditParamsBuilder auditParamsBuilder = new AuditParamsBuilder();
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_ADD_VIEW_CALENDAR_SHARE);
        try {
            User user = this.userService.getUser(UserContext.current().getUser().getUserName(), new String[0]);
            ViewCalendarShare viewCalendarShare = this.calendarMapper.toViewCalendarShare(viewCalendarShareDto);
            viewCalendarShare.setCalendarId(calendarId);
            auditParamsBuilder.params(this.paramsFromViewCalendarShare(viewCalendarShare, user));
            long shareId = this.viewCalendarShareService.addViewCalendarShare(viewCalendarShare, user);
            request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildSuccess());
            return shareId;
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildFailure());
            throw e;
        }
    }

    @DeleteMapping(value={"{shareId}"})
    public RestResult deleteViewCalendarShare(@PathVariable long calendarId, @PathVariable long shareId, HttpServletRequest request) {
        AuditParamsBuilder auditParamsBuilder = new AuditParamsBuilder().param("id", (Object)shareId).param("calendarId", (Object)calendarId);
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_VIEW_CALENDAR_SHARE);
        try {
            User user = this.userService.getUser(UserContext.current().getUser().getUserName(), new String[0]);
            ViewCalendar viewCalendar = (ViewCalendar)this.viewCalendarService.getCalendar(Long.valueOf(calendarId), user);
            auditParamsBuilder.param("calendarName", (Object)viewCalendar.getName());
            this.viewCalendarShareService.deleteViewCalendarShare(Long.valueOf(shareId), user);
            request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildSuccess());
            return new RestResult(true);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildFailure());
            throw e;
        }
    }

    private Map<String, Object> paramsFromViewCalendarShare(ViewCalendarShare viewCalendarShare, User user) {
        ViewCalendar viewCalendar = (ViewCalendar)this.viewCalendarService.getCalendar(Long.valueOf(viewCalendarShare.getCalendarId()), user);
        AuditParamsBuilder auditParamsBuilder = new AuditParamsBuilder().param("calendarId", (Object)viewCalendarShare.getCalendarId()).param("calendarName", (Object)viewCalendar.getName()).param("userName", (Object)viewCalendarShare.getUserName()).param("groupName", (Object)viewCalendarShare.getGroupName());
        return auditParamsBuilder.build();
    }

    @ConstructorProperties(value={"viewCalendarShareService", "calendarMapper", "userService", "viewCalendarService"})
    @Autowired
    public ViewCalendarShareController(ViewCalendarShareService viewCalendarShareService, CalendarMapper calendarMapper, UserService userService, ViewCalendarService viewCalendarService) {
        this.viewCalendarShareService = viewCalendarShareService;
        this.calendarMapper = calendarMapper;
        this.userService = userService;
        this.viewCalendarService = viewCalendarService;
    }
}

