/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.administration.user.security;

import com.google.common.collect.ImmutableMap;
import com.suncode.pwfl.administration.configuration.DefinedSystemParameter;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.administration.user.security.exception.PasswordAlreadyAssignedException;
import com.suncode.pwfl.administration.user.security.exception.SelfAssignPasswordLinkExpiredException;
import com.suncode.pwfl.administration.user.security.service.PasswordAssignToken;
import com.suncode.pwfl.administration.user.security.service.PasswordRecoveryService;
import com.suncode.pwfl.administration.user.security.service.SelfPasswordAssignService;
import com.suncode.pwfl.administration.user.security.service.UserPasswordHistoryService;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.web.support.ajax.RestResult;
import com.suncode.pwfl.workflow.EmailSupportServiceImpl;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"password"})
public class UserPasswordController {
    private static final Logger log = LoggerFactory.getLogger(UserPasswordController.class);
    @Autowired
    private UserPasswordHistoryService passwordHistoryService;
    @Autowired
    private UserService userService;
    @Autowired
    private PasswordRecoveryService passwordRecoveryService;
    @Autowired
    private EmailSupportServiceImpl emailSupportService;
    @Autowired
    private SelfPasswordAssignService selfPasswordAssignService;

    @ResponseBody
    @RequestMapping(value={"available"}, method={RequestMethod.POST})
    public Map<String, Object> isPasswordAvailable(@RequestParam(value="username") String username, @RequestParam(value="password") String password) {
        User user = this.userService.getUser(username, new String[]{"groups"});
        Assert.notNull((Object)user, (String)"[Assertion failed] - this argument is required; it must not be null");
        List historyPasswords = this.passwordHistoryService.findPasswords(user, this.userService.hashPassword(password));
        return ImmutableMap.of((Object)"newPasswordAvailable", (Object)historyPasswords.isEmpty());
    }

    @ResponseBody
    @RequestMapping(value={"change"}, method={RequestMethod.POST})
    public ResponseEntity<Map<String, Object>> changePassword(HttpServletRequest request, @RequestParam(value="username") String username, @RequestParam(value="currentPassword") String currentPassword, @RequestParam(value="password") String newPassword) {
        AuditBuilder changePasswordAudit = AuditBuilder.getInstance().type(AuditTypes.AUDIT_CHANGE_PASSWORD).params((Map)ImmutableMap.of((Object)"username", (Object)username));
        User user = this.userService.getUser(username, new String[0]);
        Assert.notNull((Object)user, (String)"[Assertion failed] - this argument is required; it must not be null");
        String databaseEncryptedCurrentPassword = user.getPassword();
        String encryptedCurrentPassword = this.userService.hashPassword(currentPassword);
        if (databaseEncryptedCurrentPassword.equals(encryptedCurrentPassword)) {
            this.userService.changeUserPassword(username, newPassword);
            request.setAttribute("audit", (Object)changePasswordAudit.success(true).build());
            return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
        }
        request.setAttribute("audit", (Object)changePasswordAudit.success(false).build());
        return new ResponseEntity((Object)ImmutableMap.of((Object)"incorrectCurrentPassword", (Object)true), (HttpStatusCode)HttpStatus.NOT_ACCEPTABLE);
    }

    @ResponseBody
    @RequestMapping(value={"change/recovery"}, method={RequestMethod.POST})
    public ResponseEntity<Map<String, Object>> changePasswordByRecovery(HttpServletRequest request, HttpSession session, @RequestParam(value="uuid") String uuidText, @RequestParam(value="password") String newPassword) {
        AuditBuilder changePasswordAudit = AuditBuilder.getInstance().type(AuditTypes.AUDIT_USER_CHANGE_PASSWORD_RECOVERY);
        Assert.isTrue((boolean)SystemProperties.getBoolean((DefinedSystemParameter)DefinedSystemParameter.PASSWORD_RECOVERY_ENABLED), (String)"[Assertion failed] - this expression must be true");
        Assert.isTrue((boolean)StringUtils.isNotEmpty((String)uuidText), (String)"[Assertion failed] - this expression must be true");
        Optional optionalUsername = this.passwordRecoveryService.findUserByCode(uuidText);
        if (optionalUsername.isPresent()) {
            String username = (String)optionalUsername.get();
            changePasswordAudit.params((Map)ImmutableMap.of((Object)"username", (Object)username));
            User user = this.userService.getUser(username, new String[0]);
            Assert.notNull((Object)user, (String)"[Assertion failed] - this argument is required; it must not be null");
            this.userService.changeUserPassword(username, newPassword);
            session.removeAttribute("changePasswordUser");
            this.passwordRecoveryService.invalidateCode(uuidText);
            request.setAttribute("audit", (Object)changePasswordAudit.success(true).build());
            return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
        }
        request.setAttribute("audit", (Object)changePasswordAudit.success(false).build());
        return new ResponseEntity((Object)ImmutableMap.of((Object)"incorrectUuid", (Object)true), (HttpStatusCode)HttpStatus.NOT_ACCEPTABLE);
    }

    @ResponseBody
    @RequestMapping(value={"recovery/request"}, method={RequestMethod.POST})
    public ResponseEntity<?> requestPasswordRecovery(HttpServletRequest request, HttpSession session, @RequestParam(value="username") String username, @RequestParam(value="email") String email) {
        AuditBuilder requestPasswordRecoveryAudit = AuditBuilder.getInstance().type(AuditTypes.AUDIT_USER_REQUEST_PASSWORD_RECOVERY).params((Map)ImmutableMap.of((Object)"username", (Object)username, (Object)"useremail", (Object)email)).success(false);
        if (!SystemProperties.getBoolean((DefinedSystemParameter)DefinedSystemParameter.PASSWORD_RECOVERY_ENABLED).booleanValue()) {
            log.warn("Password recovery is not available");
            request.setAttribute("audit", (Object)requestPasswordRecoveryAudit.build());
            return new ResponseEntity((Object)ImmutableMap.of((Object)"passwordRecoveryUnavailable", (Object)true), (HttpStatusCode)HttpStatus.NOT_ACCEPTABLE);
        }
        User user = this.userService.getUser(username, new String[0]);
        if (user == null) {
            log.warn("User {} not found");
            request.setAttribute("audit", (Object)requestPasswordRecoveryAudit.build());
            return new ResponseEntity((Object)ImmutableMap.of((Object)"userNotFound", (Object)true), (HttpStatusCode)HttpStatus.NOT_ACCEPTABLE);
        }
        if (!this.emailSupportService.hasEmailAddress(user)) {
            log.warn("Password recovery for user {} is not available cause of empty email address");
            request.setAttribute("audit", (Object)requestPasswordRecoveryAudit.build());
            return new ResponseEntity((Object)ImmutableMap.of((Object)"notDefinedEmail", (Object)true), (HttpStatusCode)HttpStatus.NOT_ACCEPTABLE);
        }
        if (!email.equalsIgnoreCase(user.getEmail())) {
            log.warn("Email {} doesn't match for user {}", (Object)email, (Object)username);
            request.setAttribute("audit", (Object)requestPasswordRecoveryAudit.build());
            return new ResponseEntity((Object)ImmutableMap.of((Object)"incorrectEmail", (Object)true), (HttpStatusCode)HttpStatus.NOT_ACCEPTABLE);
        }
        try {
            this.passwordRecoveryService.sendPasswordRecoveryEmail(user);
            session.setAttribute("changePasswordUser", (Object)username);
            request.setAttribute("audit", (Object)requestPasswordRecoveryAudit.success(true).build());
            return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            request.setAttribute("audit", (Object)requestPasswordRecoveryAudit.build());
            return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @ResponseBody
    @RequestMapping(value={"self/assign"}, method={RequestMethod.POST})
    public ResponseEntity<?> selfAssignPassword(HttpServletRequest request, @RequestParam String token, @RequestParam String password) {
        AuditBuilder selfAssignPasswordAudit = AuditBuilder.getInstance().type(AuditTypes.AUDIT_SELF_PASSWORD_ASSIGN).success(false);
        try {
            PasswordAssignToken passwordAssignToken = this.selfPasswordAssignService.decryptSelfAssignPasswordToken(token);
            User user = this.userService.getUser(Long.valueOf(passwordAssignToken.getUserId()), new String[0]);
            selfAssignPasswordAudit.params((Map)ImmutableMap.of((Object)"username", (Object)user.getUserName()));
            this.selfPasswordAssignService.assignPasswordForUser(passwordAssignToken, password);
            request.setAttribute("audit", (Object)selfAssignPasswordAudit.buildSuccess());
            return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
        }
        catch (SelfAssignPasswordLinkExpiredException e) {
            request.setAttribute("audit", (Object)selfAssignPasswordAudit.buildFailure());
            return new ResponseEntity((Object)ImmutableMap.of((Object)"linkExpired", (Object)true), (HttpStatusCode)HttpStatus.FORBIDDEN);
        }
        catch (PasswordAlreadyAssignedException e) {
            request.setAttribute("audit", (Object)selfAssignPasswordAudit.buildFailure());
            return new ResponseEntity((Object)ImmutableMap.of((Object)"passwordAssigned", (Object)true), (HttpStatusCode)HttpStatus.FORBIDDEN);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)selfAssignPasswordAudit.buildFailure());
            throw new RuntimeException(e);
        }
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public RestResult handleIllegalArgumentException(IllegalArgumentException e) {
        log.info(e.getMessage());
        return new RestResult(false, e.getMessage());
    }
}

