/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.administration.restart;

import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.core.RestartService;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import io.swagger.annotations.Api;
import java.beans.ConstructorProperties;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.RequestContextHolder;

@RestController
@RequestMapping(value={"/restarts"})
@Api(hidden=true)
public class RestartController {
    private static final Logger log = LoggerFactory.getLogger(RestartController.class);
    private final RestartService restartService;
    private final AuthorizationHelper authorizationHelper;

    @GetMapping
    public RestartsAvailability availability() {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        return new RestartsAvailability(this.restartService.isRestartSupported());
    }

    @PostMapping
    public ResponseEntity<Void> restart() {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        if (!this.restartService.isRestartSupported()) {
            return ResponseEntity.badRequest().build();
        }
        this.audit(AuditTypes.AUDIT_SELF_RESTART);
        this.restartService.restartAsync();
        return ResponseEntity.accepted().build();
    }

    private void audit(AuditTypes type) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(type);
        Objects.requireNonNull(RequestContextHolder.getRequestAttributes()).setAttribute("audit", (Object)auditBuilder.buildSuccess(), 0);
    }

    @ConstructorProperties(value={"restartService", "authorizationHelper"})
    public RestartController(RestartService restartService, AuthorizationHelper authorizationHelper) {
        this.restartService = restartService;
        this.authorizationHelper = authorizationHelper;
    }

    public record RestartsAvailability(boolean available) {
    }
}

