/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.formatter;

import com.suncode.pwfl.audit.formatter.Formatter;
import com.suncode.pwfl.audit.util.AuditParamsNames;
import com.suncode.pwfl.i18n.MessageHelper;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;

public class AddViewProtectionFormatter
extends Formatter {
    private static final Logger log = LoggerFactory.getLogger(AddViewProtectionFormatter.class);
    final String permissionLevel = "permissionLevel";

    @Override
    public LinkedHashMap<String, String> format(HashMap<String, String> map) {
        try {
            LinkedHashMap<String, String> formattedMap = this.createViewProtectionAuditParameters(map);
            String permissionLevelParam = map.get(this.permissionLevel);
            formattedMap.put(AuditParamsNames.PERMISSION_LEVEL.toString(), this.getPermissionLevelTranslation(permissionLevelParam));
            return formattedMap;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return new LinkedHashMap<String, String>();
        }
    }

    LinkedHashMap<String, String> createViewProtectionAuditParameters(HashMap<String, String> map) {
        LinkedHashMap<String, String> formattedMap = new LinkedHashMap<String, String>();
        formattedMap.put(AuditParamsNames.VIEW_ID.toString(), map.get("viewId"));
        formattedMap.put(AuditParamsNames.PROTECTION_ID.toString(), map.get("protectionId"));
        formattedMap.put(AuditParamsNames.PROTECTION_NAME.toString(), map.get("protectionName"));
        formattedMap.put(AuditParamsNames.PROTECTION_IS_GROUP.toString(), this.translateBooleanValue(map.get("protectionIsGroup"), LocaleContextHolder.getLocale()));
        return formattedMap;
    }

    String getPermissionLevelTranslation(String permissionLevelParam) {
        String permissionLevelKey = permissionLevelParam == null || permissionLevelParam.equalsIgnoreCase("PREVIEW") ? "Podglad" : "Edycja";
        return MessageHelper.getMessage((String)permissionLevelKey);
    }
}

