/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.struts.action;

import com.plusmpm.util.TabMenuData;
import com.suncode.plugin.framework.web.WebFragmentsManager;
import com.suncode.plugin.framework.web.support.MenuEntry;
import com.suncode.pwfl.administration.configuration.DefinedSystemParameter;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.config.tomcat.ServerMode;
import com.suncode.pwfl.config.tomcat.TomcatService;
import com.suncode.pwfl.experimental.ExperimentalConfiguration;
import com.suncode.pwfl.experimental.ExperimentalFeature;
import com.suncode.pwfl.i18n.MessageHelper;
import com.suncode.pwfl.util.SpringContext;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.springframework.core.OrderComparator;

public class SystemConfigAction
extends Action {
    private final String TAB_MENU_SECTION = "system.administration.systemconfig.menu";
    private WebFragmentsManager webFragmentsManager = (WebFragmentsManager)SpringContext.getBean(WebFragmentsManager.class);
    private final TomcatService tomcatService = (TomcatService)SpringContext.getBean(TomcatService.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(false);
        if (session == null || session.getAttribute("username") == null) {
            return mapping.findForward("welcome");
        }
        request.setAttribute("tabMenuItems", this.generateSystemConfigMenu());
        return mapping.findForward("showSystemConfig");
    }

    private List<TabMenuData> generateSystemConfigMenu() {
        ArrayList<TabMenuData> tabs = new ArrayList<TabMenuData>();
        if (ExperimentalConfiguration.getExperimentalInstance().hasFeature(ExperimentalFeature.MAINTENANCE_MODE)) {
            tabs.add(new TabMenuData("server", MessageHelper.getMessage((String)"Serwer"), "/ServerManagement.do", 0));
        }
        tabs.add(new TabMenuData("ldap", MessageHelper.getMessage((String)"Serwery_LDAP"), "/Domains.do", 5));
        if (SystemProperties.getBoolean((DefinedSystemParameter)DefinedSystemParameter.SHOW_EXTERNAL_DATABASE_CART).booleanValue()) {
            tabs.add(new TabMenuData("externaldb", MessageHelper.getMessage((String)"Zewnetrzna_baza_danych"), "/ExternalDB.do", 15));
        }
        if (this.tomcatService.getTomcatInstanceParameters().getServerMode() == ServerMode.MASTER) {
            tabs.add(new TabMenuData("scheduledtasks", MessageHelper.getMessage((String)"Zaplanowane_zadania"), "/ScheduledTasks.do", 25));
        }
        if (SystemProperties.getBoolean((DefinedSystemParameter)DefinedSystemParameter.SHOW_MODULES_TAB).booleanValue()) {
            tabs.add(new TabMenuData("modules", MessageHelper.getMessage((String)"Moduly"), "/PluginsConfiguration.do", 35));
        }
        tabs.add(new TabMenuData("pluginmanager", MessageHelper.getMessage((String)"Wtyczki"), "/PluginManager.do", 45));
        tabs.add(new TabMenuData("usernotifications", MessageHelper.getMessage((String)"Powiadomienia_uzytkownikow"), "/UserNotificationConfiguration.do", 55));
        tabs.add(new TabMenuData("systemparameters", MessageHelper.getMessage((String)"Parametry_systemu"), "/SystemParametersConfiguration.do", 65));
        tabs.add(new TabMenuData("certificates", MessageHelper.getMessage((String)"Certyfikaty"), "/Certificates.do", 70));
        tabs.add(new TabMenuData("passwordpolicy", MessageHelper.getMessage((String)"Polityka_hasel"), "/PasswordPolicy.do", 75));
        tabs.add(new TabMenuData("dataSource", MessageHelper.getMessage((String)"Zrodla_danych"), "/DataSourceManager.do", 85));
        tabs.add(new TabMenuData("globalUserSettings", MessageHelper.getMessage((String)"Ustawienia_uzytkownikow"), "/GlobalUserSettings.do", 95));
        tabs.add(new TabMenuData("configTransfer", MessageHelper.getMessage((String)"CONFIG_TRANSFER"), "/ConfigTransfer.do", 105));
        tabs.add(new TabMenuData("logsAdministration", MessageHelper.getMessage((String)"Log_Administration"), "/LogsAdministration.do", 115));
        tabs.add(new TabMenuData("emailconfiguration", MessageHelper.getMessage((String)"Konfiguracja_skrzynek_pocztowych"), "/EmailConfiguration.do", 125));
        tabs.add(new TabMenuData("translations", MessageHelper.getMessage((String)"Translations"), "/Translations.do", 135));
        tabs.add(new TabMenuData("dashboardAdministration", MessageHelper.getMessage((String)"dashboards"), "/DashboardAdministration.do", 145));
        tabs.add(new TabMenuData("systemmessages", MessageHelper.getMessage((String)"Komunikaty"), "/SystemMessages.do", 155));
        tabs.add(new TabMenuData("authenticationManagement", MessageHelper.getMessage((String)"Poswiadczenia"), "/AuthenticationManagement.do", 165));
        tabs.add(new TabMenuData("applicationManagement", MessageHelper.getMessage((String)"Aplikacje"), "/ApplicationManagement.do", 175));
        tabs.add(new TabMenuData("calendarResources", MessageHelper.getMessage((String)"Zasoby_kalendarza"), "/CalendarResources.do", 195));
        for (MenuEntry entry : this.webFragmentsManager.getMenuEntries("system.administration.systemconfig.menu")) {
            if (!entry.meetsCondition()) continue;
            tabs.add(new TabMenuData(entry.getKey(), entry.getLabel(), entry.getLinkPath(), entry.getOrder()));
        }
        OrderComparator.sort(tabs);
        return tabs;
    }
}

