/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.webapp.controllers.documents;

import com.plusmpm.database.DBManagement;
import com.plusmpm.database.IndexTable;
import com.plusmpm.database.authorization.RightTreeBuilder;
import com.plusmpm.i18n.I18NCustom;
import com.plusmpm.struts.form.VariableListForm;
import com.plusmpm.util.Authorization;
import com.plusmpm.util.DocumentData;
import com.suncode.pwfl.administration.configuration.DefinedSystemParameter;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.Link;
import com.suncode.pwfl.archive.LinkConnection;
import com.suncode.pwfl.archive.LinkIndex;
import com.suncode.pwfl.archive.LinkService;
import com.suncode.pwfl.experimental.Experimental;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.translation.configElements.TranslatedFieldType;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class GotoController {
    private static final Logger log = LoggerFactory.getLogger(GotoController.class);
    private static final Integer LIMIT = 500;
    private final MessageHelperBean messageHelper;
    private final DocumentClassService documentClassService;
    private final LinkService linkService;
    private final Experimental experimental;

    @RequestMapping(value={"Goto.do"})
    public String execute(@RequestParam String search, @RequestParam String name, HttpServletRequest request) throws Exception {
        String sSearchIndexId;
        Object value;
        String sSearchObjectValue;
        Object[] obj;
        Locale locale = LocaleContextHolder.getLocale();
        I18NCustom i18NCustom = new I18NCustom(locale);
        HttpSession session = request.getSession(false);
        String sUserName = (String)session.getAttribute("username");
        boolean auth = SystemProperties.getBoolean((DefinedSystemParameter)DefinedSystemParameter.AUTHORIZE_USER_FOR_FILE);
        ArrayList<LinkIndex> alShowIndices = new ArrayList<LinkIndex>();
        String sObjId = null;
        ArrayList alDocuments = null;
        Vector<String> vIndices = new Vector<String>();
        HashMap hmDocIndices = new HashMap();
        HashMap<String, String> hmParamIndices = new HashMap<String, String>();
        Map mParameterMap = request.getParameterMap();
        for (Object o : obj = mParameterMap.keySet().toArray()) {
            sSearchObjectValue = (String)o;
            if (!sSearchObjectValue.startsWith("indices")) continue;
            int iPos = sSearchObjectValue.indexOf(91);
            int iEnd = sSearchObjectValue.indexOf(93);
            if (iPos < 0 || iEnd < 0) {
                iPos = sSearchObjectValue.indexOf(60);
                iEnd = sSearchObjectValue.indexOf(62);
            }
            String sIndex = sSearchObjectValue.substring(iPos + 1, iEnd);
            sIndex = sIndex.replace('\\', '/');
            vIndices.add(sIndex);
            value = request.getParameter(sSearchObjectValue);
            log.info("sIndex:{}, value:{}", (Object)sIndex, value);
            hmParamIndices.put(sIndex, (String)value);
        }
        DBManagement dbm = new DBManagement();
        Object sFileId = "";
        long resultCount = 0L;
        if ("class".equalsIgnoreCase(search)) {
            DocumentClass docClass = this.documentClassService.getDocumentClass(name, new String[0]);
            if (docClass != null) {
                int rights;
                if (!auth) {
                    rights = 0;
                } else {
                    String rightsToCheck = RightTreeBuilder.builder().system().archive().docClasses().custom((Object)docClass.getId()).read().build();
                    rights = Authorization.checkRight((String)rightsToCheck, (String)sUserName, (boolean)false, (boolean)false);
                }
                if (0 != rights) {
                    request.setAttribute("message", (Object)this.messageHelper.getMessage("Brak_uprawnien"));
                    return "/userViews/userviewserror.jsp";
                }
                sObjId = docClass.getId().toString();
                HashMap hmIndices = new HashMap();
                value = vIndices.iterator();
                while (value.hasNext()) {
                    String vIndex;
                    sSearchIndexId = vIndex = (String)value.next();
                    IndexTable index = dbm.getIndexByNameInDocClass(docClass.getId().toString(), sSearchIndexId);
                    index.setIndexName(i18NCustom.getString(index.getIndexName()));
                    alShowIndices.add((LinkIndex)index);
                    sSearchObjectValue = hmParamIndices.get(sSearchIndexId);
                    hmIndices.put(index, sSearchObjectValue);
                }
                CountedResult documents = DBManagement.SearchDocClassCounted((HashMap)hmIndices, (String)docClass.getId().toString(), (String)"", (String)"", (String)"", (int)LIMIT, (int)0, (int)0, (int)0, (long)0L, (boolean)false);
                resultCount = documents.getTotal();
                alDocuments = (ArrayList)documents.getData();
                for (int j = 0; j < alDocuments.size(); ++j) {
                    DocumentData documentData = (DocumentData)alDocuments.get(j);
                    long lFileId = documentData.getLFileId();
                    sFileId = "" + lFileId;
                    documentData.setLDocClassName(i18NCustom.getString(documentData.getLDocClassName()));
                }
            } else {
                log.error("Document class [{}] does not exist. Cannot show documents.", (Object)name);
            }
        }
        if ("link".equalsIgnoreCase(search)) {
            Link link = this.linkService.getByName(name, new String[0]);
            if (link != null) {
                Object rightsToCheck;
                int rights;
                List linkIndices = this.linkService.getLinkIndicesForLink(link.getId());
                for (LinkIndex linkIndex : linkIndices) {
                    if (vIndices.contains(linkIndex.getName())) continue;
                    vIndices.add(linkIndex.getName());
                }
                if (!auth) {
                    rights = 0;
                } else {
                    rightsToCheck = RightTreeBuilder.builder().system().archive().links().custom((Object)link.getId()).read().build();
                    rights = Authorization.checkRight((String)rightsToCheck, (String)sUserName, (boolean)false, (boolean)false);
                }
                if (0 != rights) {
                    request.setAttribute("message", (Object)this.messageHelper.getMessage("Brak_uprawnien"));
                    return "/userViews/userviewserror.jsp";
                }
                sObjId = link.getId().toString();
                rightsToCheck = vIndices.iterator();
                while (rightsToCheck.hasNext()) {
                    String vIndex;
                    sSearchIndexId = vIndex = (String)rightsToCheck.next();
                    Optional linkIndex = this.linkService.getLinkIndexByName(link.getId(), sSearchIndexId);
                    if (linkIndex.isPresent()) {
                        ((LinkIndex)linkIndex.get()).setName(this.linkService.getLinkIndexTranslation(((LinkIndex)linkIndex.get()).getId(), TranslatedFieldType.NAME));
                        alShowIndices.add((LinkIndex)linkIndex.get());
                        List linkConnections = this.linkService.getLinkConnectionsForLinkIndex(((LinkIndex)linkIndex.get()).getId(), new String[]{"documentClass", "documentClassIndex"});
                        for (LinkConnection linkConnection : linkConnections) {
                            Long LDocClassId = linkConnection.getDocumentClass().getId();
                            Long LIndexId = linkConnection.getDocumentClassIndex().getId();
                            HashMap<IndexTable, String> hmIndecies = (HashMap<IndexTable, String>)hmDocIndices.get(LDocClassId.toString());
                            if (hmIndecies == null) {
                                hmIndecies = new HashMap<IndexTable, String>();
                            }
                            IndexTable index = DBManagement.getIndex((String)LIndexId.toString());
                            sSearchObjectValue = hmParamIndices.get(sSearchIndexId);
                            hmIndecies.put(index, sSearchObjectValue);
                            hmDocIndices.put(LDocClassId.toString(), hmIndecies);
                        }
                        continue;
                    }
                    log.info("Brak indeksu " + sSearchIndexId + " w zestawie dokument\u00f3w: " + name);
                }
                VariableListForm[] linkIndexes = this.prepareLinkIndexes(alShowIndices, link.getId(), hmParamIndices);
                ArrayList alSearchedDocClasses = new ArrayList(hmDocIndices.keySet());
                CountedResult documents = dbm.searchLinkCounted(linkIndexes, sUserName, "", "", LIMIT.intValue(), 0, 0, 0, alSearchedDocClasses, false, auth);
                resultCount = documents.getTotal();
                alDocuments = (ArrayList)documents.getData();
                Iterator iterator = alDocuments.iterator();
                if (iterator.hasNext()) {
                    Object alDocument = iterator.next();
                    DocumentData documentData = (DocumentData)alDocument;
                    long lFileId = documentData.getLFileId();
                    if (StringUtils.isBlank((String)sFileId)) {
                        sFileId = "" + lFileId;
                    }
                }
            } else {
                log.error("Document set [{}] does not exist. Cannot show documents.", (Object)name);
            }
        }
        Integer pageSize = resultCount < (long)(LIMIT + 1) ? (int)resultCount : LIMIT;
        log.info("alDocuments.size(): " + (alDocuments != null ? Long.valueOf(resultCount) : null));
        if (alDocuments != null) {
            if (resultCount == 1L) {
                return String.format("redirect:documents/%s/show.do", sFileId);
            }
            if (resultCount > 1L) {
                if ("class".equalsIgnoreCase(search)) {
                    this.setRequestAttributesForClass(request, alDocuments, sObjId, alShowIndices, pageSize);
                    return "/archive/externalSearchDocClassResult.jsp";
                }
                if ("link".equalsIgnoreCase(search)) {
                    this.setRequestAttributesForLink(request, alDocuments, sObjId, name, alShowIndices, pageSize);
                    return "/archive/externalSearchLinkResult.jsp";
                }
            }
        }
        return "/ShowUserDefaultView.do";
    }

    private void setRequestAttributesForClass(HttpServletRequest request, List<?> alDocuments, String sObjId, List<?> alShowIndecies, Integer pageSize) {
        request.setAttribute("alDocuments", alDocuments);
        request.setAttribute("docclassId", (Object)sObjId);
        request.setAttribute("alIndecies", alShowIndecies);
        request.setAttribute("pageSize", (Object)pageSize.toString());
    }

    private void setRequestAttributesForLink(HttpServletRequest request, List<?> alDocuments, String sObjId, String sSearchObject, List<?> alShowIndecies, Integer pageSize) {
        request.getSession().setAttribute("alDocuments", alDocuments);
        request.getSession().setAttribute("alDocumentsA", alDocuments);
        request.setAttribute("alDocuments", alDocuments);
        request.setAttribute("docclassId", (Object)sObjId);
        request.setAttribute("name", (Object)sSearchObject);
        request.setAttribute("alIndecies", alShowIndecies);
        request.setAttribute("pageSize", (Object)pageSize.toString());
    }

    private VariableListForm[] prepareLinkIndexes(ArrayList<LinkIndex> indexDefinitions, Long linkId, Map<String, String> hmParamIndecis) {
        VariableListForm first = new VariableListForm();
        first.setVarName("linkId");
        first.setVarValue(linkId.toString());
        ArrayList<VariableListForm> idx = new ArrayList<VariableListForm>();
        idx.add(first);
        for (LinkIndex index : indexDefinitions) {
            VariableListForm idxEntry = new VariableListForm();
            idxEntry.setVarID(index.getId().toString());
            idxEntry.setVarName(index.getId().toString());
            idxEntry.setVarShow("on");
            idxEntry.setVarType(index.getType());
            String idxValue = hmParamIndecis.get(index.getName());
            if (idxValue != null) {
                idxEntry.setVarValue(idxValue.toString());
            }
            idx.add(idxEntry);
        }
        return idx.toArray(new VariableListForm[0]);
    }

    @ConstructorProperties(value={"messageHelper", "documentClassService", "linkService", "experimental"})
    @Autowired
    public GotoController(MessageHelperBean messageHelper, DocumentClassService documentClassService, LinkService linkService, Experimental experimental) {
        this.messageHelper = messageHelper;
        this.documentClassService = documentClassService;
        this.linkService = linkService;
        this.experimental = experimental;
    }
}

