/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.substitutions;

import com.plusmpm.util.Authorization;
import com.plusmpm.util.classLoader.PlusClassLoader;
import com.plusmpm.util.delegation.DelegationUsers;
import com.suncode.pwfl.administration.configuration.DefinedSystemParameter;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.administration.structure.Role;
import com.suncode.pwfl.administration.structure.RoleService;
import com.suncode.pwfl.administration.substitution.Substitution;
import com.suncode.pwfl.administration.substitution.SubstitutionFormDto;
import com.suncode.pwfl.administration.substitution.SubstitutionHook;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.hook.HookRegistry;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.util.exception.ServiceException;
import com.suncode.pwfl.web.security.exception.NoRightsException;
import com.suncode.pwfl.workflow.process.ProcessDefinition;
import com.suncode.pwfl.workflow.process.ProcessService;
import com.suncode.pwfl.workflow.process.ProcessType;
import java.beans.ConstructorProperties;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.joda.time.IllegalFieldValueException;
import org.joda.time.LocalDateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SubstitutionMapper {
    private static final Logger log = LoggerFactory.getLogger(SubstitutionMapper.class);
    private final RoleService roleService;
    private final ProcessService processService;
    private final UserService userService;
    private final MessageHelperBean messageHelper;
    private final HookRegistry hookRegistry;

    public Substitution toEntity(SubstitutionFormDto substitutionFormDto) throws ParseException {
        String finishDate;
        User substituted;
        Substitution substitution = new Substitution();
        String processDefId = substitutionFormDto.getProcessDefId();
        String username = substitutionFormDto.getSubstitutedUsername();
        if (StringUtils.isNotBlank((String)processDefId) && !StringUtils.equals((String)processDefId, (String)"*")) {
            List userProcessesTypes;
            Stream<ProcessType> processesAvailableToUser;
            if (!this.hookRegistry.hasHooks(SubstitutionHook.class) ? (processesAvailableToUser = this.processService.getAllProcessTypes(false).stream().filter(processTypeDto -> Authorization.isProcessVisibleToUser((String)username, (String)processTypeDto.getProcessDefId()))).noneMatch(processType -> processType.getProcessDefId().equals(substitutionFormDto.getProcessDefId())) : (userProcessesTypes = ((SubstitutionHook)this.hookRegistry.invoke(SubstitutionHook.class)).filterProcesses(username, this.processService.getAllProcessTypes(false))).stream().noneMatch(processType -> processType.getProcessDefId().equals(substitutionFormDto.getProcessDefId()))) {
                throw new NoRightsException(this.messageHelper.getMessage("Brak_uprawnien_do_tego_typu_procesu"));
            }
            ProcessDefinition processDefinition = this.processService.getProcessDefinition(substitutionFormDto.getProcessDefId());
            if (processDefinition == null) {
                throw new ServiceException(this.messageHelper.getMessage("Proces_o_podanej_definicji_nie_istnieje"));
            }
            substitution.setProcessDefId(processDefId);
            String roleId = substitutionFormDto.getRoleId();
            if (StringUtils.isNotBlank((String)roleId) && !StringUtils.equals((String)roleId, (String)"*")) {
                Role role = this.roleService.getRole(processDefinition.getPackageId(), processDefinition.getProcessDefinitionId(), roleId);
                if (role == null) {
                    throw new ServiceException(this.messageHelper.getMessage("Rola_o_podanym_identyfikatorze_nie_istnieje", new Object[]{roleId}));
                }
                substitution.setRole(role);
            }
        }
        if ((substituted = this.userService.getUser(substitutionFormDto.getSubstitutedUsername(), new String[0])) == null) {
            throw new ServiceException(this.messageHelper.getMessage("Uzytkownik_nie_istnieje", new Object[]{substitutionFormDto.getSubstitutedUsername()}));
        }
        substitution.setSubstituted(substituted);
        User substitute = this.userService.getUser(substitutionFormDto.getSubstituteUsername(), new String[0]);
        if (substitute == null) {
            throw new ServiceException(this.messageHelper.getMessage("Uzytkownik_nie_istnieje", new Object[]{substitutionFormDto.getSubstituteUsername()}));
        }
        substitution.setSubstitute(substitute);
        String startDate = substitutionFormDto.getStartDate();
        if (StringUtils.isNotBlank((String)startDate)) {
            substitution.setStartDate(this.convertDateFormat(startDate, true));
        }
        if (StringUtils.isNotBlank((String)(finishDate = substitutionFormDto.getFinishDate()))) {
            substitution.setFinishDate(this.convertDateFormat(finishDate, false));
        }
        this.validateSubstitutionUsers(substitution, UserContext.current().getUser().getUserName());
        return substitution;
    }

    private LocalDateTime convertDateFormat(String date, boolean isStartDate) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
        try {
            return LocalDateTime.parse((String)date, (DateTimeFormatter)dateTimeFormatter);
        }
        catch (IllegalFieldValueException illegalFieldValueException) {
            throw new ServiceException(this.messageHelper.getMessage(isStartDate ? "substitution.start.date.incorrect" : "substitution.finish.date.incorrect"), (Throwable)illegalFieldValueException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ServiceException(this.messageHelper.getMessage(isStartDate ? "substitution.start.date.incorrectFormat" : "substitution.finish.date.incorrectFormat", new Object[]{"YYYY-MM-DD"}), (Throwable)illegalArgumentException);
        }
        catch (Exception e) {
            throw new ServiceException(this.messageHelper.getMessage(isStartDate ? "substitution.start.date.incorrect" : "substitution.finish.date.incorrect"), (Throwable)e);
        }
    }

    private void validateSubstitutionUsers(Substitution substitution, String userName) {
        if (!this.checkSubstituteIsProper(substitution.getSubstituted(), substitution.getSubstitute(), userName)) {
            throw new ServiceException(this.messageHelper.getMessage("Nie_udalo_sie_dodac_zastepstwa"));
        }
    }

    private boolean checkSubstituteIsProper(User substituted, User substitute, String userName) {
        boolean substituteValid = true;
        List users = ((SubstitutionHook)this.hookRegistry.invoke(SubstitutionHook.class)).getSubstitutes(userName, substituted.getUserName());
        if (users != null) {
            substituteValid = false;
            for (User user : users) {
                if (!user.getUserName().equals(substitute.getUserName())) continue;
                substituteValid = true;
                break;
            }
            return substituteValid;
        }
        String className = SystemProperties.getString((DefinedSystemParameter)DefinedSystemParameter.DELEGATION_CUSTOMCLASS);
        if (StringUtils.isNotBlank((String)className)) {
            ArrayList userList;
            DelegationUsers delegationUsers = null;
            PlusClassLoader plusClassLoader = new PlusClassLoader();
            try {
                Class classDU = plusClassLoader.loadClass(className);
                delegationUsers = (DelegationUsers)classDU.newInstance();
            }
            catch (Exception e) {
                log.error("Nie uda\u0142o si\u0119 wczyta\u0107 klasy \"" + className + "\" Shark.conf - Delegation.CustomClass", (Throwable)e);
                substituteValid = false;
            }
            if (delegationUsers != null && (userList = delegationUsers.getUsersList(substituted.getUserName())) != null && !userList.contains(substitute.getUserName())) {
                substituteValid = false;
                log.warn("Pr\u00f3bowano nada\u0107 zast\u0119pstwo niepoprawnemu u\u017cytkownikowi.");
            }
        }
        return substituteValid;
    }

    @ConstructorProperties(value={"roleService", "processService", "userService", "messageHelper", "hookRegistry"})
    @Autowired
    public SubstitutionMapper(RoleService roleService, ProcessService processService, UserService userService, MessageHelperBean messageHelper, HookRegistry hookRegistry) {
        this.roleService = roleService;
        this.processService = processService;
        this.userService = userService;
        this.messageHelper = messageHelper;
        this.hookRegistry = hookRegistry;
    }
}

