/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.administration.datasources;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.builder.AuditParamsBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.cache.CacheFactory;
import com.suncode.pwfl.cache.PlusWorkflowTempFileCache;
import com.suncode.pwfl.cache.SystemCacheId;
import com.suncode.pwfl.cache.TempFileStream;
import com.suncode.pwfl.cache.config.TempFileCacheConfig;
import com.suncode.pwfl.component.exception.InvalidComponentException;
import com.suncode.pwfl.datasource.DataSourceCacheExpiredException;
import com.suncode.pwfl.datasource.DataSourceDeclarationDto;
import com.suncode.pwfl.datasource.DataSourceDefinitionDto;
import com.suncode.pwfl.datasource.DataSourceDto;
import com.suncode.pwfl.datasource.DataSourceInstance;
import com.suncode.pwfl.datasource.DataSourceOperation;
import com.suncode.pwfl.datasource.DataSourceService;
import com.suncode.pwfl.datasource.DataSourceValidateException;
import com.suncode.pwfl.datasource.InvocableDataSource;
import com.suncode.pwfl.datasource.TemporaryDataSourceExecutor;
import com.suncode.pwfl.datasource.dao.DataSourceCategory;
import com.suncode.pwfl.datasource.dao.DataSourceDeclaration;
import com.suncode.pwfl.datasource.declaration.DataSourceReader;
import com.suncode.pwfl.datasource.rest.CountedResultDto;
import com.suncode.pwfl.datasource.rest.DataSourceExportDto;
import com.suncode.pwfl.datasource.rest.DataSourceTree;
import com.suncode.pwfl.datasource.rest.DataSourceTypeDto;
import com.suncode.pwfl.datasource.rest.SortDto;
import com.suncode.pwfl.datasource.rest.TemporaryDataSource;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.plugin.modules.dataSourceConfigurationTransfer.DataSourceConfigurationTransferService;
import com.suncode.pwfl.plugin.modules.dataSourceConfigurationTransfer.DataSourceImportResult;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.FilterOperator;
import com.suncode.pwfl.search.LogicOperator;
import com.suncode.pwfl.search.Pagination;
import com.suncode.pwfl.search.Sorter;
import com.suncode.pwfl.search.hibernate.GroupHibernateFilter;
import com.suncode.pwfl.search.hibernate.HibernateFilter;
import com.suncode.pwfl.search.hibernate.SimpleHibernateFilter;
import com.suncode.pwfl.util.PaginatedList;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import com.suncode.pwfl.web.security.exception.NotFullRightsException;
import com.suncode.pwfl.web.support.ajax.EntityRestResult;
import com.suncode.pwfl.web.support.ajax.RestResult;
import com.suncode.pwfl.web.support.io.DownloadResource;
import com.suncode.pwfl.workflow.component.WorkflowComponentRegistry;
import jakarta.annotation.PostConstruct;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/datasources"})
public class DataSourceController {
    private static final Logger log = LoggerFactory.getLogger(DataSourceController.class);
    private final WorkflowComponentRegistry registry;
    private final DataSourceService dataSourceService;
    private final DataSourceReader reader;
    private final TemporaryDataSourceExecutor temporaryDataSourceExecutor;
    private final MessageHelperBean messageHelper;
    private final AuthorizationHelper authorizationHelper;
    private final DataSourceConfigurationTransferService configurationTransferService;
    private final CacheFactory cacheFactory;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private PlusWorkflowTempFileCache exportCache;

    @PostConstruct
    private void initialize() {
        this.exportCache = this.cacheFactory.createTempFileCache(SystemCacheId.DATA_SOURCE_EXPORT_CACHE, TempFileCacheConfig.builder().build());
    }

    @RequestMapping(method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<DataSourceDeclarationDto> getDataSources(@RequestParam(value="operations", required=false) List<String> rawOperations, @RequestParam(required=false) String query, @RequestParam(required=false) Integer start, @RequestParam(required=false) Integer limit, SortDto sort) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        Sorter sorter = sort.getSorter();
        if (sorter == null) {
            sorter = new Sorter("name");
        }
        GroupHibernateFilter filters = new GroupHibernateFilter(LogicOperator.AND);
        if (!CollectionUtils.isEmpty(rawOperations)) {
            List operations = rawOperations.stream().map(operation -> DataSourceOperation.valueOf((String)operation.toUpperCase())).collect(Collectors.toList());
            GroupHibernateFilter operationsFilter = new GroupHibernateFilter(LogicOperator.OR);
            operationsFilter.addFilter((HibernateFilter)new SimpleHibernateFilter("operation", (Object)FilterOperator.ISNULL));
            operationsFilter.addFilter((HibernateFilter)new SimpleHibernateFilter("operation", operations, FilterOperator.IN));
            filters.addFilter((HibernateFilter)operationsFilter);
        }
        if (StringUtils.isNotBlank((CharSequence)query)) {
            GroupHibernateFilter queryFilters = new GroupHibernateFilter(LogicOperator.OR);
            queryFilters.addFilter((HibernateFilter)new SimpleHibernateFilter("id", (Object)("%" + query + "%"), FilterOperator.ILIKE));
            queryFilters.addFilter((HibernateFilter)new SimpleHibernateFilter("name", (Object)("%" + query + "%"), FilterOperator.ILIKE));
            queryFilters.addFilter((HibernateFilter)new SimpleHibernateFilter("description", (Object)query, FilterOperator.ILIKE));
            filters.addFilter((HibernateFilter)queryFilters);
        }
        CountedResult declarations = this.dataSourceService.getDeclarations((HibernateFilter)filters, Pagination.create((Sorter)sorter, (Integer)0, null));
        List dtos = declarations.getData().stream().filter(declaration -> {
            InvocableDataSource dataSource = this.registry.getDataSource(declaration.getType());
            if (dataSource == null) {
                return false;
            }
            if (declaration.getOperation() != null) {
                return true;
            }
            if (CollectionUtils.isEmpty((Collection)dataSource.getOperations()) || CollectionUtils.isEmpty((Collection)rawOperations)) {
                return true;
            }
            for (String operation : rawOperations) {
                if (!dataSource.getOperations().contains(DataSourceOperation.valueOf((String)operation.toUpperCase()))) continue;
                return true;
            }
            return false;
        }).map(DataSourceDeclarationDto::new).collect(Collectors.toList());
        return new CountedResult((long)dtos.size(), new PaginatedList(dtos, limit).getRange(start));
    }

    @RequestMapping(value={"{id}"}, method={RequestMethod.GET})
    @Transactional
    @ResponseBody
    public DataSourceDto getDataSource(@PathVariable String id) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        DataSourceDeclaration declaration = this.dataSourceService.getDeclaration(id);
        DataSourceInstance instance = this.dataSourceService.getDataSource(id);
        return new DataSourceDto(new DataSourceDeclarationDto(declaration), instance.getInputParameters(), instance.getOutputParameters());
    }

    @RequestMapping(value={"tree"}, method={RequestMethod.GET})
    @ResponseBody
    public DataSourceTree getDataSources() {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        List components = this.registry.getDataSources();
        List declarations = this.dataSourceService.getDeclarations();
        List dtos = declarations.stream().filter(declaration -> components.stream().anyMatch(component -> component.getId().equals(declaration.getType()))).map(DataSourceDeclarationDto::new).collect(Collectors.toList());
        return new DataSourceTree(dtos, this.registry);
    }

    @RequestMapping(value={"declaration/{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public DataSourceDeclarationDto read(@PathVariable String id) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        return new DataSourceDeclarationDto(this.dataSourceService.getDeclaration(id));
    }

    @RequestMapping(value={"declaration/create"}, method={RequestMethod.POST})
    @ResponseBody
    public RestResult create(String form, HttpServletRequest request) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_CREATE_DATASOURCE);
        AuditParamsBuilder auditParamsBuilder = new AuditParamsBuilder();
        this.authorizationHelper.assertFullAdministrationRights(() -> auditBuilder.buildFailure(request));
        try {
            DataSourceDeclaration dataSourcedeclaration = this.reader.readDataSource(form);
            auditParamsBuilder.params(this.paramsFromDeclaration(dataSourcedeclaration));
            if (this.registry.getDataSource(dataSourcedeclaration.getType()) == null) {
                request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildFailure());
                return new RestResult(false, this.messageHelper.getMessage("datasources-type-notexists", new Object[]{dataSourcedeclaration.getType()}));
            }
            String id = dataSourcedeclaration.getId();
            if (this.dataSourceExists(id)) {
                request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildFailure());
                return new RestResult(false, this.messageHelper.getMessage("Zrodlo_danych_istnieje", new Object[]{id}));
            }
            try {
                this.dataSourceService.addDeclaration(dataSourcedeclaration);
            }
            catch (DataSourceValidateException e) {
                request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildFailure());
                return new RestResult(false, e.getMessage());
            }
            request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildSuccess());
            return new RestResult(true, this.messageHelper.getMessage("Pomyslnie_utworzono_zrodlo_danych"));
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildFailure());
            throw e;
        }
    }

    private boolean dataSourceExists(String id) {
        return this.dataSourceService.getDeclaration(id) != null;
    }

    @RequestMapping(value={"declaration/update"}, method={RequestMethod.POST})
    @ResponseBody
    public RestResult save(String form, HttpServletRequest request) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_UPDATE_DATASOURCE);
        AuditParamsBuilder auditParamsBuilder = new AuditParamsBuilder();
        this.authorizationHelper.assertFullAdministrationRights(() -> auditBuilder.buildFailure(request));
        try {
            DataSourceDeclaration declarationToSave = this.reader.readDataSource(form);
            auditParamsBuilder.param("id", (Object)declarationToSave.getId());
            DataSourceDeclaration oldDeclaration = this.dataSourceService.getDeclaration(declarationToSave.getId());
            auditParamsBuilder.params(this.paramsFromDeclaration(oldDeclaration, declarationToSave));
            try {
                this.dataSourceService.updateDeclaration(declarationToSave);
            }
            catch (DataSourceValidateException e) {
                request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildFailure());
                return new RestResult(false, e.getMessage());
            }
            request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildSuccess());
            return new RestResult(true, this.messageHelper.getMessage("Pomyslnie_zapisano_zrodlo_danych"));
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildFailure());
            throw e;
        }
    }

    @RequestMapping(value={"declaration/{id}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void delete(@PathVariable String id, HttpServletRequest request) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_DATASOURCE).params(new AuditParamsBuilder().param("id", (Object)id).build());
        this.authorizationHelper.assertFullAdministrationRights(() -> auditBuilder.buildFailure(request));
        try {
            this.dataSourceService.removeDeclaration(this.dataSourceService.getDeclaration(id));
            request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
    }

    @RequestMapping(value={"definitions"}, method={RequestMethod.GET})
    @ResponseBody
    public List<DataSourceTypeDto> getTypes(@RequestParam(required=false) String query, @RequestParam(required=false) Integer start, @RequestParam(required=false) Integer limit) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        List components = this.registry.getDataSources().stream().filter(component -> !component.isDeprecated() && this.isDataSourceMatchesQuery((InvocableDataSource)component, query)).sorted((c1, c2) -> c1.getName().compareToIgnoreCase(c2.getName())).collect(Collectors.toList());
        return new PaginatedList(components.stream().map(dataSource -> new DataSourceTypeDto(dataSource.getId(), dataSource.getName(), dataSource.getDescription())).collect(Collectors.toList()), limit).getRange(start);
    }

    private boolean isDataSourceMatchesQuery(InvocableDataSource dataSource, String query) {
        if (StringUtils.isBlank((CharSequence)query)) {
            return true;
        }
        if (dataSource.getId().toLowerCase().contains(query.toLowerCase())) {
            return true;
        }
        if (dataSource.getName().toLowerCase().contains(query.toLowerCase())) {
            return true;
        }
        return dataSource.getDescription().toLowerCase().contains(query.toLowerCase());
    }

    @RequestMapping(value={"definition/{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public DataSourceDefinitionDto getType(@PathVariable String id) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        InvocableDataSource component = this.registry.getDataSource(id);
        if (component == null) {
            return null;
        }
        return new DataSourceDefinitionDto(component);
    }

    @RequestMapping(value={"declarations/export/all"}, method={RequestMethod.POST})
    @Transactional
    @ResponseBody
    public String exportDeclarations() throws IOException {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        InputStream is = this.configurationTransferService.exportDeclarations();
        return this.putInCache(is);
    }

    @RequestMapping(value={"declarations/export"}, method={RequestMethod.POST})
    @Transactional
    @ResponseBody
    public String exportDeclarations(@RequestBody List<DataSourceExportDto> exportResources) throws IOException {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        List declarations = exportResources.stream().flatMap(resource -> {
            if (resource.isDefinition()) {
                return this.dataSourceService.getDeclarations(resource.getId()).stream().map(DataSourceDeclarationDto::new);
            }
            DataSourceDeclaration declaration = this.dataSourceService.getDeclaration(resource.getId());
            return Stream.of(new DataSourceDeclarationDto(declaration));
        }).toList();
        InputStream is = this.configurationTransferService.exportDeclarations(declarations);
        return this.putInCache(is);
    }

    private String putInCache(InputStream inputStream) {
        return this.exportCache.put("datasources.json", inputStream).toString();
    }

    @RequestMapping(value={"declarations/download/{uuid}"}, method={RequestMethod.GET})
    @ResponseBody
    public DownloadResource download(@PathVariable String uuid) throws IOException {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        UUID id = UUID.fromString(uuid);
        TempFileStream tempFileStream = (TempFileStream)this.exportCache.getStream(id, true).orElseThrow(() -> new HttpServerErrorException((HttpStatusCode)HttpStatus.NOT_FOUND));
        return new DownloadResource(tempFileStream);
    }

    @ResponseBody
    @Transactional
    @RequestMapping(value={"declarations/import"}, method={RequestMethod.POST})
    public RestResult importDeclarations(@RequestParam(value="file") MultipartFile file, @RequestParam(value="overwrite", required=false) boolean overwrite, HttpServletRequest request) throws JsonProcessingException {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_IMPORT_DATASOURCE);
        AuditParamsBuilder auditParamsBuilder = new AuditParamsBuilder();
        this.authorizationHelper.assertFullAdministrationRights(() -> auditBuilder.buildFailure(request));
        try {
            String json = IOUtils.toString((InputStream)file.getInputStream(), (String)StandardCharsets.UTF_8.name());
            List declarations = this.reader.readDataSources(json);
            log.info("Read {} datasources from file", (Object)declarations.size());
            DataSourceImportResult importResult = this.configurationTransferService.importDeclaration(declarations, overwrite);
            Object message = this.messageHelper.getMessage("datasources-import-success", new Object[]{importResult.getNumberOfImportedSources()});
            if (overwrite) {
                message = (String)message + "[br]" + this.messageHelper.getMessage("datasources-overwrite-success", new Object[]{importResult.getNumberOfOverwrittenSources()});
            }
            auditParamsBuilder.param("imported", (Object)importResult.getNumberOfImportedSources());
            auditParamsBuilder.param("overwritten", (Object)importResult.getNumberOfOverwrittenSources());
            request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildSuccess());
            return new RestResult(true, (String)message);
        }
        catch (InvalidComponentException | IOException e) {
            log.error(e.getMessage(), e);
            request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildFailure());
            return new RestResult(false, this.messageHelper.getMessage("datasources-import-invalid-file"));
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildFailure());
            throw e;
        }
    }

    @RequestMapping(value={"temporary/create"}, method={RequestMethod.POST})
    @ResponseBody
    public EntityRestResult<TemporaryDataSource> cacheAndGetParameters(@RequestParam String form) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        try {
            DataSourceDeclaration declaration = this.reader.readDataSource(form);
            EntityRestResult result = new EntityRestResult(true);
            result.setEntity((Object)this.temporaryDataSourceExecutor.executeDataSource(declaration));
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return new EntityRestResult(false, this.messageHelper.getMessage("datasources-execute-exception"));
        }
    }

    @RequestMapping(value={"temporary/{uuid}/{operation}"}, method={RequestMethod.POST})
    @ResponseBody
    public RestResult executeDataSourceModification(@PathVariable String uuid, @PathVariable String operation, @RequestBody MultiValueMap<String, String> parameters) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        Object message = "";
        try {
            this.temporaryDataSourceExecutor.executeDataSourceModification(uuid, DataSourceOperation.valueOf((String)operation.toUpperCase()), parameters.toSingleValueMap());
            return new RestResult(true, (String)message);
        }
        catch (DataSourceCacheExpiredException e) {
            message = this.messageHelper.getMessage("datasources-cache-expired");
            log.info(e.getMessage());
        }
        catch (Exception e) {
            message = this.messageHelper.getMessage("Nieznany_blad") + "<br>" + e.getMessage();
            log.error(e.getMessage(), (Throwable)e);
        }
        return new RestResult(false, (String)message);
    }

    @RequestMapping(value={"temporary/{uuid}/data"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResultDto<Map<String, Object>> getDataSourceData(@PathVariable String uuid, @RequestParam Integer start, @RequestParam Integer limit, SortDto sort) {
        if (sort.getProperty() == null) {
            return new CountedResultDto(0L, (List)Lists.newArrayList(), false, this.messageHelper.getMessage("Brak_zdefiniowanych_parametrow_wyjsciowych"));
        }
        Object message = "";
        try {
            CountedResult result = this.temporaryDataSourceExecutor.getDataSourceData(uuid, Pagination.create((Sorter)sort.getSorter(), (Integer)start, (Integer)limit));
            return new CountedResultDto(result.getTotal(), result.getData(), true, (String)message);
        }
        catch (DataSourceCacheExpiredException e) {
            message = this.messageHelper.getMessage("datasources-cache-expired");
            log.info(e.getMessage());
        }
        catch (Exception e) {
            message = this.messageHelper.getMessage("Nieznany_blad") + "<br>" + e.getMessage();
            log.error(e.getMessage(), (Throwable)e);
        }
        return new CountedResultDto(0L, (List)Lists.newArrayList(), false, (String)message);
    }

    @RequestMapping(value={"temporary/{uuid}/remove"}, method={RequestMethod.DELETE})
    @ResponseBody
    public RestResult removeTemporarySourceData(@PathVariable String uuid) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        this.temporaryDataSourceExecutor.removeDataSource(uuid);
        return new RestResult(true, "");
    }

    @ExceptionHandler(value={NotFullRightsException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ResponseBody
    public RestResult handleNotFullRightsException(NotFullRightsException e) {
        log.info(this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
        return new RestResult(false, this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
    }

    private Map<String, Object> paramsFromDeclaration(DataSourceDeclaration declaration) {
        return new AuditParamsBuilder().param("type", (Object)declaration.getType()).param("operation", (Object)declaration.getOperation().name()).param("category", (Object)this.getCategoryName(declaration)).param("name", (Object)declaration.getName()).param("description", (Object)declaration.getDescription()).param("replaceSemicolons", (Object)declaration.getReplaceSemicolonsChar()).param("cache", (Object)declaration.getAllowCache()).param("cacheExpiration", (Object)declaration.getCacheExpirationDelaySec()).build();
    }

    private Map<String, Object> paramsFromDeclaration(DataSourceDeclaration oldDeclaration, DataSourceDeclaration newDeclaration) {
        return new AuditParamsBuilder().param("type", (Object)oldDeclaration.getType(), (Object)newDeclaration.getType()).param("operation", (Object)oldDeclaration.getOperation().name(), (Object)newDeclaration.getOperation().name()).param("category", (Object)this.getCategoryName(oldDeclaration), (Object)this.getCategoryName(newDeclaration)).param("name", (Object)oldDeclaration.getName(), (Object)newDeclaration.getName()).param("description", (Object)oldDeclaration.getDescription(), (Object)newDeclaration.getDescription()).param("replaceSemicolons", (Object)oldDeclaration.getReplaceSemicolonsChar(), (Object)newDeclaration.getReplaceSemicolonsChar()).param("cache", (Object)oldDeclaration.getAllowCache(), (Object)newDeclaration.getAllowCache()).param("cacheExpiration", (Object)oldDeclaration.getCacheExpirationDelaySec(), (Object)newDeclaration.getCacheExpirationDelaySec()).build();
    }

    private String getCategoryName(DataSourceDeclaration declaration) {
        return Optional.ofNullable(declaration.getCategory()).map(DataSourceCategory::getName).orElse("");
    }

    @ConstructorProperties(value={"registry", "dataSourceService", "reader", "temporaryDataSourceExecutor", "messageHelper", "authorizationHelper", "configurationTransferService", "cacheFactory"})
    @Autowired
    public DataSourceController(WorkflowComponentRegistry registry, DataSourceService dataSourceService, DataSourceReader reader, TemporaryDataSourceExecutor temporaryDataSourceExecutor, MessageHelperBean messageHelper, AuthorizationHelper authorizationHelper, DataSourceConfigurationTransferService configurationTransferService, CacheFactory cacheFactory) {
        this.registry = registry;
        this.dataSourceService = dataSourceService;
        this.reader = reader;
        this.temporaryDataSourceExecutor = temporaryDataSourceExecutor;
        this.messageHelper = messageHelper;
        this.authorizationHelper = authorizationHelper;
        this.configurationTransferService = configurationTransferService;
        this.cacheFactory = cacheFactory;
    }
}

