/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.administration.authentication.oauth2.microsoftGraphApi;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.aad.msal4j.AuthorizationCodeParameters;
import com.microsoft.aad.msal4j.ClientCredentialFactory;
import com.microsoft.aad.msal4j.ConfidentialClientApplication;
import com.microsoft.aad.msal4j.IAuthenticationResult;
import com.microsoft.aad.msal4j.IClientCredential;
import com.suncode.pwfl.administration.authentication.microsoftGraphApi.MicrosoftGraphApiAuthentication;
import com.suncode.pwfl.administration.authentication.microsoftGraphApi.MicrosoftGraphApiAuthenticationService;
import com.suncode.pwfl.administration.system.SystemPropertiesHelper;
import com.suncode.pwfl.microsoft.graph.GraphApiClient;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.net.URI;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.servlet.view.RedirectView;
import org.springframework.web.util.UriComponentsBuilder;

@Controller
@RequestMapping(value={"/msGraphOauth2"})
public class OAuth2MicrosoftGraphApiController {
    private static final Logger log = LoggerFactory.getLogger(OAuth2MicrosoftGraphApiController.class);
    private final MicrosoftGraphApiAuthenticationService microsoftGraphApiAuthenticationService;
    private final SystemPropertiesHelper systemPropertiesHelper;
    private final GraphApiClient graphApiClient;

    @GetMapping(value={"/callback"})
    @ResponseBody
    public RedirectView authCallback(@RequestParam(value="code") String authorizationCode, @RequestParam(value="error", required=false) String error, @RequestParam(value="error_description", required=false) String errorDescription, @CookieValue(value="microsoft_graph_api_auth_id", required=false) String microsoftGraphApiAuthId) {
        UriComponentsBuilder redirectUriBuilder = ServletUriComponentsBuilder.fromCurrentContextPath().path("/Admin.do").queryParam("tab", new Object[]{"configuration"}).queryParam("microsoftGraphAuthId", new Object[]{microsoftGraphApiAuthId}).fragment("authenticationManagement");
        if (error != null) {
            log.error("B\u0142\u0105d po\u0142\u0105czenia z Microsoft Graph Api o id: " + microsoftGraphApiAuthId + ". Error: " + error);
            if (StringUtils.isNotBlank((CharSequence)errorDescription)) {
                log.error(errorDescription);
            }
            redirectUriBuilder.queryParam("error", new Object[]{"polaczenie_nieudane"});
            redirectUriBuilder.queryParam("errorMsg", new Object[]{error});
            return new RedirectView(redirectUriBuilder.toUriString());
        }
        MicrosoftGraphApiAuthentication configuration = (MicrosoftGraphApiAuthentication)this.microsoftGraphApiAuthenticationService.get((Serializable)((Object)microsoftGraphApiAuthId));
        if (configuration != null) {
            try {
                ConfidentialClientApplication app = ((ConfidentialClientApplication.Builder)ConfidentialClientApplication.builder((String)configuration.getClientId(), (IClientCredential)ClientCredentialFactory.createFromSecret((String)configuration.getDecryptedClientSecret())).authority("https://login.microsoftonline.com/" + configuration.getTenantId())).build();
                String redirectUri = this.systemPropertiesHelper.prepareHttpLinkParameter() + "/api/msGraphOauth2/callback";
                AuthorizationCodeParameters parameters = AuthorizationCodeParameters.builder((String)authorizationCode, (URI)new URI(redirectUri)).scopes(Collections.singleton("https://graph.microsoft.com/.default")).build();
                CompletableFuture future = app.acquireToken(parameters);
                IAuthenticationResult result = (IAuthenticationResult)future.get();
                String accessToken = result.accessToken();
                String refreshToken = this.extractRefreshToken(app);
                this.graphApiClient.initGraphClient(accessToken, configuration);
                this.microsoftGraphApiAuthenticationService.saveRefreshToken(refreshToken, microsoftGraphApiAuthId);
                log.info("Prawid\u0142owe po\u0142\u0105czenie z Microsoft Graph Api za pomoc\u0105 konfiguracji o id: " + microsoftGraphApiAuthId);
                redirectUriBuilder.queryParam("message", new Object[]{configuration.getDefaultConfiguration() != false ? "microsoft_graph_api_polaczenie_udane_i_zastosowane" : "microsoft_graph_api_polaczenie_udane_ale_niezastosowane"});
            }
            catch (Exception e) {
                log.error("B\u0142\u0105d po\u0142\u0105czenia z Microsoft Graph Api dla konfiguracji o id: " + microsoftGraphApiAuthId, (Throwable)e);
                redirectUriBuilder.queryParam("error", new Object[]{"polaczenie_nieudane"});
                redirectUriBuilder.queryParam("errorMsg", new Object[]{e.getMessage() != null ? e.getMessage() : e});
            }
        } else {
            log.error("Brak konfiguracji Microsoft Graph Api o id: " + microsoftGraphApiAuthId);
            redirectUriBuilder.queryParam("error", new Object[]{"polaczenie_nieudane"});
        }
        return new RedirectView(redirectUriBuilder.toUriString());
    }

    private String extractRefreshToken(ConfidentialClientApplication app) {
        try {
            Iterator fields;
            String cacheJson = app.tokenCache().serialize();
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode rootNode = objectMapper.readTree(cacheJson);
            JsonNode refreshTokenNode = rootNode.path("RefreshToken");
            if (refreshTokenNode.isObject() && (fields = refreshTokenNode.fields()).hasNext()) {
                Map.Entry entry = (Map.Entry)fields.next();
                JsonNode tokenObject = (JsonNode)entry.getValue();
                return tokenObject.path("secret").asText(null);
            }
        }
        catch (Exception ex) {
            log.warn("Failed to parse refresh token from token cache.", (Throwable)ex);
        }
        return null;
    }

    @ConstructorProperties(value={"microsoftGraphApiAuthenticationService", "systemPropertiesHelper", "graphApiClient"})
    @Autowired
    public OAuth2MicrosoftGraphApiController(MicrosoftGraphApiAuthenticationService microsoftGraphApiAuthenticationService, SystemPropertiesHelper systemPropertiesHelper, GraphApiClient graphApiClient) {
        this.microsoftGraphApiAuthenticationService = microsoftGraphApiAuthenticationService;
        this.systemPropertiesHelper = systemPropertiesHelper;
        this.graphApiClient = graphApiClient;
    }
}

