/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.struts.action;

import com.plusmpm.database.DBManagement;
import com.plusmpm.database.DocClassTable;
import com.plusmpm.database.authorization.RightTreeBuilder;
import com.plusmpm.util.Authorization;
import com.plusmpm.util.UsersManagement;
import com.suncode.pwfl.archive.ArchiveStorageService;
import com.suncode.pwfl.archive.Directory;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.database.DBUtils;
import com.suncode.pwfl.translation.configElements.TranslatedFieldType;
import com.suncode.pwfl.util.ServiceFactory;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class DocClassesAction
extends Action {
    public static Logger log = Logger.getLogger(DocClassesAction.class);
    private DocumentClassService documentClassService = ServiceFactory.getDocumentClassService();

    public List<DocumentClass> GetDocClasses(HttpServletRequest request, String userName) {
        return this.getUserDocClasses(request, userName, "");
    }

    public List<DocumentClass> getDocClasses(HttpServletRequest request, String userName, String partRightType) {
        return this.getUserDocClasses(request, userName, "." + partRightType);
    }

    private List<DocumentClass> getUserDocClasses(HttpServletRequest request, String userName, String partRightType) {
        log.info((Object)"GetDocClasses");
        ArrayList<DocumentClass> userDocClasses = new ArrayList<DocumentClass>();
        List allDocClasses = ServiceFactory.getDocumentClassService().getAll(new String[0]);
        if (allDocClasses != null) {
            for (DocumentClass docClassTable : allDocClasses) {
                int rightResult = this.getRightResult(docClassTable, userName, partRightType);
                if (StringUtils.isNotBlank((CharSequence)partRightType)) {
                    if (rightResult != 0) continue;
                    userDocClasses.add(this.completeDocument(docClassTable));
                    continue;
                }
                if (rightResult != 0 && rightResult != 1) continue;
                userDocClasses.add(this.completeDocument(docClassTable));
            }
        }
        return userDocClasses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getRightResult(DocumentClass docClassTable, String userName, String partRightType) {
        Connection connection = null;
        try {
            connection = DBUtils.connectToDB();
            String rightType = RightTreeBuilder.builder().system().archive().docClasses().custom((Object)docClassTable.getId()).build() + partRightType;
            int n = Authorization.checkRight((Connection)connection, (String)rightType, (String)userName, (boolean)false, (boolean)false);
            return n;
        }
        catch (SQLException e) {
            log.error((Object)"Error while checking rights");
            int n = -1;
            return n;
        }
        finally {
            DBUtils.closeConnection((Connection)connection);
        }
    }

    private DocumentClass completeDocument(DocumentClass docClassTable) {
        docClassTable.setName(this.documentClassService.getDocumentClassTranslation(docClassTable.getId(), TranslatedFieldType.NAME));
        docClassTable.setDescription(this.documentClassService.getDocumentClassTranslation(docClassTable.getId(), TranslatedFieldType.DESCRIPTION));
        return docClassTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList GetDocClassesForRelease(HttpServletRequest request, String sUserName) {
        int i;
        log.info((Object)"GetDocClassesForRelease");
        DBManagement dbm = new DBManagement(request);
        ArrayList alDocClasses = dbm.GetAllDocClasses();
        ArchiveStorageService as = ServiceFactory.getArchiveStorageService();
        List dirs = as.getAllDirectories(new String[0]);
        ArrayList<DocClassTable> alOutDocClasses = new ArrayList<DocClassTable>();
        HashMap<String, Directory> hmDirectories = new HashMap<String, Directory>();
        for (i = 0; i < dirs.size(); ++i) {
            Directory dirTable = (Directory)dirs.get(i);
            hmDirectories.put(dirTable.getId().toString(), dirTable);
        }
        if (alDocClasses != null) {
            for (i = 0; i < alDocClasses.size(); ++i) {
                DocClassTable docClassTable = (DocClassTable)alDocClasses.get(i);
                int iConection = -1;
                Connection connection = null;
                try {
                    connection = DBManagement.ConnectToDB();
                    String rightLevel = RightTreeBuilder.builder().system().archive().docClasses().custom((Object)docClassTable.getId()).release().archive().build();
                    iConection = Authorization.CheckRight((String)rightLevel, (String)sUserName, (boolean)false, (Connection)connection);
                }
                finally {
                    DBManagement.CloseConnection((Connection)connection);
                }
                if (iConection != 0 && iConection != 1) continue;
                String sDocClassDirId = docClassTable.getDocClassDirectoryId().toString();
                Directory directoriesTable = (Directory)hmDirectories.get(sDocClassDirId);
                docClassTable.setDocClassDirectoryName(directoriesTable.getDirectoryName());
                alOutDocClasses.add(docClassTable);
            }
        }
        log.info((Object)"GetDocClassesForRelease OK");
        return alOutDocClasses;
    }

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        log.info((Object)"******************************DocClassesAction********************");
        HttpSession session = request.getSession(false);
        if (session == null || session.getAttribute("username") == null) {
            return mapping.findForward("welcome");
        }
        String sUserName = (String)session.getAttribute("username");
        int iPageSize = UsersManagement.getUserDefinedPageSize((String)sUserName);
        List<DocumentClass> alDocClasses = this.GetDocClasses(request, sUserName);
        log.info((Object)("alDocClasses size:" + alDocClasses.size()));
        request.setAttribute("alDocClasses", alDocClasses);
        request.setAttribute("iPageSize", (Object)iPageSize);
        return mapping.findForward("showDocClasses");
    }
}

