/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.servlet.virtualtables;

import com.plusmpm.database.virtualtables.Column;
import com.plusmpm.util.virtualtables.RecordHelper;
import com.plusmpm.util.virtualtables.VColumn;
import com.plusmpm.util.virtualtables.VTManager;
import com.suncode.pwfl.transaction.support.TransactionWrapper;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class getValuesJavaScript
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    public static Logger log = Logger.getLogger(getValuesJavaScript.class);

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("plain/text");
        String tableId = request.getParameter("tableId");
        PrintWriter out = response.getWriter();
        if (tableId == null) {
            String msg = "pr\u00f3ba pobrania informacji o kolumnach. potrzebny parametr: tableId";
            log.error((Object)msg);
        } else {
            TransactionWrapper.get().doInHibernateTransaction(session -> {
                Object javascript;
                if (tableId.compareTo("") == 0 || !VTManager.exists((String)tableId)) {
                    javascript = "function getValuesColumnModel(){return emptyColumnModel;}\n";
                    javascript = (String)javascript + "function getValuesDataStore(){return emptyDataStore;}\n";
                } else {
                    RecordHelper vtr = new RecordHelper(tableId);
                    vtr.load();
                    javascript = this.createCheckColumnPlugins(tableId, vtr);
                    javascript = (String)javascript + this.addCheckColumnPlugins(tableId);
                    javascript = (String)javascript + this.createDataStoreJavaScript(tableId, vtr);
                    javascript = (String)javascript + this.createColumnModelJavaScript(tableId, vtr);
                }
                out.println((String)javascript);
            });
        }
    }

    public String createCheckColumnPlugins(String tableId, RecordHelper vtr) {
        return (String)TransactionWrapper.get().doInHibernateTransaction(session -> {
            Object result = "";
            ArrayList columns = VColumn.getColumns((String)tableId);
            for (int i = 0; i < columns.size(); ++i) {
                String colTypeId = ((Column)columns.get(i)).getType().getId();
                if (!colTypeId.contains("Boolean")) continue;
                result = (String)result + "var checkcolumn_" + ((Column)columns.get(i)).getId() + " =new Ext.grid.CheckColumn({\n";
                result = (String)result + "\theader : '" + ((Column)columns.get(i)).getName() + "',\n";
                result = (String)result + "\tdataIndex : '" + ((Column)columns.get(i)).getId() + "',\n";
                result = (String)result + "\teditor : {xtype: 'checkbox'},\n";
                result = (String)result + "\twidth : 55\n";
                result = (String)result + "});\n";
            }
            log.info((Object)("utworzono checkcolumn plugin :\n" + (String)result));
            return result;
        });
    }

    private String addCheckColumnPlugins(String tableId) {
        return (String)TransactionWrapper.get().doInHibernateTransaction(session -> {
            Object result = "";
            ArrayList columns = VColumn.getColumns((String)tableId);
            for (int i = 0; i < columns.size(); ++i) {
                String colTypeId = ((Column)columns.get(i)).getType().getId();
                if (!colTypeId.contains("Boolean")) continue;
                result = (String)result + "Ext.getCmp('valuesGrid').plugins.push(checkcolumn_" + ((Column)columns.get(i)).getId() + ");\n";
                result = (String)result + "\ncheckcolumn_" + ((Column)columns.get(i)).getId() + ".init(Ext.getCmp('valuesGrid'));\n";
            }
            log.info((Object)"dodano checkcolumn plugin\n");
            return result;
        });
    }

    private String createColumnModelJavaScript(String tableId, RecordHelper vtr) {
        Object result = "\nfunction getValuesColumnModel(){\n";
        result = (String)result + "\tvar valuesColumnModel = new Ext.grid.ColumnModel( {\n";
        result = (String)result + "\t\tdefaults : {\n";
        result = (String)result + "\t\t// becouse columns are not sortable by default\n";
        result = (String)result + "\t\t\tsortable : true\n";
        result = (String)result + "\t\t},\n";
        result = (String)result + "\t\tcolumns : [\n";
        log.info((Object)("zaczynam generowanie modelu kolumn dla tabeli o id: " + tableId));
        result = (String)result + vtr.getJsonColumnsForColumnModel();
        result = (String)result + "]\n";
        result = (String)result + "\t});\n";
        result = (String)result + "\treturn valuesColumnModel;\n";
        result = (String)result + "};\n\n";
        log.info((Object)("wygenerowano columnModel dla tabeli o id: " + tableId));
        return result;
    }

    private String createDataStoreJavaScript(String tableId, RecordHelper vtr) {
        log.info((Object)"zaczynam generowanie data store'a dla wartosci");
        Object result = "function getValuesDataStore(){\n";
        result = (String)result + "\tvaluesDataStore = new Ext.data.JsonStore( {\n";
        result = (String)result + "\t\tproxy: new Ext.data.HttpProxy({\n";
        result = (String)result + "\t\t\tmethod: 'GET',\n";
        result = (String)result + "\t\t\turl: 'com.plusmpm.servlet.virtualtables.getJsonValues.customServlet',\n";
        result = (String)result + "\t\t\ttimeout: 300000\n";
        result = (String)result + "\t\t}),\n";
        result = (String)result + "\t\t\tbaseParams: {tableId: ''},\n";
        result = (String)result + "\t\tdeletedRecords : new Array(0),\n";
        result = (String)result + "\t\troot : 'values',\n";
        result = (String)result + "\t\tidProperty : 'id',\n";
        result = (String)result + "\t\tfields : [\n";
        result = (String)result + "\t\t\t" + vtr.getJsonFieldsForDataStore();
        result = (String)result + "]\n";
        result = (String)result + "\t\t\t});\n";
        result = (String)result + "\treturn valuesDataStore;\n";
        result = (String)result + "};\n";
        log.info((Object)"wygenerowano data store'a dla wartosci");
        return result;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
    }
}

