/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.servlet;

import com.google.gson.Gson;
import com.plusmpm.database.files.ExtendedDocumentData;
import com.plusmpm.struts.action.ShowDocumentInformationAction;
import com.plusmpm.util.IndexData;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.FileService;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.translation.configElements.TranslatedFieldType;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.util.SpringContext;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class DocumentInformationServlet
extends HttpServlet {
    public static Logger log = Logger.getLogger(DocumentInformationServlet.class);
    private static final long serialVersionUID = 6843976376597511326L;

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        HttpSession session = req.getSession(false);
        String username = (String)session.getAttribute("username");
        PrintWriter printer = resp.getWriter();
        resp.setContentType("application/json");
        resp.setCharacterEncoding("UTF-8");
        String fileId = req.getParameter("fileId");
        FileService fs = (FileService)SpringContext.getBean(FileService.class);
        WfFile f = fs.getFile(new Long(fileId), new String[]{"documentClass"});
        DocumentClass docClass = f.getDocumentClass();
        ExtendedDocumentData documentData = ShowDocumentInformationAction.getExtDocumentDataForFileId(fileId, docClass.getId().toString(), username);
        if (documentData != null) {
            String jsonData = this.convertDocumentDataToJson(documentData);
            printer.write(jsonData);
        }
    }

    private String convertDocumentDataToJson(ExtendedDocumentData documentData) {
        DocumentClassService documentClassService = ServiceFactory.getDocumentClassService();
        HashMap<String, String> baseInfo = new HashMap<String, String>();
        baseInfo.put("id", String.valueOf(documentData.getLDocumentId()));
        baseInfo.put("className", documentClassService.getDocumentClassTranslation(Long.valueOf(documentData.getLDocClassId()), TranslatedFieldType.NAME));
        baseInfo.put("version", documentData.getFileVersions().getVersion().toString());
        baseInfo.put("idxCount", String.valueOf(documentData.getAlIndecies().size()));
        ArrayList indicesInfo = new ArrayList();
        for (Object index : documentData.getAlIndecies()) {
            IndexData indexData = (IndexData)index;
            HashMap<String, String> indexInfo = new HashMap<String, String>();
            indexInfo.put("name", documentClassService.getDocumentClassIndexTranslation(Long.valueOf(indexData.getId()), TranslatedFieldType.NAME));
            indexInfo.put("value", indexData.getValue());
            indicesInfo.add(indexInfo);
        }
        Gson gson = new Gson();
        String indices = gson.toJson(indicesInfo);
        String base = gson.toJson(baseInfo);
        String jsonData = "{ success: true, baseInfo: " + base + ", indices: " + indices + " }";
        return jsonData;
    }
}

