/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.dto.administration.structure.position;

import com.suncode.pwfl.administration.structure.Position;
import com.suncode.pwfl.administration.structure.StructureService;
import com.suncode.pwfl.translation.configElements.TranslatedFieldType;
import com.suncode.pwfl.util.ServiceFactory;
import java.beans.ConstructorProperties;

public class PositionDto {
    private Long id;
    private String name;
    private String symbol;

    public static PositionDto fromDomain(Position domain) {
        StructureService structureService = ServiceFactory.getStructureService();
        return PositionDto.builder().id(domain.getId()).name(structureService.getPositionTranslation(domain.getId(), TranslatedFieldType.NAME)).symbol(domain.getSymbol()).build();
    }

    public static PositionDtoBuilder builder() {
        return new PositionDtoBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public PositionDto() {
    }

    @ConstructorProperties(value={"id", "name", "symbol"})
    public PositionDto(Long id, String name, String symbol) {
        this.id = id;
        this.name = name;
        this.symbol = symbol;
    }

    public static class PositionDtoBuilder {
        private Long id;
        private String name;
        private String symbol;

        PositionDtoBuilder() {
        }

        public PositionDtoBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public PositionDtoBuilder name(String name) {
            this.name = name;
            return this;
        }

        public PositionDtoBuilder symbol(String symbol) {
            this.symbol = symbol;
            return this;
        }

        public PositionDto build() {
            return new PositionDto(this.id, this.name, this.symbol);
        }

        public String toString() {
            return "PositionDto.PositionDtoBuilder(id=" + this.id + ", name=" + this.name + ", symbol=" + this.symbol + ")";
        }
    }
}

