/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.dto.administration;

import com.suncode.pwfl.administration.configuration.Category;
import com.suncode.pwfl.translation.TranslationSupport;
import com.suncode.pwfl.translation.TranslatorScope;
import com.suncode.pwfl.translation.Translators;
import com.suncode.pwfl.web.dto.administration.SystemParameterDto;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class CategoryDto
implements Comparable<CategoryDto> {
    private Long id;
    private String categoryName;
    private List<SystemParameterDto> systemParameters;

    public static CategoryDto create(Category category) {
        List translators = Translators.getAll((TranslatorScope)TranslatorScope.SERVER);
        Object categoryTranslation = TranslationSupport.getMessage((String)category.getKey(), (List)translators);
        if (!((String)categoryTranslation).equals(category.getKey())) {
            categoryTranslation = category.getKey() + " (" + (String)categoryTranslation + ")";
        }
        Set parameters = category.getSystemParameters();
        List parametersList = parameters.stream().map(SystemParameterDto::create).collect(Collectors.toCollection(LinkedList::new));
        CategoryDto categoryDto = new CategoryDto();
        categoryDto.setCategoryName((String)categoryTranslation);
        categoryDto.setId(category.getId());
        categoryDto.setSystemParameters(parametersList);
        return categoryDto;
    }

    @Override
    public int compareTo(CategoryDto toCompare) {
        String name1 = this.getCategoryName();
        String name2 = toCompare.getCategoryName();
        return name1.compareToIgnoreCase(name2);
    }

    public Long getId() {
        return this.id;
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public List<SystemParameterDto> getSystemParameters() {
        return this.systemParameters;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public void setSystemParameters(List<SystemParameterDto> systemParameters) {
        this.systemParameters = systemParameters;
    }
}

