/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.workflow.archive;

import com.suncode.pwfl.archive.fileName.FileNameService;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.web.dto.archive.FileNameTemplateDto;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import com.suncode.pwfl.web.security.exception.NotFullRightsException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.beans.ConstructorProperties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"documents/classes/{documentClassId}/fileNameTemplate"})
@Api(tags={"document classes"})
public class FileNameController {
    private static final Logger log = LoggerFactory.getLogger(FileNameController.class);
    private final AuthorizationHelper authorizationHelper;
    private final FileNameService fileNameService;
    private final MessageHelperBean messageHelper;

    @GetMapping
    @ApiOperation(value="Fetching the file name template configuration for the document class.", notes="Returns configured file name template for the given document class.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="No configuration for the given document class.")})
    public FileNameTemplateDto getTemplate(@ApiParam(value="Document class id", required=true) @PathVariable Long documentClassId) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {
            log.warn("Brak uprawnie\u0144 do pobrania szablonu nazwy pliku dla klasy dokument\u00f3w {}", (Object)documentClassId);
            throw new NotFullRightsException(this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
        });
        String template = this.fileNameService.getFileNameTemplateForDocumentClass(documentClassId);
        return FileNameTemplateDto.builder().documentClassId(documentClassId).template(template).build();
    }

    @PostMapping
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ApiOperation(value="Save file name template configuration.", notes="Saves the file name template for the specified document class. The request body content is a String with the template.")
    @ApiResponses(value={@ApiResponse(code=204, message="Configuration saved"), @ApiResponse(code=400, message="Invalid input data")})
    public void saveTemplate(@ApiParam(value="Document class id", required=true) @PathVariable Long documentClassId, @ApiParam(value="File name template", required=true) @RequestBody String template) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {
            log.warn("Brak uprawnie\u0144 do zapisu szablonu nazwy pliku dla klasy dokument\u00f3w {}", (Object)documentClassId);
            throw new NotFullRightsException(this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
        });
        if (StringUtils.isBlank((CharSequence)template)) {
            throw new IllegalArgumentException(this.messageHelper.getMessage("template_cannot_be_empty"));
        }
        this.fileNameService.saveTemplate(documentClassId, template.trim());
    }

    @ConstructorProperties(value={"authorizationHelper", "fileNameService", "messageHelper"})
    @Autowired
    public FileNameController(AuthorizationHelper authorizationHelper, FileNameService fileNameService, MessageHelperBean messageHelper) {
        this.authorizationHelper = authorizationHelper;
        this.fileNameService = fileNameService;
        this.messageHelper = messageHelper;
    }
}

