/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.workflow.activity;

import com.plusmpm.database.workflow.activities.ActivityStatus;
import com.plusmpm.database.workflow.activities.ActivityStatusManagerExtended;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.util.DtoComparator;
import com.suncode.pwfl.util.Paginator;
import com.suncode.pwfl.web.dto.activity.ActivityStatusDto;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/activity/statuses"})
public class ActivityStatusController {
    private final AuthorizationHelper authorizationHelper;

    @ResponseBody
    @RequestMapping(method={RequestMethod.GET})
    public CountedResult<ActivityStatusDto> getActivityStatuses(@RequestParam String processId, @RequestParam String activityId, @RequestParam(required=false) Integer start, @RequestParam(required=false) Integer limit, @RequestParam(required=false) String orderBy, @RequestParam(required=false, defaultValue="ASC") SortDirection orderDirection) {
        return (CountedResult)this.authorizationHelper.ensureProcessAccess(processId, null, () -> {
            List activityStatusList = ActivityStatusManagerExtended.getActivityStatuses((String)processId, (String)activityId);
            activityStatusList.sort(DtoComparator.of(ActivityStatus.class, (String)orderBy, (SortDirection)orderDirection).withIgnoreCase(true));
            List activityStatusDtos = activityStatusList.stream().map(activityStatus -> ActivityStatusDto.builder().type(activityStatus.getTypeAsEnum().name()).createDate(activityStatus.getCreateDate()).acceptanceTime(activityStatus.getAcceptanceTime().toString()).message(activityStatus.getMessage()).build()).collect(Collectors.toList());
            return Paginator.forAll(activityStatusDtos).viewPageByOffset(start, limit);
        }).getBody();
    }

    @ConstructorProperties(value={"authorizationHelper"})
    @Autowired
    public ActivityStatusController(AuthorizationHelper authorizationHelper) {
        this.authorizationHelper = authorizationHelper;
    }
}

