/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.translations;

import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.translation.TranslationsService;
import com.suncode.pwfl.translation.dto.TranslationTypeDto;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import com.suncode.pwfl.web.security.exception.NotFullRightsException;
import com.suncode.pwfl.web.support.ajax.RestResult;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"/i18n/types"})
public class TranslationsController {
    private static final Logger log = LoggerFactory.getLogger(TranslationsController.class);
    private final TranslationsService translationsService;
    private final AuthorizationHelper authorizationHelper;
    private final MessageHelperBean messageHelper;

    @ResponseBody
    @RequestMapping
    public List<TranslationTypeDto> getTranslationTypes() {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        return this.translationsService.getTranslationTypes().stream().map(TranslationTypeDto::from).collect(Collectors.toList());
    }

    @ExceptionHandler(value={NotFullRightsException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    @ResponseBody
    public RestResult handleNotFullRightsException(NotFullRightsException e) {
        log.info(this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
        return new RestResult(false, this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
    }

    @ConstructorProperties(value={"translationsService", "authorizationHelper", "messageHelper"})
    @Autowired
    public TranslationsController(TranslationsService translationsService, AuthorizationHelper authorizationHelper, MessageHelperBean messageHelper) {
        this.translationsService = translationsService;
        this.authorizationHelper = authorizationHelper;
        this.messageHelper = messageHelper;
    }
}

